/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Report of all capabilities supported by the device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapabilityReport implements SdkPojo, Serializable,
        ToCopyableBuilder<CapabilityReport.Builder, CapabilityReport> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CapabilityReport::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nodeId")
            .getter(getter(CapabilityReport::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeId").build()).build();

    private static final SdkField<List<CapabilityReportEndpoint>> ENDPOINTS_FIELD = SdkField
            .<List<CapabilityReportEndpoint>> builder(MarshallingType.LIST)
            .memberName("endpoints")
            .getter(getter(CapabilityReport::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapabilityReportEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapabilityReportEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, NODE_ID_FIELD,
            ENDPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String version;

    private final String nodeId;

    private final List<CapabilityReportEndpoint> endpoints;

    private CapabilityReport(BuilderImpl builder) {
        this.version = builder.version;
        this.nodeId = builder.nodeId;
        this.endpoints = builder.endpoints;
    }

    /**
     * <p>
     * The version of the capability report.
     * </p>
     * 
     * @return The version of the capability report.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The numeric identifier of the node.
     * </p>
     * 
     * @return The numeric identifier of the node.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The endpoints used in the capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The endpoints used in the capability report.
     */
    public final List<CapabilityReportEndpoint> endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityReport)) {
            return false;
        }
        CapabilityReport other = (CapabilityReport) obj;
        return Objects.equals(version(), other.version()) && Objects.equals(nodeId(), other.nodeId())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapabilityReport").add("Version", version()).add("NodeId", nodeId())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "nodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("version", VERSION_FIELD);
        map.put("nodeId", NODE_ID_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilityReport, T> g) {
        return obj -> g.apply((CapabilityReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapabilityReport> {
        /**
         * <p>
         * The version of the capability report.
         * </p>
         * 
         * @param version
         *        The version of the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The numeric identifier of the node.
         * </p>
         * 
         * @param nodeId
         *        The numeric identifier of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The endpoints used in the capability report.
         * </p>
         * 
         * @param endpoints
         *        The endpoints used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<CapabilityReportEndpoint> endpoints);

        /**
         * <p>
         * The endpoints used in the capability report.
         * </p>
         * 
         * @param endpoints
         *        The endpoints used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(CapabilityReportEndpoint... endpoints);

        /**
         * <p>
         * The endpoints used in the capability report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportEndpoint.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportEndpoint.Builder#build()}
         * is called immediately and its result is passed to {@link #endpoints(List<CapabilityReportEndpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.CapabilityReportEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(java.util.Collection<CapabilityReportEndpoint>)
         */
        Builder endpoints(Consumer<CapabilityReportEndpoint.Builder>... endpoints);
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private String nodeId;

        private List<CapabilityReportEndpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityReport model) {
            version(model.version);
            nodeId(model.nodeId);
            endpoints(model.endpoints);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final List<CapabilityReportEndpoint.Builder> getEndpoints() {
            List<CapabilityReportEndpoint.Builder> result = CapabilityReportEndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<CapabilityReportEndpoint.BuilderImpl> endpoints) {
            this.endpoints = CapabilityReportEndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<CapabilityReportEndpoint> endpoints) {
            this.endpoints = CapabilityReportEndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(CapabilityReportEndpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<CapabilityReportEndpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> CapabilityReportEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CapabilityReport build() {
            return new CapabilityReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
