/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The capability used in capability report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapabilityReportCapability implements SdkPojo, Serializable,
        ToCopyableBuilder<CapabilityReportCapability.Builder, CapabilityReportCapability> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CapabilityReportCapability::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CapabilityReportCapability::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(CapabilityReportCapability::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<List<String>> PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("properties")
            .getter(getter(CapabilityReportCapability::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(CapabilityReportCapability::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(CapabilityReportCapability::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            VERSION_FIELD, PROPERTIES_FIELD, ACTIONS_FIELD, EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String version;

    private final List<String> properties;

    private final List<String> actions;

    private final List<String> events;

    private CapabilityReportCapability(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.version = builder.version;
        this.properties = builder.properties;
        this.actions = builder.actions;
        this.events = builder.events;
    }

    /**
     * <p>
     * The id of the schema version.
     * </p>
     * 
     * @return The id of the schema version.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the capability.
     * </p>
     * 
     * @return The name of the capability.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the capability.
     * </p>
     * 
     * @return The version of the capability.
     */
    public final String version() {
        return version;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capability properties used in the capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The capability properties used in the capability report.
     */
    public final List<String> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capability actions used in the capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The capability actions used in the capability report.
     */
    public final List<String> actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capability events used in the capability report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The capability events used in the capability report.
     */
    public final List<String> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityReportCapability)) {
            return false;
        }
        CapabilityReportCapability other = (CapabilityReportCapability) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapabilityReportCapability").add("Id", id()).add("Name", name()).add("Version", version())
                .add("Properties", hasProperties() ? properties() : null).add("Actions", hasActions() ? actions() : null)
                .add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapabilityReportCapability, T> g) {
        return obj -> g.apply((CapabilityReportCapability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapabilityReportCapability> {
        /**
         * <p>
         * The id of the schema version.
         * </p>
         * 
         * @param id
         *        The id of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the capability.
         * </p>
         * 
         * @param name
         *        The name of the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the capability.
         * </p>
         * 
         * @param version
         *        The version of the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The capability properties used in the capability report.
         * </p>
         * 
         * @param properties
         *        The capability properties used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<String> properties);

        /**
         * <p>
         * The capability properties used in the capability report.
         * </p>
         * 
         * @param properties
         *        The capability properties used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String... properties);

        /**
         * <p>
         * The capability actions used in the capability report.
         * </p>
         * 
         * @param actions
         *        The capability actions used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The capability actions used in the capability report.
         * </p>
         * 
         * @param actions
         *        The capability actions used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * The capability events used in the capability report.
         * </p>
         * 
         * @param events
         *        The capability events used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<String> events);

        /**
         * <p>
         * The capability events used in the capability report.
         * </p>
         * 
         * @param events
         *        The capability events used in the capability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(String... events);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String version;

        private List<String> properties = DefaultSdkAutoConstructList.getInstance();

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private List<String> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityReportCapability model) {
            id(model.id);
            name(model.name);
            version(model.version);
            properties(model.properties);
            actions(model.actions);
            events(model.events);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getProperties() {
            if (properties instanceof SdkAutoConstructList) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Collection<String> properties) {
            this.properties = CapabilityReportPropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Collection<String> properties) {
            this.properties = CapabilityReportPropertiesCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(String... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = CapabilityReportActionsCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = CapabilityReportActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final Collection<String> getEvents() {
            if (events instanceof SdkAutoConstructList) {
                return null;
            }
            return events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = CapabilityReportEventsCopier.copy(events);
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = CapabilityReportEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        public CapabilityReportCapability build() {
            return new CapabilityReportCapability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
