/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure containing summary information about a connector destination, which defines how a cloud-to-cloud connector
 * connects to a customer's AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorDestinationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorDestinationSummary.Builder, ConnectorDestinationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ConnectorDestinationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ConnectorDestinationSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLOUD_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudConnectorId").getter(getter(ConnectorDestinationSummary::cloudConnectorId))
            .setter(setter(Builder::cloudConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudConnectorId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ConnectorDestinationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CLOUD_CONNECTOR_ID_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String cloudConnectorId;

    private final String id;

    private ConnectorDestinationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.cloudConnectorId = builder.cloudConnectorId;
        this.id = builder.id;
    }

    /**
     * <p>
     * The display name of the connector destination.
     * </p>
     * 
     * @return The display name of the connector destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the connector destination.
     * </p>
     * 
     * @return A description of the connector destination.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the cloud connector associated with this connector destination.
     * </p>
     * 
     * @return The identifier of the cloud connector associated with this connector destination.
     */
    public final String cloudConnectorId() {
        return cloudConnectorId;
    }

    /**
     * <p>
     * The unique identifier of the connector destination.
     * </p>
     * 
     * @return The unique identifier of the connector destination.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cloudConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorDestinationSummary)) {
            return false;
        }
        ConnectorDestinationSummary other = (ConnectorDestinationSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(cloudConnectorId(), other.cloudConnectorId()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorDestinationSummary").add("Name", name()).add("Description", description())
                .add("CloudConnectorId", cloudConnectorId()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CloudConnectorId":
            return Optional.ofNullable(clazz.cast(cloudConnectorId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CloudConnectorId", CLOUD_CONNECTOR_ID_FIELD);
        map.put("Id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorDestinationSummary, T> g) {
        return obj -> g.apply((ConnectorDestinationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorDestinationSummary> {
        /**
         * <p>
         * The display name of the connector destination.
         * </p>
         * 
         * @param name
         *        The display name of the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the connector destination.
         * </p>
         * 
         * @param description
         *        A description of the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the cloud connector associated with this connector destination.
         * </p>
         * 
         * @param cloudConnectorId
         *        The identifier of the cloud connector associated with this connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudConnectorId(String cloudConnectorId);

        /**
         * <p>
         * The unique identifier of the connector destination.
         * </p>
         * 
         * @param id
         *        The unique identifier of the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String cloudConnectorId;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorDestinationSummary model) {
            name(model.name);
            description(model.description);
            cloudConnectorId(model.cloudConnectorId);
            id(model.id);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCloudConnectorId() {
            return cloudConnectorId;
        }

        public final void setCloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
        }

        @Override
        public final Builder cloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ConnectorDestinationSummary build() {
            return new ConnectorDestinationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
