/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudConnectorRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<CreateCloudConnectorRequest.Builder, CreateCloudConnectorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCloudConnectorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<EndpointConfig> ENDPOINT_CONFIG_FIELD = SdkField
            .<EndpointConfig> builder(MarshallingType.SDK_POJO).memberName("EndpointConfig")
            .getter(getter(CreateCloudConnectorRequest::endpointConfig)).setter(setter(Builder::endpointConfig))
            .constructor(EndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfig").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCloudConnectorRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(CreateCloudConnectorRequest::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateCloudConnectorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ENDPOINT_CONFIG_FIELD, DESCRIPTION_FIELD, ENDPOINT_TYPE_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final EndpointConfig endpointConfig;

    private final String description;

    private final String endpointType;

    private final String clientToken;

    private CreateCloudConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.endpointConfig = builder.endpointConfig;
        this.description = builder.description;
        this.endpointType = builder.endpointType;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The display name of the C2C connector.
     * </p>
     * 
     * @return The display name of the C2C connector.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration details for the cloud connector endpoint, including connection parameters and authentication
     * requirements.
     * </p>
     * 
     * @return The configuration details for the cloud connector endpoint, including connection parameters and
     *         authentication requirements.
     */
    public final EndpointConfig endpointConfig() {
        return endpointConfig;
    }

    /**
     * <p>
     * A description of the C2C connector.
     * </p>
     * 
     * @return A description of the C2C connector.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of endpoint used for the cloud connector, which defines how the connector communicates with external
     * services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint used for the cloud connector, which defines how the connector communicates with
     *         external services.
     * @see EndpointType
     */
    public final EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint used for the cloud connector, which defines how the connector communicates with external
     * services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint used for the cloud connector, which defines how the connector communicates with
     *         external services.
     * @see EndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * An idempotency token. If you retry a request that completed successfully initially using the same client token
     * and parameters, then the retry attempt will succeed without performing any further actions.
     * </p>
     * 
     * @return An idempotency token. If you retry a request that completed successfully initially using the same client
     *         token and parameters, then the retry attempt will succeed without performing any further actions.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudConnectorRequest)) {
            return false;
        }
        CreateCloudConnectorRequest other = (CreateCloudConnectorRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(endpointConfig(), other.endpointConfig())
                && Objects.equals(description(), other.description())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudConnectorRequest").add("Name", name()).add("EndpointConfig", endpointConfig())
                .add("Description", description()).add("EndpointType", endpointTypeAsString()).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EndpointConfig":
            return Optional.ofNullable(clazz.cast(endpointConfig()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("EndpointConfig", ENDPOINT_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EndpointType", ENDPOINT_TYPE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudConnectorRequest, T> g) {
        return obj -> g.apply((CreateCloudConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudConnectorRequest> {
        /**
         * <p>
         * The display name of the C2C connector.
         * </p>
         * 
         * @param name
         *        The display name of the C2C connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration details for the cloud connector endpoint, including connection parameters and
         * authentication requirements.
         * </p>
         * 
         * @param endpointConfig
         *        The configuration details for the cloud connector endpoint, including connection parameters and
         *        authentication requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfig(EndpointConfig endpointConfig);

        /**
         * <p>
         * The configuration details for the cloud connector endpoint, including connection parameters and
         * authentication requirements.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointConfig.Builder} avoiding the need
         * to create one manually via {@link EndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointConfig(EndpointConfig)}.
         * 
         * @param endpointConfig
         *        a consumer that will call methods on {@link EndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfig(EndpointConfig)
         */
        default Builder endpointConfig(Consumer<EndpointConfig.Builder> endpointConfig) {
            return endpointConfig(EndpointConfig.builder().applyMutation(endpointConfig).build());
        }

        /**
         * <p>
         * A description of the C2C connector.
         * </p>
         * 
         * @param description
         *        A description of the C2C connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of endpoint used for the cloud connector, which defines how the connector communicates with external
         * services.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint used for the cloud connector, which defines how the connector communicates with
         *        external services.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint used for the cloud connector, which defines how the connector communicates with external
         * services.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint used for the cloud connector, which defines how the connector communicates with
         *        external services.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * An idempotency token. If you retry a request that completed successfully initially using the same client
         * token and parameters, then the retry attempt will succeed without performing any further actions.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token. If you retry a request that completed successfully initially using the same
         *        client token and parameters, then the retry attempt will succeed without performing any further
         *        actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String name;

        private EndpointConfig endpointConfig;

        private String description;

        private String endpointType;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudConnectorRequest model) {
            super(model);
            name(model.name);
            endpointConfig(model.endpointConfig);
            description(model.description);
            endpointType(model.endpointType);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EndpointConfig.Builder getEndpointConfig() {
            return endpointConfig != null ? endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(EndpointConfig.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudConnectorRequest build() {
            return new CreateCloudConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
