/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDestinationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<CreateDestinationRequest.Builder, CreateDestinationRequest> {
    private static final SdkField<String> DELIVERY_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryDestinationArn").getter(getter(CreateDestinationRequest::deliveryDestinationArn))
            .setter(setter(Builder::deliveryDestinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationArn").build())
            .build();

    private static final SdkField<String> DELIVERY_DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryDestinationType").getter(getter(CreateDestinationRequest::deliveryDestinationTypeAsString))
            .setter(setter(Builder::deliveryDestinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryDestinationType").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDestinationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateDestinationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateDestinationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateDestinationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDestinationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELIVERY_DESTINATION_ARN_FIELD, DELIVERY_DESTINATION_TYPE_FIELD, NAME_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deliveryDestinationArn;

    private final String deliveryDestinationType;

    private final String name;

    private final String roleArn;

    private final String clientToken;

    private final String description;

    private final Map<String, String> tags;

    private CreateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryDestinationArn = builder.deliveryDestinationArn;
        this.deliveryDestinationType = builder.deliveryDestinationType;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer-managed destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the customer-managed destination.
     */
    public final String deliveryDestinationArn() {
        return deliveryDestinationArn;
    }

    /**
     * <p>
     * The destination type for the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryDestinationType} will return {@link DeliveryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliveryDestinationTypeAsString}.
     * </p>
     * 
     * @return The destination type for the customer-managed destination.
     * @see DeliveryDestinationType
     */
    public final DeliveryDestinationType deliveryDestinationType() {
        return DeliveryDestinationType.fromValue(deliveryDestinationType);
    }

    /**
     * <p>
     * The destination type for the customer-managed destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryDestinationType} will return {@link DeliveryDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deliveryDestinationTypeAsString}.
     * </p>
     * 
     * @return The destination type for the customer-managed destination.
     * @see DeliveryDestinationType
     */
    public final String deliveryDestinationTypeAsString() {
        return deliveryDestinationType;
    }

    /**
     * <p>
     * The name of the customer-managed destination.
     * </p>
     * 
     * @return The name of the customer-managed destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the delivery destination role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the delivery destination role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An idempotency token. If you retry a request that completed successfully initially using the same client token
     * and parameters, then the retry attempt will succeed without performing any further actions.
     * </p>
     * 
     * @return An idempotency token. If you retry a request that completed successfully initially using the same client
     *         token and parameters, then the retry attempt will succeed without performing any further actions.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the customer-managed destination.
     * </p>
     * 
     * @return The description of the customer-managed destination.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     *
     * @deprecated Tags have been deprecated from this api
     */
    @Deprecated
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the destination.
     * @deprecated Tags have been deprecated from this api
     */
    @Deprecated
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDestinationRequest)) {
            return false;
        }
        CreateDestinationRequest other = (CreateDestinationRequest) obj;
        return Objects.equals(deliveryDestinationArn(), other.deliveryDestinationArn())
                && Objects.equals(deliveryDestinationTypeAsString(), other.deliveryDestinationTypeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDestinationRequest").add("DeliveryDestinationArn", deliveryDestinationArn())
                .add("DeliveryDestinationType", deliveryDestinationTypeAsString()).add("Name", name()).add("RoleArn", roleArn())
                .add("ClientToken", clientToken()).add("Description", description())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryDestinationArn":
            return Optional.ofNullable(clazz.cast(deliveryDestinationArn()));
        case "DeliveryDestinationType":
            return Optional.ofNullable(clazz.cast(deliveryDestinationTypeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryDestinationArn", DELIVERY_DESTINATION_ARN_FIELD);
        map.put("DeliveryDestinationType", DELIVERY_DESTINATION_TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDestinationRequest, T> g) {
        return obj -> g.apply((CreateDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDestinationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer-managed destination.
         * </p>
         * 
         * @param deliveryDestinationArn
         *        The Amazon Resource Name (ARN) of the customer-managed destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationArn(String deliveryDestinationArn);

        /**
         * <p>
         * The destination type for the customer-managed destination.
         * </p>
         * 
         * @param deliveryDestinationType
         *        The destination type for the customer-managed destination.
         * @see DeliveryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryDestinationType
         */
        Builder deliveryDestinationType(String deliveryDestinationType);

        /**
         * <p>
         * The destination type for the customer-managed destination.
         * </p>
         * 
         * @param deliveryDestinationType
         *        The destination type for the customer-managed destination.
         * @see DeliveryDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryDestinationType
         */
        Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType);

        /**
         * <p>
         * The name of the customer-managed destination.
         * </p>
         * 
         * @param name
         *        The name of the customer-managed destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the delivery destination role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the delivery destination role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An idempotency token. If you retry a request that completed successfully initially using the same client
         * token and parameters, then the retry attempt will succeed without performing any further actions.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token. If you retry a request that completed successfully initially using the same
         *        client token and parameters, then the retry attempt will succeed without performing any further
         *        actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the customer-managed destination.
         * </p>
         * 
         * @param description
         *        The description of the customer-managed destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A set of key/value pairs that are used to manage the destination.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Tags have been deprecated from this api
         */
        @Deprecated
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String deliveryDestinationArn;

        private String deliveryDestinationType;

        private String name;

        private String roleArn;

        private String clientToken;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDestinationRequest model) {
            super(model);
            deliveryDestinationArn(model.deliveryDestinationArn);
            deliveryDestinationType(model.deliveryDestinationType);
            name(model.name);
            roleArn(model.roleArn);
            clientToken(model.clientToken);
            description(model.description);
            tags(model.tags);
        }

        public final String getDeliveryDestinationArn() {
            return deliveryDestinationArn;
        }

        public final void setDeliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
        }

        @Override
        public final Builder deliveryDestinationArn(String deliveryDestinationArn) {
            this.deliveryDestinationArn = deliveryDestinationArn;
            return this;
        }

        public final String getDeliveryDestinationType() {
            return deliveryDestinationType;
        }

        public final void setDeliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
        }

        @Override
        public final Builder deliveryDestinationType(String deliveryDestinationType) {
            this.deliveryDestinationType = deliveryDestinationType;
            return this;
        }

        @Override
        public final Builder deliveryDestinationType(DeliveryDestinationType deliveryDestinationType) {
            this.deliveryDestinationType(deliveryDestinationType == null ? null : deliveryDestinationType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDestinationRequest build() {
            return new CreateDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
