/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for an endpoint, which defines how to connect to and communicate with external services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointConfig implements SdkPojo, Serializable, ToCopyableBuilder<EndpointConfig.Builder, EndpointConfig> {
    private static final SdkField<LambdaConfig> LAMBDA_FIELD = SdkField.<LambdaConfig> builder(MarshallingType.SDK_POJO)
            .memberName("lambda").getter(getter(EndpointConfig::lambda)).setter(setter(Builder::lambda))
            .constructor(LambdaConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LambdaConfig lambda;

    private EndpointConfig(BuilderImpl builder) {
        this.lambda = builder.lambda;
    }

    /**
     * <p>
     * The Lambda function configuration for the endpoint, used when the endpoint communicates through an AWS Lambda
     * function.
     * </p>
     * 
     * @return The Lambda function configuration for the endpoint, used when the endpoint communicates through an AWS
     *         Lambda function.
     */
    public final LambdaConfig lambda() {
        return lambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfig)) {
            return false;
        }
        EndpointConfig other = (EndpointConfig) obj;
        return Objects.equals(lambda(), other.lambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointConfig").add("Lambda", lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambda", LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointConfig, T> g) {
        return obj -> g.apply((EndpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointConfig> {
        /**
         * <p>
         * The Lambda function configuration for the endpoint, used when the endpoint communicates through an AWS Lambda
         * function.
         * </p>
         * 
         * @param lambda
         *        The Lambda function configuration for the endpoint, used when the endpoint communicates through an AWS
         *        Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaConfig lambda);

        /**
         * <p>
         * The Lambda function configuration for the endpoint, used when the endpoint communicates through an AWS Lambda
         * function.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaConfig.Builder} avoiding the need
         * to create one manually via {@link LambdaConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #lambda(LambdaConfig)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaConfig)
         */
        default Builder lambda(Consumer<LambdaConfig.Builder> lambda) {
            return lambda(LambdaConfig.builder().applyMutation(lambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaConfig lambda;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfig model) {
            lambda(model.lambda);
        }

        public final LambdaConfig.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaConfig.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaConfig lambda) {
            this.lambda = lambda;
            return this;
        }

        @Override
        public EndpointConfig build() {
            return new EndpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
