/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountAssociationResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetAccountAssociationResponse.Builder, GetAccountAssociationResponse> {
    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountAssociationId").getter(getter(GetAccountAssociationResponse::accountAssociationId))
            .setter(setter(Builder::accountAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build())
            .build();

    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationState").getter(getter(GetAccountAssociationResponse::associationStateAsString))
            .setter(setter(Builder::associationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(GetAccountAssociationResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> CONNECTOR_DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorDestinationId").getter(getter(GetAccountAssociationResponse::connectorDestinationId))
            .setter(setter(Builder::connectorDestinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDestinationId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetAccountAssociationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetAccountAssociationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetAccountAssociationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> O_AUTH_AUTHORIZATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OAuthAuthorizationUrl").getter(getter(GetAccountAssociationResponse::oAuthAuthorizationUrl))
            .setter(setter(Builder::oAuthAuthorizationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthAuthorizationUrl").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetAccountAssociationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ASSOCIATION_ID_FIELD,
            ASSOCIATION_STATE_FIELD, ERROR_MESSAGE_FIELD, CONNECTOR_DESTINATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD,
            ARN_FIELD, O_AUTH_AUTHORIZATION_URL_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountAssociationId;

    private final String associationState;

    private final String errorMessage;

    private final String connectorDestinationId;

    private final String name;

    private final String description;

    private final String arn;

    private final String oAuthAuthorizationUrl;

    private final Map<String, String> tags;

    private GetAccountAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.accountAssociationId = builder.accountAssociationId;
        this.associationState = builder.associationState;
        this.errorMessage = builder.errorMessage;
        this.connectorDestinationId = builder.connectorDestinationId;
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
        this.oAuthAuthorizationUrl = builder.oAuthAuthorizationUrl;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier of the retrieved account association.
     * </p>
     * 
     * @return The unique identifier of the retrieved account association.
     */
    public final String accountAssociationId() {
        return accountAssociationId;
    }

    /**
     * <p>
     * The current status state for the account association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationState}
     * will return {@link AssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStateAsString}.
     * </p>
     * 
     * @return The current status state for the account association.
     * @see AssociationState
     */
    public final AssociationState associationState() {
        return AssociationState.fromValue(associationState);
    }

    /**
     * <p>
     * The current status state for the account association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationState}
     * will return {@link AssociationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStateAsString}.
     * </p>
     * 
     * @return The current status state for the account association.
     * @see AssociationState
     */
    public final String associationStateAsString() {
        return associationState;
    }

    /**
     * <p>
     * The error message explaining the current account association error.
     * </p>
     * 
     * @return The error message explaining the current account association error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The identifier of the connector destination associated with this account association.
     * </p>
     * 
     * @return The identifier of the connector destination associated with this account association.
     */
    public final String connectorDestinationId() {
        return connectorDestinationId;
    }

    /**
     * <p>
     * The name of the account association.
     * </p>
     * 
     * @return The name of the account association.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the account association.
     * </p>
     * 
     * @return The description of the account association.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the account association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the account association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Third party IoT platform OAuth authorization server URL backed with all the required parameters to perform
     * end-user authentication.
     * </p>
     * 
     * @return Third party IoT platform OAuth authorization server URL backed with all the required parameters to
     *         perform end-user authentication.
     */
    public final String oAuthAuthorizationUrl() {
        return oAuthAuthorizationUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the account association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the account association.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(connectorDestinationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(oAuthAuthorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountAssociationResponse)) {
            return false;
        }
        GetAccountAssociationResponse other = (GetAccountAssociationResponse) obj;
        return Objects.equals(accountAssociationId(), other.accountAssociationId())
                && Objects.equals(associationStateAsString(), other.associationStateAsString())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(connectorDestinationId(), other.connectorDestinationId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(arn(), other.arn()) && Objects.equals(oAuthAuthorizationUrl(), other.oAuthAuthorizationUrl())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccountAssociationResponse").add("AccountAssociationId", accountAssociationId())
                .add("AssociationState", associationStateAsString()).add("ErrorMessage", errorMessage())
                .add("ConnectorDestinationId", connectorDestinationId()).add("Name", name()).add("Description", description())
                .add("Arn", arn())
                .add("OAuthAuthorizationUrl", oAuthAuthorizationUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAssociationId":
            return Optional.ofNullable(clazz.cast(accountAssociationId()));
        case "AssociationState":
            return Optional.ofNullable(clazz.cast(associationStateAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ConnectorDestinationId":
            return Optional.ofNullable(clazz.cast(connectorDestinationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "OAuthAuthorizationUrl":
            return Optional.ofNullable(clazz.cast(oAuthAuthorizationUrl()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("AssociationState", ASSOCIATION_STATE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ConnectorDestinationId", CONNECTOR_DESTINATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("OAuthAuthorizationUrl", O_AUTH_AUTHORIZATION_URL_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountAssociationResponse, T> g) {
        return obj -> g.apply((GetAccountAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccountAssociationResponse> {
        /**
         * <p>
         * The unique identifier of the retrieved account association.
         * </p>
         * 
         * @param accountAssociationId
         *        The unique identifier of the retrieved account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssociationId(String accountAssociationId);

        /**
         * <p>
         * The current status state for the account association.
         * </p>
         * 
         * @param associationState
         *        The current status state for the account association.
         * @see AssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationState
         */
        Builder associationState(String associationState);

        /**
         * <p>
         * The current status state for the account association.
         * </p>
         * 
         * @param associationState
         *        The current status state for the account association.
         * @see AssociationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationState
         */
        Builder associationState(AssociationState associationState);

        /**
         * <p>
         * The error message explaining the current account association error.
         * </p>
         * 
         * @param errorMessage
         *        The error message explaining the current account association error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The identifier of the connector destination associated with this account association.
         * </p>
         * 
         * @param connectorDestinationId
         *        The identifier of the connector destination associated with this account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorDestinationId(String connectorDestinationId);

        /**
         * <p>
         * The name of the account association.
         * </p>
         * 
         * @param name
         *        The name of the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the account association.
         * </p>
         * 
         * @param description
         *        The description of the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the account association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Third party IoT platform OAuth authorization server URL backed with all the required parameters to perform
         * end-user authentication.
         * </p>
         * 
         * @param oAuthAuthorizationUrl
         *        Third party IoT platform OAuth authorization server URL backed with all the required parameters to
         *        perform end-user authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oAuthAuthorizationUrl(String oAuthAuthorizationUrl);

        /**
         * <p>
         * A set of key/value pairs that are used to manage the account association.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the account association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String accountAssociationId;

        private String associationState;

        private String errorMessage;

        private String connectorDestinationId;

        private String name;

        private String description;

        private String arn;

        private String oAuthAuthorizationUrl;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountAssociationResponse model) {
            super(model);
            accountAssociationId(model.accountAssociationId);
            associationState(model.associationState);
            errorMessage(model.errorMessage);
            connectorDestinationId(model.connectorDestinationId);
            name(model.name);
            description(model.description);
            arn(model.arn);
            oAuthAuthorizationUrl(model.oAuthAuthorizationUrl);
            tags(model.tags);
        }

        public final String getAccountAssociationId() {
            return accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getAssociationState() {
            return associationState;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(AssociationState associationState) {
            this.associationState(associationState == null ? null : associationState.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getConnectorDestinationId() {
            return connectorDestinationId;
        }

        public final void setConnectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
        }

        @Override
        public final Builder connectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOAuthAuthorizationUrl() {
            return oAuthAuthorizationUrl;
        }

        public final void setOAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
        }

        @Override
        public final Builder oAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetAccountAssociationResponse build() {
            return new GetAccountAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
