/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedThingCertificateResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetManagedThingCertificateResponse.Builder, GetManagedThingCertificateResponse> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedThingId").getter(getter(GetManagedThingCertificateResponse::managedThingId))
            .setter(setter(Builder::managedThingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedThingId").build()).build();

    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificatePem").getter(getter(GetManagedThingCertificateResponse::certificatePem))
            .setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD,
            CERTIFICATE_PEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String managedThingId;

    private final String certificatePem;

    private GetManagedThingCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.certificatePem = builder.certificatePem;
    }

    /**
     * <p>
     * The identifier of the managed thing.
     * </p>
     * 
     * @return The identifier of the managed thing.
     */
    public final String managedThingId() {
        return managedThingId;
    }

    /**
     * <p>
     * The PEM-encoded certificate for the managed thing.
     * </p>
     * 
     * @return The PEM-encoded certificate for the managed thing.
     */
    public final String certificatePem() {
        return certificatePem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedThingCertificateResponse)) {
            return false;
        }
        GetManagedThingCertificateResponse other = (GetManagedThingCertificateResponse) obj;
        return Objects.equals(managedThingId(), other.managedThingId())
                && Objects.equals(certificatePem(), other.certificatePem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedThingCertificateResponse").add("ManagedThingId", managedThingId())
                .add("CertificatePem", certificatePem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedThingId":
            return Optional.ofNullable(clazz.cast(managedThingId()));
        case "CertificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("CertificatePem", CERTIFICATE_PEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetManagedThingCertificateResponse, T> g) {
        return obj -> g.apply((GetManagedThingCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetManagedThingCertificateResponse> {
        /**
         * <p>
         * The identifier of the managed thing.
         * </p>
         * 
         * @param managedThingId
         *        The identifier of the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedThingId(String managedThingId);

        /**
         * <p>
         * The PEM-encoded certificate for the managed thing.
         * </p>
         * 
         * @param certificatePem
         *        The PEM-encoded certificate for the managed thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String managedThingId;

        private String certificatePem;

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedThingCertificateResponse model) {
            super(model);
            managedThingId(model.managedThingId);
            certificatePem(model.certificatePem);
        }

        public final String getManagedThingId() {
            return managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        @Override
        public GetManagedThingCertificateResponse build() {
            return new GetManagedThingCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
