/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProvisioningProfileResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetProvisioningProfileResponse.Builder, GetProvisioningProfileResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetProvisioningProfileResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetProvisioningProfileResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningType").getter(getter(GetProvisioningProfileResponse::provisioningTypeAsString))
            .setter(setter(Builder::provisioningType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetProvisioningProfileResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CLAIM_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClaimCertificate").getter(getter(GetProvisioningProfileResponse::claimCertificate))
            .setter(setter(Builder::claimCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClaimCertificate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetProvisioningProfileResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            PROVISIONING_TYPE_FIELD, ID_FIELD, CLAIM_CERTIFICATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String provisioningType;

    private final String id;

    private final String claimCertificate;

    private final Map<String, String> tags;

    private GetProvisioningProfileResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.provisioningType = builder.provisioningType;
        this.id = builder.id;
        this.claimCertificate = builder.claimCertificate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the provisioning template.
     * </p>
     * 
     * @return The name of the provisioning template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * @see ProvisioningType
     */
    public final ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(provisioningType);
    }

    /**
     * <p>
     * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #provisioningType}
     * will return {@link ProvisioningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #provisioningTypeAsString}.
     * </p>
     * 
     * @return The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
     * @see ProvisioningType
     */
    public final String provisioningTypeAsString() {
        return provisioningType;
    }

    /**
     * <p>
     * The provisioning profile id.
     * </p>
     * 
     * @return The provisioning profile id.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The id of the claim certificate.
     * </p>
     * 
     * @return The id of the claim certificate.
     */
    public final String claimCertificate() {
        return claimCertificate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the provisioning profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the provisioning profile.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(claimCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProvisioningProfileResponse)) {
            return false;
        }
        GetProvisioningProfileResponse other = (GetProvisioningProfileResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(provisioningTypeAsString(), other.provisioningTypeAsString())
                && Objects.equals(id(), other.id()) && Objects.equals(claimCertificate(), other.claimCertificate())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProvisioningProfileResponse").add("Arn", arn()).add("Name", name())
                .add("ProvisioningType", provisioningTypeAsString()).add("Id", id())
                .add("ClaimCertificate", claimCertificate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProvisioningType":
            return Optional.ofNullable(clazz.cast(provisioningTypeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ClaimCertificate":
            return Optional.ofNullable(clazz.cast(claimCertificate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ProvisioningType", PROVISIONING_TYPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ClaimCertificate", CLAIM_CERTIFICATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProvisioningProfileResponse, T> g) {
        return obj -> g.apply((GetProvisioningProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProvisioningProfileResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the provisioning template used in the provisioning profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the provisioning template.
         * </p>
         * 
         * @param name
         *        The name of the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * </p>
         * 
         * @param provisioningType
         *        The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(String provisioningType);

        /**
         * <p>
         * The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * </p>
         * 
         * @param provisioningType
         *        The type of provisioning workflow the device uses for onboarding to IoT managed integrations.
         * @see ProvisioningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisioningType
         */
        Builder provisioningType(ProvisioningType provisioningType);

        /**
         * <p>
         * The provisioning profile id.
         * </p>
         * 
         * @param id
         *        The provisioning profile id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The id of the claim certificate.
         * </p>
         * 
         * @param claimCertificate
         *        The id of the claim certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimCertificate(String claimCertificate);

        /**
         * <p>
         * A set of key/value pairs that are used to manage the provisioning profile.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the provisioning profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String provisioningType;

        private String id;

        private String claimCertificate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProvisioningProfileResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            provisioningType(model.provisioningType);
            id(model.id);
            claimCertificate(model.claimCertificate);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvisioningType() {
            return provisioningType;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getClaimCertificate() {
            return claimCertificate;
        }

        public final void setClaimCertificate(String claimCertificate) {
            this.claimCertificate = claimCertificate;
        }

        @Override
        public final Builder claimCertificate(String claimCertificate) {
            this.claimCertificate = claimCertificate;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetProvisioningProfileResponse build() {
            return new GetProvisioningProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
