/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaVersionResponse extends IotManagedIntegrationsResponse implements
        ToCopyableBuilder<GetSchemaVersionResponse.Builder, GetSchemaVersionResponse> {
    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaId").getter(getter(GetSchemaVersionResponse::schemaId)).setter(setter(Builder::schemaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetSchemaVersionResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetSchemaVersionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(GetSchemaVersionResponse::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SemanticVersion").getter(getter(GetSchemaVersionResponse::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SemanticVersion").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(GetSchemaVersionResponse::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<Document> SCHEMA_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("Schema").getter(getter(GetSchemaVersionResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, TYPE_FIELD,
            DESCRIPTION_FIELD, NAMESPACE_FIELD, SEMANTIC_VERSION_FIELD, VISIBILITY_FIELD, SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String schemaId;

    private final String type;

    private final String description;

    private final String namespace;

    private final String semanticVersion;

    private final String visibility;

    private final Document schema;

    private GetSchemaVersionResponse(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.type = builder.type;
        this.description = builder.description;
        this.namespace = builder.namespace;
        this.semanticVersion = builder.semanticVersion;
        this.visibility = builder.visibility;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The id of the schema version.
     * </p>
     * 
     * @return The id of the schema version.
     */
    public final String schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The type of schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema version.
     * @see SchemaVersionType
     */
    public final SchemaVersionType type() {
        return SchemaVersionType.fromValue(type);
    }

    /**
     * <p>
     * The type of schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SchemaVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of schema version.
     * @see SchemaVersionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The description of the schema version.
     * </p>
     * 
     * @return The description of the schema version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the schema version.
     * </p>
     * 
     * @return The name of the schema version.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The schema version. If this is left blank, it defaults to the latest version.
     * </p>
     * 
     * @return The schema version. If this is left blank, it defaults to the latest version.
     */
    public final String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * The visibility of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link SchemaVersionVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the schema version.
     * @see SchemaVersionVisibility
     */
    public final SchemaVersionVisibility visibility() {
        return SchemaVersionVisibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the schema version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link SchemaVersionVisibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the schema version.
     * @see SchemaVersionVisibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The schema of the schema version.
     * </p>
     * 
     * @return The schema of the schema version.
     */
    public final Document schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionResponse)) {
            return false;
        }
        GetSchemaVersionResponse other = (GetSchemaVersionResponse) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(visibilityAsString(), other.visibilityAsString()) && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaVersionResponse").add("SchemaId", schemaId()).add("Type", typeAsString())
                .add("Description", description()).add("Namespace", namespace()).add("SemanticVersion", semanticVersion())
                .add("Visibility", visibilityAsString()).add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("SemanticVersion", SEMANTIC_VERSION_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionResponse, T> g) {
        return obj -> g.apply((GetSchemaVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSchemaVersionResponse> {
        /**
         * <p>
         * The id of the schema version.
         * </p>
         * 
         * @param schemaId
         *        The id of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(String schemaId);

        /**
         * <p>
         * The type of schema version.
         * </p>
         * 
         * @param type
         *        The type of schema version.
         * @see SchemaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of schema version.
         * </p>
         * 
         * @param type
         *        The type of schema version.
         * @see SchemaVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionType
         */
        Builder type(SchemaVersionType type);

        /**
         * <p>
         * The description of the schema version.
         * </p>
         * 
         * @param description
         *        The description of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the schema version.
         * </p>
         * 
         * @param namespace
         *        The name of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The schema version. If this is left blank, it defaults to the latest version.
         * </p>
         * 
         * @param semanticVersion
         *        The schema version. If this is left blank, it defaults to the latest version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * The visibility of the schema version.
         * </p>
         * 
         * @param visibility
         *        The visibility of the schema version.
         * @see SchemaVersionVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionVisibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the schema version.
         * </p>
         * 
         * @param visibility
         *        The visibility of the schema version.
         * @see SchemaVersionVisibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchemaVersionVisibility
         */
        Builder visibility(SchemaVersionVisibility visibility);

        /**
         * <p>
         * The schema of the schema version.
         * </p>
         * 
         * @param schema
         *        The schema of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Document schema);
    }

    static final class BuilderImpl extends IotManagedIntegrationsResponse.BuilderImpl implements Builder {
        private String schemaId;

        private String type;

        private String description;

        private String namespace;

        private String semanticVersion;

        private String visibility;

        private Document schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionResponse model) {
            super(model);
            schemaId(model.schemaId);
            type(model.type);
            description(model.description);
            namespace(model.namespace);
            semanticVersion(model.semanticVersion);
            visibility(model.visibility);
            schema(model.schema);
        }

        public final String getSchemaId() {
            return schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaVersionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(SchemaVersionVisibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final Document getSchema() {
            return schema;
        }

        public final void setSchema(Document schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(Document schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public GetSchemaVersionResponse build() {
            return new GetSchemaVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
