/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceDiscoveriesRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<ListDeviceDiscoveriesRequest.Builder, ListDeviceDiscoveriesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDeviceDiscoveriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDeviceDiscoveriesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> TYPE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeFilter").getter(getter(ListDeviceDiscoveriesRequest::typeFilterAsString))
            .setter(setter(Builder::typeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TypeFilter").build()).build();

    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFilter").getter(getter(ListDeviceDiscoveriesRequest::statusFilterAsString))
            .setter(setter(Builder::statusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StatusFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, TYPE_FILTER_FIELD, STATUS_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String typeFilter;

    private final String statusFilter;

    private ListDeviceDiscoveriesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.typeFilter = builder.typeFilter;
        this.statusFilter = builder.statusFilter;
    }

    /**
     * <p>
     * A token used for pagination of results.
     * </p>
     * 
     * @return A token used for pagination of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of device discovery jobs to return in a single response.
     * </p>
     * 
     * @return The maximum number of device discovery jobs to return in a single response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The discovery type to filter device discovery jobs by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeFilter} will
     * return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeFilterAsString}.
     * </p>
     * 
     * @return The discovery type to filter device discovery jobs by.
     * @see DiscoveryType
     */
    public final DiscoveryType typeFilter() {
        return DiscoveryType.fromValue(typeFilter);
    }

    /**
     * <p>
     * The discovery type to filter device discovery jobs by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeFilter} will
     * return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeFilterAsString}.
     * </p>
     * 
     * @return The discovery type to filter device discovery jobs by.
     * @see DiscoveryType
     */
    public final String typeFilterAsString() {
        return typeFilter;
    }

    /**
     * <p>
     * The status to filter device discovery jobs by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link DeviceDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return The status to filter device discovery jobs by.
     * @see DeviceDiscoveryStatus
     */
    public final DeviceDiscoveryStatus statusFilter() {
        return DeviceDiscoveryStatus.fromValue(statusFilter);
    }

    /**
     * <p>
     * The status to filter device discovery jobs by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFilter} will
     * return {@link DeviceDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusFilterAsString}.
     * </p>
     * 
     * @return The status to filter device discovery jobs by.
     * @see DeviceDiscoveryStatus
     */
    public final String statusFilterAsString() {
        return statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(typeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilterAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceDiscoveriesRequest)) {
            return false;
        }
        ListDeviceDiscoveriesRequest other = (ListDeviceDiscoveriesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(typeFilterAsString(), other.typeFilterAsString())
                && Objects.equals(statusFilterAsString(), other.statusFilterAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeviceDiscoveriesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("TypeFilter", typeFilterAsString()).add("StatusFilter", statusFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "TypeFilter":
            return Optional.ofNullable(clazz.cast(typeFilterAsString()));
        case "StatusFilter":
            return Optional.ofNullable(clazz.cast(statusFilterAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("TypeFilter", TYPE_FILTER_FIELD);
        map.put("StatusFilter", STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceDiscoveriesRequest, T> g) {
        return obj -> g.apply((ListDeviceDiscoveriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeviceDiscoveriesRequest> {
        /**
         * <p>
         * A token used for pagination of results.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of device discovery jobs to return in a single response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of device discovery jobs to return in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The discovery type to filter device discovery jobs by.
         * </p>
         * 
         * @param typeFilter
         *        The discovery type to filter device discovery jobs by.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder typeFilter(String typeFilter);

        /**
         * <p>
         * The discovery type to filter device discovery jobs by.
         * </p>
         * 
         * @param typeFilter
         *        The discovery type to filter device discovery jobs by.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder typeFilter(DiscoveryType typeFilter);

        /**
         * <p>
         * The status to filter device discovery jobs by.
         * </p>
         * 
         * @param statusFilter
         *        The status to filter device discovery jobs by.
         * @see DeviceDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDiscoveryStatus
         */
        Builder statusFilter(String statusFilter);

        /**
         * <p>
         * The status to filter device discovery jobs by.
         * </p>
         * 
         * @param statusFilter
         *        The status to filter device discovery jobs by.
         * @see DeviceDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDiscoveryStatus
         */
        Builder statusFilter(DeviceDiscoveryStatus statusFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String typeFilter;

        private String statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceDiscoveriesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            typeFilter(model.typeFilter);
            statusFilter(model.statusFilter);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getTypeFilter() {
            return typeFilter;
        }

        public final void setTypeFilter(String typeFilter) {
            this.typeFilter = typeFilter;
        }

        @Override
        public final Builder typeFilter(String typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        @Override
        public final Builder typeFilter(DiscoveryType typeFilter) {
            this.typeFilter(typeFilter == null ? null : typeFilter.toString());
            return this;
        }

        public final String getStatusFilter() {
            return statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(DeviceDiscoveryStatus statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceDiscoveriesRequest build() {
            return new ListDeviceDiscoveriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
