/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Over-the-air (OTA) task abort config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtaTaskAbortConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OtaTaskAbortConfig.Builder, OtaTaskAbortConfig> {
    private static final SdkField<List<AbortConfigCriteria>> ABORT_CONFIG_CRITERIA_LIST_FIELD = SdkField
            .<List<AbortConfigCriteria>> builder(MarshallingType.LIST)
            .memberName("AbortConfigCriteriaList")
            .getter(getter(OtaTaskAbortConfig::abortConfigCriteriaList))
            .setter(setter(Builder::abortConfigCriteriaList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortConfigCriteriaList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AbortConfigCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(AbortConfigCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ABORT_CONFIG_CRITERIA_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AbortConfigCriteria> abortConfigCriteriaList;

    private OtaTaskAbortConfig(BuilderImpl builder) {
        this.abortConfigCriteriaList = builder.abortConfigCriteriaList;
    }

    /**
     * For responses, this returns true if the service returned a value for the AbortConfigCriteriaList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAbortConfigCriteriaList() {
        return abortConfigCriteriaList != null && !(abortConfigCriteriaList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of criteria for the abort config.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAbortConfigCriteriaList} method.
     * </p>
     * 
     * @return The list of criteria for the abort config.
     */
    public final List<AbortConfigCriteria> abortConfigCriteriaList() {
        return abortConfigCriteriaList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAbortConfigCriteriaList() ? abortConfigCriteriaList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtaTaskAbortConfig)) {
            return false;
        }
        OtaTaskAbortConfig other = (OtaTaskAbortConfig) obj;
        return hasAbortConfigCriteriaList() == other.hasAbortConfigCriteriaList()
                && Objects.equals(abortConfigCriteriaList(), other.abortConfigCriteriaList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtaTaskAbortConfig")
                .add("AbortConfigCriteriaList", hasAbortConfigCriteriaList() ? abortConfigCriteriaList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbortConfigCriteriaList":
            return Optional.ofNullable(clazz.cast(abortConfigCriteriaList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AbortConfigCriteriaList", ABORT_CONFIG_CRITERIA_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OtaTaskAbortConfig, T> g) {
        return obj -> g.apply((OtaTaskAbortConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtaTaskAbortConfig> {
        /**
         * <p>
         * The list of criteria for the abort config.
         * </p>
         * 
         * @param abortConfigCriteriaList
         *        The list of criteria for the abort config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfigCriteriaList(Collection<AbortConfigCriteria> abortConfigCriteriaList);

        /**
         * <p>
         * The list of criteria for the abort config.
         * </p>
         * 
         * @param abortConfigCriteriaList
         *        The list of criteria for the abort config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfigCriteriaList(AbortConfigCriteria... abortConfigCriteriaList);

        /**
         * <p>
         * The list of criteria for the abort config.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.AbortConfigCriteria.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.AbortConfigCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotmanagedintegrations.model.AbortConfigCriteria.Builder#build()} is
         * called immediately and its result is passed to {@link #abortConfigCriteriaList(List<AbortConfigCriteria>)}.
         * 
         * @param abortConfigCriteriaList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotmanagedintegrations.model.AbortConfigCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortConfigCriteriaList(java.util.Collection<AbortConfigCriteria>)
         */
        Builder abortConfigCriteriaList(Consumer<AbortConfigCriteria.Builder>... abortConfigCriteriaList);
    }

    static final class BuilderImpl implements Builder {
        private List<AbortConfigCriteria> abortConfigCriteriaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OtaTaskAbortConfig model) {
            abortConfigCriteriaList(model.abortConfigCriteriaList);
        }

        public final List<AbortConfigCriteria.Builder> getAbortConfigCriteriaList() {
            List<AbortConfigCriteria.Builder> result = AbortConfigCriteriaListCopier.copyToBuilder(this.abortConfigCriteriaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAbortConfigCriteriaList(Collection<AbortConfigCriteria.BuilderImpl> abortConfigCriteriaList) {
            this.abortConfigCriteriaList = AbortConfigCriteriaListCopier.copyFromBuilder(abortConfigCriteriaList);
        }

        @Override
        public final Builder abortConfigCriteriaList(Collection<AbortConfigCriteria> abortConfigCriteriaList) {
            this.abortConfigCriteriaList = AbortConfigCriteriaListCopier.copy(abortConfigCriteriaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder abortConfigCriteriaList(AbortConfigCriteria... abortConfigCriteriaList) {
            abortConfigCriteriaList(Arrays.asList(abortConfigCriteriaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder abortConfigCriteriaList(Consumer<AbortConfigCriteria.Builder>... abortConfigCriteriaList) {
            abortConfigCriteriaList(Stream.of(abortConfigCriteriaList)
                    .map(c -> AbortConfigCriteria.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OtaTaskAbortConfig build() {
            return new OtaTaskAbortConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
