/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure representing a push config.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushConfig implements SdkPojo, Serializable, ToCopyableBuilder<PushConfig.Builder, PushConfig> {
    private static final SdkField<OtaTaskAbortConfig> ABORT_CONFIG_FIELD = SdkField
            .<OtaTaskAbortConfig> builder(MarshallingType.SDK_POJO).memberName("AbortConfig")
            .getter(getter(PushConfig::abortConfig)).setter(setter(Builder::abortConfig))
            .constructor(OtaTaskAbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbortConfig").build()).build();

    private static final SdkField<OtaTaskExecutionRolloutConfig> ROLLOUT_CONFIG_FIELD = SdkField
            .<OtaTaskExecutionRolloutConfig> builder(MarshallingType.SDK_POJO).memberName("RolloutConfig")
            .getter(getter(PushConfig::rolloutConfig)).setter(setter(Builder::rolloutConfig))
            .constructor(OtaTaskExecutionRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolloutConfig").build()).build();

    private static final SdkField<OtaTaskTimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<OtaTaskTimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("TimeoutConfig")
            .getter(getter(PushConfig::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(OtaTaskTimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABORT_CONFIG_FIELD,
            ROLLOUT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OtaTaskAbortConfig abortConfig;

    private final OtaTaskExecutionRolloutConfig rolloutConfig;

    private final OtaTaskTimeoutConfig timeoutConfig;

    private PushConfig(BuilderImpl builder) {
        this.abortConfig = builder.abortConfig;
        this.rolloutConfig = builder.rolloutConfig;
        this.timeoutConfig = builder.timeoutConfig;
    }

    /**
     * <p>
     * Structure representing one abort config.
     * </p>
     * 
     * @return Structure representing one abort config.
     */
    public final OtaTaskAbortConfig abortConfig() {
        return abortConfig;
    }

    /**
     * <p>
     * Structure representing one rollout config.
     * </p>
     * 
     * @return Structure representing one rollout config.
     */
    public final OtaTaskExecutionRolloutConfig rolloutConfig() {
        return rolloutConfig;
    }

    /**
     * <p>
     * Structure representing one timeout config.
     * </p>
     * 
     * @return Structure representing one timeout config.
     */
    public final OtaTaskTimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(rolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushConfig)) {
            return false;
        }
        PushConfig other = (PushConfig) obj;
        return Objects.equals(abortConfig(), other.abortConfig()) && Objects.equals(rolloutConfig(), other.rolloutConfig())
                && Objects.equals(timeoutConfig(), other.timeoutConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PushConfig").add("AbortConfig", abortConfig()).add("RolloutConfig", rolloutConfig())
                .add("TimeoutConfig", timeoutConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbortConfig":
            return Optional.ofNullable(clazz.cast(abortConfig()));
        case "RolloutConfig":
            return Optional.ofNullable(clazz.cast(rolloutConfig()));
        case "TimeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AbortConfig", ABORT_CONFIG_FIELD);
        map.put("RolloutConfig", ROLLOUT_CONFIG_FIELD);
        map.put("TimeoutConfig", TIMEOUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushConfig, T> g) {
        return obj -> g.apply((PushConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushConfig> {
        /**
         * <p>
         * Structure representing one abort config.
         * </p>
         * 
         * @param abortConfig
         *        Structure representing one abort config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfig(OtaTaskAbortConfig abortConfig);

        /**
         * <p>
         * Structure representing one abort config.
         * </p>
         * This is a convenience method that creates an instance of the {@link OtaTaskAbortConfig.Builder} avoiding the
         * need to create one manually via {@link OtaTaskAbortConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskAbortConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #abortConfig(OtaTaskAbortConfig)}.
         * 
         * @param abortConfig
         *        a consumer that will call methods on {@link OtaTaskAbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortConfig(OtaTaskAbortConfig)
         */
        default Builder abortConfig(Consumer<OtaTaskAbortConfig.Builder> abortConfig) {
            return abortConfig(OtaTaskAbortConfig.builder().applyMutation(abortConfig).build());
        }

        /**
         * <p>
         * Structure representing one rollout config.
         * </p>
         * 
         * @param rolloutConfig
         *        Structure representing one rollout config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolloutConfig(OtaTaskExecutionRolloutConfig rolloutConfig);

        /**
         * <p>
         * Structure representing one rollout config.
         * </p>
         * This is a convenience method that creates an instance of the {@link OtaTaskExecutionRolloutConfig.Builder}
         * avoiding the need to create one manually via {@link OtaTaskExecutionRolloutConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskExecutionRolloutConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #rolloutConfig(OtaTaskExecutionRolloutConfig)}.
         * 
         * @param rolloutConfig
         *        a consumer that will call methods on {@link OtaTaskExecutionRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rolloutConfig(OtaTaskExecutionRolloutConfig)
         */
        default Builder rolloutConfig(Consumer<OtaTaskExecutionRolloutConfig.Builder> rolloutConfig) {
            return rolloutConfig(OtaTaskExecutionRolloutConfig.builder().applyMutation(rolloutConfig).build());
        }

        /**
         * <p>
         * Structure representing one timeout config.
         * </p>
         * 
         * @param timeoutConfig
         *        Structure representing one timeout config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(OtaTaskTimeoutConfig timeoutConfig);

        /**
         * <p>
         * Structure representing one timeout config.
         * </p>
         * This is a convenience method that creates an instance of the {@link OtaTaskTimeoutConfig.Builder} avoiding
         * the need to create one manually via {@link OtaTaskTimeoutConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OtaTaskTimeoutConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #timeoutConfig(OtaTaskTimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link OtaTaskTimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(OtaTaskTimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<OtaTaskTimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(OtaTaskTimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OtaTaskAbortConfig abortConfig;

        private OtaTaskExecutionRolloutConfig rolloutConfig;

        private OtaTaskTimeoutConfig timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PushConfig model) {
            abortConfig(model.abortConfig);
            rolloutConfig(model.rolloutConfig);
            timeoutConfig(model.timeoutConfig);
        }

        public final OtaTaskAbortConfig.Builder getAbortConfig() {
            return abortConfig != null ? abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(OtaTaskAbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        public final Builder abortConfig(OtaTaskAbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final OtaTaskExecutionRolloutConfig.Builder getRolloutConfig() {
            return rolloutConfig != null ? rolloutConfig.toBuilder() : null;
        }

        public final void setRolloutConfig(OtaTaskExecutionRolloutConfig.BuilderImpl rolloutConfig) {
            this.rolloutConfig = rolloutConfig != null ? rolloutConfig.build() : null;
        }

        @Override
        public final Builder rolloutConfig(OtaTaskExecutionRolloutConfig rolloutConfig) {
            this.rolloutConfig = rolloutConfig;
            return this;
        }

        public final OtaTaskTimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(OtaTaskTimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(OtaTaskTimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        @Override
        public PushConfig build() {
            return new PushConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
