/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeviceDiscoveryRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<StartDeviceDiscoveryRequest.Builder, StartDeviceDiscoveryRequest> {
    private static final SdkField<String> DISCOVERY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryType").getter(getter(StartDeviceDiscoveryRequest::discoveryTypeAsString))
            .setter(setter(Builder::discoveryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryType").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_PROTOCOL_DETAIL_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomProtocolDetail")
            .getter(getter(StartDeviceDiscoveryRequest::customProtocolDetail))
            .setter(setter(Builder::customProtocolDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomProtocolDetail").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONTROLLER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControllerIdentifier").getter(getter(StartDeviceDiscoveryRequest::controllerIdentifier))
            .setter(setter(Builder::controllerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControllerIdentifier").build())
            .build();

    private static final SdkField<String> CONNECTOR_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectorAssociationIdentifier")
            .getter(getter(StartDeviceDiscoveryRequest::connectorAssociationIdentifier))
            .setter(setter(Builder::connectorAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorAssociationIdentifier")
                    .build()).build();

    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountAssociationId").getter(getter(StartDeviceDiscoveryRequest::accountAssociationId))
            .setter(setter(Builder::accountAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_MATERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMaterial").getter(getter(StartDeviceDiscoveryRequest::authenticationMaterial))
            .setter(setter(Builder::authenticationMaterial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMaterial").build())
            .build();

    private static final SdkField<String> AUTHENTICATION_MATERIAL_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMaterialType")
            .getter(getter(StartDeviceDiscoveryRequest::authenticationMaterialTypeAsString))
            .setter(setter(Builder::authenticationMaterialType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMaterialType").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartDeviceDiscoveryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartDeviceDiscoveryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_TYPE_FIELD,
            CUSTOM_PROTOCOL_DETAIL_FIELD, CONTROLLER_IDENTIFIER_FIELD, CONNECTOR_ASSOCIATION_IDENTIFIER_FIELD,
            ACCOUNT_ASSOCIATION_ID_FIELD, AUTHENTICATION_MATERIAL_FIELD, AUTHENTICATION_MATERIAL_TYPE_FIELD, CLIENT_TOKEN_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String discoveryType;

    private final Map<String, String> customProtocolDetail;

    private final String controllerIdentifier;

    private final String connectorAssociationIdentifier;

    private final String accountAssociationId;

    private final String authenticationMaterial;

    private final String authenticationMaterialType;

    private final String clientToken;

    private final Map<String, String> tags;

    private StartDeviceDiscoveryRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryType = builder.discoveryType;
        this.customProtocolDetail = builder.customProtocolDetail;
        this.controllerIdentifier = builder.controllerIdentifier;
        this.connectorAssociationIdentifier = builder.connectorAssociationIdentifier;
        this.accountAssociationId = builder.accountAssociationId;
        this.authenticationMaterial = builder.authenticationMaterial;
        this.authenticationMaterialType = builder.authenticationMaterialType;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The discovery type supporting the type of device to be discovered in the device discovery task request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The discovery type supporting the type of device to be discovered in the device discovery task request.
     * @see DiscoveryType
     */
    public final DiscoveryType discoveryType() {
        return DiscoveryType.fromValue(discoveryType);
    }

    /**
     * <p>
     * The discovery type supporting the type of device to be discovered in the device discovery task request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The discovery type supporting the type of device to be discovered in the device discovery task request.
     * @see DiscoveryType
     */
    public final String discoveryTypeAsString() {
        return discoveryType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomProtocolDetail property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomProtocolDetail() {
        return customProtocolDetail != null && !(customProtocolDetail instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional protocol-specific details required for device discovery, which vary based on the discovery type.
     * </p>
     * <note>
     * <p>
     * For a <code>DiscoveryType</code> of <code>CUSTOM</code>, the string-to-string map must have a key value of
     * <code>Name</code> set to a non-empty-string.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomProtocolDetail} method.
     * </p>
     * 
     * @return Additional protocol-specific details required for device discovery, which vary based on the discovery
     *         type.</p> <note>
     *         <p>
     *         For a <code>DiscoveryType</code> of <code>CUSTOM</code>, the string-to-string map must have a key value
     *         of <code>Name</code> set to a non-empty-string.
     *         </p>
     */
    public final Map<String, String> customProtocolDetail() {
        return customProtocolDetail;
    }

    /**
     * <p>
     * The id of the end-user's IoT hub.
     * </p>
     * 
     * @return The id of the end-user's IoT hub.
     */
    public final String controllerIdentifier() {
        return controllerIdentifier;
    }

    /**
     * <p>
     * The id of the connector association.
     * </p>
     * 
     * @return The id of the connector association.
     * @deprecated ConnectorAssociationIdentifier is deprecated
     */
    @Deprecated
    public final String connectorAssociationIdentifier() {
        return connectorAssociationIdentifier;
    }

    /**
     * <p>
     * The identifier of the cloud-to-cloud account association to use for discovery of third-party devices.
     * </p>
     * 
     * @return The identifier of the cloud-to-cloud account association to use for discovery of third-party devices.
     */
    public final String accountAssociationId() {
        return accountAssociationId;
    }

    /**
     * <p>
     * The authentication material required to start the local device discovery job request.
     * </p>
     * 
     * @return The authentication material required to start the local device discovery job request.
     */
    public final String authenticationMaterial() {
        return authenticationMaterial;
    }

    /**
     * <p>
     * The type of authentication material used for device discovery jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMaterialType} will return {@link DiscoveryAuthMaterialType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMaterialTypeAsString}.
     * </p>
     * 
     * @return The type of authentication material used for device discovery jobs.
     * @see DiscoveryAuthMaterialType
     */
    public final DiscoveryAuthMaterialType authenticationMaterialType() {
        return DiscoveryAuthMaterialType.fromValue(authenticationMaterialType);
    }

    /**
     * <p>
     * The type of authentication material used for device discovery jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMaterialType} will return {@link DiscoveryAuthMaterialType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMaterialTypeAsString}.
     * </p>
     * 
     * @return The type of authentication material used for device discovery jobs.
     * @see DiscoveryAuthMaterialType
     */
    public final String authenticationMaterialTypeAsString() {
        return authenticationMaterialType;
    }

    /**
     * <p>
     * An idempotency token. If you retry a request that completed successfully initially using the same client token
     * and parameters, then the retry attempt will succeed without performing any further actions.
     * </p>
     * 
     * @return An idempotency token. If you retry a request that completed successfully initially using the same client
     *         token and parameters, then the retry attempt will succeed without performing any further actions.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     *
     * @deprecated Tags have been deprecated from this api
     */
    @Deprecated
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of key/value pairs that are used to manage the device discovery request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of key/value pairs that are used to manage the device discovery request.
     * @deprecated Tags have been deprecated from this api
     */
    @Deprecated
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discoveryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomProtocolDetail() ? customProtocolDetail() : null);
        hashCode = 31 * hashCode + Objects.hashCode(controllerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(connectorAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMaterialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceDiscoveryRequest)) {
            return false;
        }
        StartDeviceDiscoveryRequest other = (StartDeviceDiscoveryRequest) obj;
        return Objects.equals(discoveryTypeAsString(), other.discoveryTypeAsString())
                && hasCustomProtocolDetail() == other.hasCustomProtocolDetail()
                && Objects.equals(customProtocolDetail(), other.customProtocolDetail())
                && Objects.equals(controllerIdentifier(), other.controllerIdentifier())
                && Objects.equals(connectorAssociationIdentifier(), other.connectorAssociationIdentifier())
                && Objects.equals(accountAssociationId(), other.accountAssociationId())
                && Objects.equals(authenticationMaterial(), other.authenticationMaterial())
                && Objects.equals(authenticationMaterialTypeAsString(), other.authenticationMaterialTypeAsString())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDeviceDiscoveryRequest").add("DiscoveryType", discoveryTypeAsString())
                .add("CustomProtocolDetail", hasCustomProtocolDetail() ? customProtocolDetail() : null)
                .add("ControllerIdentifier", controllerIdentifier())
                .add("ConnectorAssociationIdentifier", connectorAssociationIdentifier())
                .add("AccountAssociationId", accountAssociationId())
                .add("AuthenticationMaterial", authenticationMaterial() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AuthenticationMaterialType", authenticationMaterialTypeAsString()).add("ClientToken", clientToken())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscoveryType":
            return Optional.ofNullable(clazz.cast(discoveryTypeAsString()));
        case "CustomProtocolDetail":
            return Optional.ofNullable(clazz.cast(customProtocolDetail()));
        case "ControllerIdentifier":
            return Optional.ofNullable(clazz.cast(controllerIdentifier()));
        case "ConnectorAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(connectorAssociationIdentifier()));
        case "AccountAssociationId":
            return Optional.ofNullable(clazz.cast(accountAssociationId()));
        case "AuthenticationMaterial":
            return Optional.ofNullable(clazz.cast(authenticationMaterial()));
        case "AuthenticationMaterialType":
            return Optional.ofNullable(clazz.cast(authenticationMaterialTypeAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiscoveryType", DISCOVERY_TYPE_FIELD);
        map.put("CustomProtocolDetail", CUSTOM_PROTOCOL_DETAIL_FIELD);
        map.put("ControllerIdentifier", CONTROLLER_IDENTIFIER_FIELD);
        map.put("ConnectorAssociationIdentifier", CONNECTOR_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("AuthenticationMaterial", AUTHENTICATION_MATERIAL_FIELD);
        map.put("AuthenticationMaterialType", AUTHENTICATION_MATERIAL_TYPE_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDeviceDiscoveryRequest, T> g) {
        return obj -> g.apply((StartDeviceDiscoveryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDeviceDiscoveryRequest> {
        /**
         * <p>
         * The discovery type supporting the type of device to be discovered in the device discovery task request.
         * </p>
         * 
         * @param discoveryType
         *        The discovery type supporting the type of device to be discovered in the device discovery task
         *        request.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(String discoveryType);

        /**
         * <p>
         * The discovery type supporting the type of device to be discovered in the device discovery task request.
         * </p>
         * 
         * @param discoveryType
         *        The discovery type supporting the type of device to be discovered in the device discovery task
         *        request.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(DiscoveryType discoveryType);

        /**
         * <p>
         * Additional protocol-specific details required for device discovery, which vary based on the discovery type.
         * </p>
         * <note>
         * <p>
         * For a <code>DiscoveryType</code> of <code>CUSTOM</code>, the string-to-string map must have a key value of
         * <code>Name</code> set to a non-empty-string.
         * </p>
         * </note>
         * 
         * @param customProtocolDetail
         *        Additional protocol-specific details required for device discovery, which vary based on the discovery
         *        type.</p> <note>
         *        <p>
         *        For a <code>DiscoveryType</code> of <code>CUSTOM</code>, the string-to-string map must have a key
         *        value of <code>Name</code> set to a non-empty-string.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customProtocolDetail(Map<String, String> customProtocolDetail);

        /**
         * <p>
         * The id of the end-user's IoT hub.
         * </p>
         * 
         * @param controllerIdentifier
         *        The id of the end-user's IoT hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controllerIdentifier(String controllerIdentifier);

        /**
         * <p>
         * The id of the connector association.
         * </p>
         * 
         * @param connectorAssociationIdentifier
         *        The id of the connector association.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated ConnectorAssociationIdentifier is deprecated
         */
        @Deprecated
        Builder connectorAssociationIdentifier(String connectorAssociationIdentifier);

        /**
         * <p>
         * The identifier of the cloud-to-cloud account association to use for discovery of third-party devices.
         * </p>
         * 
         * @param accountAssociationId
         *        The identifier of the cloud-to-cloud account association to use for discovery of third-party devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAssociationId(String accountAssociationId);

        /**
         * <p>
         * The authentication material required to start the local device discovery job request.
         * </p>
         * 
         * @param authenticationMaterial
         *        The authentication material required to start the local device discovery job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMaterial(String authenticationMaterial);

        /**
         * <p>
         * The type of authentication material used for device discovery jobs.
         * </p>
         * 
         * @param authenticationMaterialType
         *        The type of authentication material used for device discovery jobs.
         * @see DiscoveryAuthMaterialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryAuthMaterialType
         */
        Builder authenticationMaterialType(String authenticationMaterialType);

        /**
         * <p>
         * The type of authentication material used for device discovery jobs.
         * </p>
         * 
         * @param authenticationMaterialType
         *        The type of authentication material used for device discovery jobs.
         * @see DiscoveryAuthMaterialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryAuthMaterialType
         */
        Builder authenticationMaterialType(DiscoveryAuthMaterialType authenticationMaterialType);

        /**
         * <p>
         * An idempotency token. If you retry a request that completed successfully initially using the same client
         * token and parameters, then the retry attempt will succeed without performing any further actions.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token. If you retry a request that completed successfully initially using the same
         *        client token and parameters, then the retry attempt will succeed without performing any further
         *        actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A set of key/value pairs that are used to manage the device discovery request.
         * </p>
         * 
         * @param tags
         *        A set of key/value pairs that are used to manage the device discovery request.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Tags have been deprecated from this api
         */
        @Deprecated
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String discoveryType;

        private Map<String, String> customProtocolDetail = DefaultSdkAutoConstructMap.getInstance();

        private String controllerIdentifier;

        private String connectorAssociationIdentifier;

        private String accountAssociationId;

        private String authenticationMaterial;

        private String authenticationMaterialType;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceDiscoveryRequest model) {
            super(model);
            discoveryType(model.discoveryType);
            customProtocolDetail(model.customProtocolDetail);
            controllerIdentifier(model.controllerIdentifier);
            connectorAssociationIdentifier(model.connectorAssociationIdentifier);
            accountAssociationId(model.accountAssociationId);
            authenticationMaterial(model.authenticationMaterial);
            authenticationMaterialType(model.authenticationMaterialType);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getDiscoveryType() {
            return discoveryType;
        }

        public final void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        @Override
        public final Builder discoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        @Override
        public final Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType(discoveryType == null ? null : discoveryType.toString());
            return this;
        }

        public final Map<String, String> getCustomProtocolDetail() {
            if (customProtocolDetail instanceof SdkAutoConstructMap) {
                return null;
            }
            return customProtocolDetail;
        }

        public final void setCustomProtocolDetail(Map<String, String> customProtocolDetail) {
            this.customProtocolDetail = CustomProtocolDetailCopier.copy(customProtocolDetail);
        }

        @Override
        public final Builder customProtocolDetail(Map<String, String> customProtocolDetail) {
            this.customProtocolDetail = CustomProtocolDetailCopier.copy(customProtocolDetail);
            return this;
        }

        public final String getControllerIdentifier() {
            return controllerIdentifier;
        }

        public final void setControllerIdentifier(String controllerIdentifier) {
            this.controllerIdentifier = controllerIdentifier;
        }

        @Override
        public final Builder controllerIdentifier(String controllerIdentifier) {
            this.controllerIdentifier = controllerIdentifier;
            return this;
        }

        @Deprecated
        public final String getConnectorAssociationIdentifier() {
            return connectorAssociationIdentifier;
        }

        @Deprecated
        public final void setConnectorAssociationIdentifier(String connectorAssociationIdentifier) {
            this.connectorAssociationIdentifier = connectorAssociationIdentifier;
        }

        @Override
        @Deprecated
        public final Builder connectorAssociationIdentifier(String connectorAssociationIdentifier) {
            this.connectorAssociationIdentifier = connectorAssociationIdentifier;
            return this;
        }

        public final String getAccountAssociationId() {
            return accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getAuthenticationMaterial() {
            return authenticationMaterial;
        }

        public final void setAuthenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
        }

        @Override
        public final Builder authenticationMaterial(String authenticationMaterial) {
            this.authenticationMaterial = authenticationMaterial;
            return this;
        }

        public final String getAuthenticationMaterialType() {
            return authenticationMaterialType;
        }

        public final void setAuthenticationMaterialType(String authenticationMaterialType) {
            this.authenticationMaterialType = authenticationMaterialType;
        }

        @Override
        public final Builder authenticationMaterialType(String authenticationMaterialType) {
            this.authenticationMaterialType = authenticationMaterialType;
            return this;
        }

        @Override
        public final Builder authenticationMaterialType(DiscoveryAuthMaterialType authenticationMaterialType) {
            this.authenticationMaterialType(authenticationMaterialType == null ? null : authenticationMaterialType.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Deprecated
        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Deprecated
        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Deprecated
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeviceDiscoveryRequest build() {
            return new StartDeviceDiscoveryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
