/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the over-the-air (OTA) task process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskProcessingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskProcessingDetails.Builder, TaskProcessingDetails> {
    private static final SdkField<Integer> NUMBER_OF_CANCELED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfCanceledThings").getter(getter(TaskProcessingDetails::numberOfCanceledThings))
            .setter(setter(Builder::numberOfCanceledThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfCanceledThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_FAILED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfFailedThings").getter(getter(TaskProcessingDetails::numberOfFailedThings))
            .setter(setter(Builder::numberOfFailedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFailedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_IN_PROGRESS_THINGS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("NumberOfInProgressThings")
            .getter(getter(TaskProcessingDetails::numberOfInProgressThings)).setter(setter(Builder::numberOfInProgressThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfInProgressThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_QUEUED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfQueuedThings").getter(getter(TaskProcessingDetails::numberOfQueuedThings))
            .setter(setter(Builder::numberOfQueuedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfQueuedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_REJECTED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRejectedThings").getter(getter(TaskProcessingDetails::numberOfRejectedThings))
            .setter(setter(Builder::numberOfRejectedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRejectedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_REMOVED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRemovedThings").getter(getter(TaskProcessingDetails::numberOfRemovedThings))
            .setter(setter(Builder::numberOfRemovedThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRemovedThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_SUCCEEDED_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfSucceededThings").getter(getter(TaskProcessingDetails::numberOfSucceededThings))
            .setter(setter(Builder::numberOfSucceededThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfSucceededThings").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_TIMED_OUT_THINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfTimedOutThings").getter(getter(TaskProcessingDetails::numberOfTimedOutThings))
            .setter(setter(Builder::numberOfTimedOutThings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfTimedOutThings").build())
            .build();

    private static final SdkField<List<String>> PROCESSING_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("processingTargets")
            .getter(getter(TaskProcessingDetails::processingTargets))
            .setter(setter(Builder::processingTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_CANCELED_THINGS_FIELD, NUMBER_OF_FAILED_THINGS_FIELD, NUMBER_OF_IN_PROGRESS_THINGS_FIELD,
            NUMBER_OF_QUEUED_THINGS_FIELD, NUMBER_OF_REJECTED_THINGS_FIELD, NUMBER_OF_REMOVED_THINGS_FIELD,
            NUMBER_OF_SUCCEEDED_THINGS_FIELD, NUMBER_OF_TIMED_OUT_THINGS_FIELD, PROCESSING_TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer numberOfCanceledThings;

    private final Integer numberOfFailedThings;

    private final Integer numberOfInProgressThings;

    private final Integer numberOfQueuedThings;

    private final Integer numberOfRejectedThings;

    private final Integer numberOfRemovedThings;

    private final Integer numberOfSucceededThings;

    private final Integer numberOfTimedOutThings;

    private final List<String> processingTargets;

    private TaskProcessingDetails(BuilderImpl builder) {
        this.numberOfCanceledThings = builder.numberOfCanceledThings;
        this.numberOfFailedThings = builder.numberOfFailedThings;
        this.numberOfInProgressThings = builder.numberOfInProgressThings;
        this.numberOfQueuedThings = builder.numberOfQueuedThings;
        this.numberOfRejectedThings = builder.numberOfRejectedThings;
        this.numberOfRemovedThings = builder.numberOfRemovedThings;
        this.numberOfSucceededThings = builder.numberOfSucceededThings;
        this.numberOfTimedOutThings = builder.numberOfTimedOutThings;
        this.processingTargets = builder.processingTargets;
    }

    /**
     * <p>
     * The number of canceled things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of canceled things in an over-the-air (OTA) task.
     */
    public final Integer numberOfCanceledThings() {
        return numberOfCanceledThings;
    }

    /**
     * <p>
     * The number of failed things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of failed things in an over-the-air (OTA) task.
     */
    public final Integer numberOfFailedThings() {
        return numberOfFailedThings;
    }

    /**
     * <p>
     * The number of in progress things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of in progress things in an over-the-air (OTA) task.
     */
    public final Integer numberOfInProgressThings() {
        return numberOfInProgressThings;
    }

    /**
     * <p>
     * The number of queued things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of queued things in an over-the-air (OTA) task.
     */
    public final Integer numberOfQueuedThings() {
        return numberOfQueuedThings;
    }

    /**
     * <p>
     * The number of rejected things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of rejected things in an over-the-air (OTA) task.
     */
    public final Integer numberOfRejectedThings() {
        return numberOfRejectedThings;
    }

    /**
     * <p>
     * The number of removed things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of removed things in an over-the-air (OTA) task.
     */
    public final Integer numberOfRemovedThings() {
        return numberOfRemovedThings;
    }

    /**
     * <p>
     * The number of succeeded things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of succeeded things in an over-the-air (OTA) task.
     */
    public final Integer numberOfSucceededThings() {
        return numberOfSucceededThings;
    }

    /**
     * <p>
     * The number of timed out things in an over-the-air (OTA) task.
     * </p>
     * 
     * @return The number of timed out things in an over-the-air (OTA) task.
     */
    public final Integer numberOfTimedOutThings() {
        return numberOfTimedOutThings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessingTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessingTargets() {
        return processingTargets != null && !(processingTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targets of the over-the-air (OTA) task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessingTargets} method.
     * </p>
     * 
     * @return The targets of the over-the-air (OTA) task.
     */
    public final List<String> processingTargets() {
        return processingTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCanceledThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFailedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfInProgressThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfQueuedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRejectedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRemovedThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfSucceededThings());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTimedOutThings());
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessingTargets() ? processingTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskProcessingDetails)) {
            return false;
        }
        TaskProcessingDetails other = (TaskProcessingDetails) obj;
        return Objects.equals(numberOfCanceledThings(), other.numberOfCanceledThings())
                && Objects.equals(numberOfFailedThings(), other.numberOfFailedThings())
                && Objects.equals(numberOfInProgressThings(), other.numberOfInProgressThings())
                && Objects.equals(numberOfQueuedThings(), other.numberOfQueuedThings())
                && Objects.equals(numberOfRejectedThings(), other.numberOfRejectedThings())
                && Objects.equals(numberOfRemovedThings(), other.numberOfRemovedThings())
                && Objects.equals(numberOfSucceededThings(), other.numberOfSucceededThings())
                && Objects.equals(numberOfTimedOutThings(), other.numberOfTimedOutThings())
                && hasProcessingTargets() == other.hasProcessingTargets()
                && Objects.equals(processingTargets(), other.processingTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskProcessingDetails").add("NumberOfCanceledThings", numberOfCanceledThings())
                .add("NumberOfFailedThings", numberOfFailedThings()).add("NumberOfInProgressThings", numberOfInProgressThings())
                .add("NumberOfQueuedThings", numberOfQueuedThings()).add("NumberOfRejectedThings", numberOfRejectedThings())
                .add("NumberOfRemovedThings", numberOfRemovedThings()).add("NumberOfSucceededThings", numberOfSucceededThings())
                .add("NumberOfTimedOutThings", numberOfTimedOutThings())
                .add("ProcessingTargets", hasProcessingTargets() ? processingTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfCanceledThings":
            return Optional.ofNullable(clazz.cast(numberOfCanceledThings()));
        case "NumberOfFailedThings":
            return Optional.ofNullable(clazz.cast(numberOfFailedThings()));
        case "NumberOfInProgressThings":
            return Optional.ofNullable(clazz.cast(numberOfInProgressThings()));
        case "numberOfQueuedThings":
            return Optional.ofNullable(clazz.cast(numberOfQueuedThings()));
        case "numberOfRejectedThings":
            return Optional.ofNullable(clazz.cast(numberOfRejectedThings()));
        case "numberOfRemovedThings":
            return Optional.ofNullable(clazz.cast(numberOfRemovedThings()));
        case "numberOfSucceededThings":
            return Optional.ofNullable(clazz.cast(numberOfSucceededThings()));
        case "numberOfTimedOutThings":
            return Optional.ofNullable(clazz.cast(numberOfTimedOutThings()));
        case "processingTargets":
            return Optional.ofNullable(clazz.cast(processingTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumberOfCanceledThings", NUMBER_OF_CANCELED_THINGS_FIELD);
        map.put("NumberOfFailedThings", NUMBER_OF_FAILED_THINGS_FIELD);
        map.put("NumberOfInProgressThings", NUMBER_OF_IN_PROGRESS_THINGS_FIELD);
        map.put("numberOfQueuedThings", NUMBER_OF_QUEUED_THINGS_FIELD);
        map.put("numberOfRejectedThings", NUMBER_OF_REJECTED_THINGS_FIELD);
        map.put("numberOfRemovedThings", NUMBER_OF_REMOVED_THINGS_FIELD);
        map.put("numberOfSucceededThings", NUMBER_OF_SUCCEEDED_THINGS_FIELD);
        map.put("numberOfTimedOutThings", NUMBER_OF_TIMED_OUT_THINGS_FIELD);
        map.put("processingTargets", PROCESSING_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskProcessingDetails, T> g) {
        return obj -> g.apply((TaskProcessingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskProcessingDetails> {
        /**
         * <p>
         * The number of canceled things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfCanceledThings
         *        The number of canceled things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCanceledThings(Integer numberOfCanceledThings);

        /**
         * <p>
         * The number of failed things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfFailedThings
         *        The number of failed things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFailedThings(Integer numberOfFailedThings);

        /**
         * <p>
         * The number of in progress things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfInProgressThings
         *        The number of in progress things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfInProgressThings(Integer numberOfInProgressThings);

        /**
         * <p>
         * The number of queued things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfQueuedThings
         *        The number of queued things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfQueuedThings(Integer numberOfQueuedThings);

        /**
         * <p>
         * The number of rejected things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfRejectedThings
         *        The number of rejected things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRejectedThings(Integer numberOfRejectedThings);

        /**
         * <p>
         * The number of removed things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfRemovedThings
         *        The number of removed things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRemovedThings(Integer numberOfRemovedThings);

        /**
         * <p>
         * The number of succeeded things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfSucceededThings
         *        The number of succeeded things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfSucceededThings(Integer numberOfSucceededThings);

        /**
         * <p>
         * The number of timed out things in an over-the-air (OTA) task.
         * </p>
         * 
         * @param numberOfTimedOutThings
         *        The number of timed out things in an over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTimedOutThings(Integer numberOfTimedOutThings);

        /**
         * <p>
         * The targets of the over-the-air (OTA) task.
         * </p>
         * 
         * @param processingTargets
         *        The targets of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingTargets(Collection<String> processingTargets);

        /**
         * <p>
         * The targets of the over-the-air (OTA) task.
         * </p>
         * 
         * @param processingTargets
         *        The targets of the over-the-air (OTA) task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingTargets(String... processingTargets);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfCanceledThings;

        private Integer numberOfFailedThings;

        private Integer numberOfInProgressThings;

        private Integer numberOfQueuedThings;

        private Integer numberOfRejectedThings;

        private Integer numberOfRemovedThings;

        private Integer numberOfSucceededThings;

        private Integer numberOfTimedOutThings;

        private List<String> processingTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskProcessingDetails model) {
            numberOfCanceledThings(model.numberOfCanceledThings);
            numberOfFailedThings(model.numberOfFailedThings);
            numberOfInProgressThings(model.numberOfInProgressThings);
            numberOfQueuedThings(model.numberOfQueuedThings);
            numberOfRejectedThings(model.numberOfRejectedThings);
            numberOfRemovedThings(model.numberOfRemovedThings);
            numberOfSucceededThings(model.numberOfSucceededThings);
            numberOfTimedOutThings(model.numberOfTimedOutThings);
            processingTargets(model.processingTargets);
        }

        public final Integer getNumberOfCanceledThings() {
            return numberOfCanceledThings;
        }

        public final void setNumberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
        }

        @Override
        public final Builder numberOfCanceledThings(Integer numberOfCanceledThings) {
            this.numberOfCanceledThings = numberOfCanceledThings;
            return this;
        }

        public final Integer getNumberOfFailedThings() {
            return numberOfFailedThings;
        }

        public final void setNumberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
        }

        @Override
        public final Builder numberOfFailedThings(Integer numberOfFailedThings) {
            this.numberOfFailedThings = numberOfFailedThings;
            return this;
        }

        public final Integer getNumberOfInProgressThings() {
            return numberOfInProgressThings;
        }

        public final void setNumberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
        }

        @Override
        public final Builder numberOfInProgressThings(Integer numberOfInProgressThings) {
            this.numberOfInProgressThings = numberOfInProgressThings;
            return this;
        }

        public final Integer getNumberOfQueuedThings() {
            return numberOfQueuedThings;
        }

        public final void setNumberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
        }

        @Override
        public final Builder numberOfQueuedThings(Integer numberOfQueuedThings) {
            this.numberOfQueuedThings = numberOfQueuedThings;
            return this;
        }

        public final Integer getNumberOfRejectedThings() {
            return numberOfRejectedThings;
        }

        public final void setNumberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
        }

        @Override
        public final Builder numberOfRejectedThings(Integer numberOfRejectedThings) {
            this.numberOfRejectedThings = numberOfRejectedThings;
            return this;
        }

        public final Integer getNumberOfRemovedThings() {
            return numberOfRemovedThings;
        }

        public final void setNumberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
        }

        @Override
        public final Builder numberOfRemovedThings(Integer numberOfRemovedThings) {
            this.numberOfRemovedThings = numberOfRemovedThings;
            return this;
        }

        public final Integer getNumberOfSucceededThings() {
            return numberOfSucceededThings;
        }

        public final void setNumberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
        }

        @Override
        public final Builder numberOfSucceededThings(Integer numberOfSucceededThings) {
            this.numberOfSucceededThings = numberOfSucceededThings;
            return this;
        }

        public final Integer getNumberOfTimedOutThings() {
            return numberOfTimedOutThings;
        }

        public final void setNumberOfTimedOutThings(Integer numberOfTimedOutThings) {
            this.numberOfTimedOutThings = numberOfTimedOutThings;
        }

        @Override
        public final Builder numberOfTimedOutThings(Integer numberOfTimedOutThings) {
            this.numberOfTimedOutThings = numberOfTimedOutThings;
            return this;
        }

        public final Collection<String> getProcessingTargets() {
            if (processingTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return processingTargets;
        }

        public final void setProcessingTargets(Collection<String> processingTargets) {
            this.processingTargets = TargetCopier.copy(processingTargets);
        }

        @Override
        public final Builder processingTargets(Collection<String> processingTargets) {
            this.processingTargets = TargetCopier.copy(processingTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingTargets(String... processingTargets) {
            processingTargets(Arrays.asList(processingTargets));
            return this;
        }

        @Override
        public TaskProcessingDetails build() {
            return new TaskProcessingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
