/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorDestinationRequest extends IotManagedIntegrationsRequest implements
        ToCopyableBuilder<UpdateConnectorDestinationRequest.Builder, UpdateConnectorDestinationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateConnectorDestinationRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateConnectorDestinationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateConnectorDestinationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthType").getter(getter(UpdateConnectorDestinationRequest::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<AuthConfigUpdate> AUTH_CONFIG_FIELD = SdkField
            .<AuthConfigUpdate> builder(MarshallingType.SDK_POJO).memberName("AuthConfig")
            .getter(getter(UpdateConnectorDestinationRequest::authConfig)).setter(setter(Builder::authConfig))
            .constructor(AuthConfigUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthConfig").build()).build();

    private static final SdkField<SecretsManager> SECRETS_MANAGER_FIELD = SdkField
            .<SecretsManager> builder(MarshallingType.SDK_POJO).memberName("SecretsManager")
            .getter(getter(UpdateConnectorDestinationRequest::secretsManager)).setter(setter(Builder::secretsManager))
            .constructor(SecretsManager::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManager").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, AUTH_TYPE_FIELD, AUTH_CONFIG_FIELD, SECRETS_MANAGER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String description;

    private final String name;

    private final String authType;

    private final AuthConfigUpdate authConfig;

    private final SecretsManager secretsManager;

    private UpdateConnectorDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.name = builder.name;
        this.authType = builder.authType;
        this.authConfig = builder.authConfig;
        this.secretsManager = builder.secretsManager;
    }

    /**
     * <p>
     * The unique identifier of the connector destination to update.
     * </p>
     * 
     * @return The unique identifier of the connector destination to update.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The new description to assign to the connector destination.
     * </p>
     * 
     * @return The new description to assign to the connector destination.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The new display name to assign to the connector destination.
     * </p>
     * 
     * @return The new display name to assign to the connector destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new authentication type to use for the connector destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The new authentication type to use for the connector destination.
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The new authentication type to use for the connector destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The new authentication type to use for the connector destination.
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The updated authentication configuration details for the connector destination.
     * </p>
     * 
     * @return The updated authentication configuration details for the connector destination.
     */
    public final AuthConfigUpdate authConfig() {
        return authConfig;
    }

    /**
     * <p>
     * The updated AWS Secrets Manager configuration for the connector destination.
     * </p>
     * 
     * @return The updated AWS Secrets Manager configuration for the connector destination.
     */
    public final SecretsManager secretsManager() {
        return secretsManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authConfig());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManager());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorDestinationRequest)) {
            return false;
        }
        UpdateConnectorDestinationRequest other = (UpdateConnectorDestinationRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(authConfig(), other.authConfig()) && Objects.equals(secretsManager(), other.secretsManager());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorDestinationRequest").add("Identifier", identifier())
                .add("Description", description()).add("Name", name()).add("AuthType", authTypeAsString())
                .add("AuthConfig", authConfig()).add("SecretsManager", secretsManager()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "AuthConfig":
            return Optional.ofNullable(clazz.cast(authConfig()));
        case "SecretsManager":
            return Optional.ofNullable(clazz.cast(secretsManager()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("AuthConfig", AUTH_CONFIG_FIELD);
        map.put("SecretsManager", SECRETS_MANAGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorDestinationRequest, T> g) {
        return obj -> g.apply((UpdateConnectorDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotManagedIntegrationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConnectorDestinationRequest> {
        /**
         * <p>
         * The unique identifier of the connector destination to update.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the connector destination to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The new description to assign to the connector destination.
         * </p>
         * 
         * @param description
         *        The new description to assign to the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The new display name to assign to the connector destination.
         * </p>
         * 
         * @param name
         *        The new display name to assign to the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new authentication type to use for the connector destination.
         * </p>
         * 
         * @param authType
         *        The new authentication type to use for the connector destination.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The new authentication type to use for the connector destination.
         * </p>
         * 
         * @param authType
         *        The new authentication type to use for the connector destination.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        /**
         * <p>
         * The updated authentication configuration details for the connector destination.
         * </p>
         * 
         * @param authConfig
         *        The updated authentication configuration details for the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authConfig(AuthConfigUpdate authConfig);

        /**
         * <p>
         * The updated authentication configuration details for the connector destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthConfigUpdate.Builder} avoiding the
         * need to create one manually via {@link AuthConfigUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthConfigUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #authConfig(AuthConfigUpdate)}.
         * 
         * @param authConfig
         *        a consumer that will call methods on {@link AuthConfigUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authConfig(AuthConfigUpdate)
         */
        default Builder authConfig(Consumer<AuthConfigUpdate.Builder> authConfig) {
            return authConfig(AuthConfigUpdate.builder().applyMutation(authConfig).build());
        }

        /**
         * <p>
         * The updated AWS Secrets Manager configuration for the connector destination.
         * </p>
         * 
         * @param secretsManager
         *        The updated AWS Secrets Manager configuration for the connector destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManager(SecretsManager secretsManager);

        /**
         * <p>
         * The updated AWS Secrets Manager configuration for the connector destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecretsManager.Builder} avoiding the need
         * to create one manually via {@link SecretsManager#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManager.Builder#build()} is called immediately and its
         * result is passed to {@link #secretsManager(SecretsManager)}.
         * 
         * @param secretsManager
         *        a consumer that will call methods on {@link SecretsManager.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManager(SecretsManager)
         */
        default Builder secretsManager(Consumer<SecretsManager.Builder> secretsManager) {
            return secretsManager(SecretsManager.builder().applyMutation(secretsManager).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotManagedIntegrationsRequest.BuilderImpl implements Builder {
        private String identifier;

        private String description;

        private String name;

        private String authType;

        private AuthConfigUpdate authConfig;

        private SecretsManager secretsManager;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorDestinationRequest model) {
            super(model);
            identifier(model.identifier);
            description(model.description);
            name(model.name);
            authType(model.authType);
            authConfig(model.authConfig);
            secretsManager(model.secretsManager);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final AuthConfigUpdate.Builder getAuthConfig() {
            return authConfig != null ? authConfig.toBuilder() : null;
        }

        public final void setAuthConfig(AuthConfigUpdate.BuilderImpl authConfig) {
            this.authConfig = authConfig != null ? authConfig.build() : null;
        }

        @Override
        public final Builder authConfig(AuthConfigUpdate authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public final SecretsManager.Builder getSecretsManager() {
            return secretsManager != null ? secretsManager.toBuilder() : null;
        }

        public final void setSecretsManager(SecretsManager.BuilderImpl secretsManager) {
            this.secretsManager = secretsManager != null ? secretsManager.build() : null;
        }

        @Override
        public final Builder secretsManager(SecretsManager secretsManager) {
            this.secretsManager = secretsManager;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorDestinationRequest build() {
            return new UpdateConnectorDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
