/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerAsyncClient;
import software.amazon.awssdk.services.iotroborunner.model.Destination;
import software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse;

public class ListDestinationsPublisher
implements SdkPublisher<ListDestinationsResponse> {
    private final IotRoboRunnerAsyncClient client;
    private final ListDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDestinationsPublisher(IotRoboRunnerAsyncClient client, ListDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDestinationsPublisher(IotRoboRunnerAsyncClient client, ListDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Destination> destinations() {
        Function<ListDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinations() != null) {
                return response.destinations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDestinationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDestinationsResponseFetcher
    implements AsyncPageFetcher<ListDestinationsResponse> {
        private ListDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDestinationsResponse> nextPage(ListDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListDestinationsPublisher.this.client.listDestinations(ListDestinationsPublisher.this.firstRequest);
            }
            return ListDestinationsPublisher.this.client.listDestinations((ListDestinationsRequest)((Object)ListDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

