/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotroborunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Cartesian coordinates in 3D space relative to the RoboRunner origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CartesianCoordinates implements SdkPojo, Serializable,
        ToCopyableBuilder<CartesianCoordinates.Builder, CartesianCoordinates> {
    private static final SdkField<Double> X_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("x")
            .getter(getter(CartesianCoordinates::x)).setter(setter(Builder::x))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x").build()).build();

    private static final SdkField<Double> Y_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("y")
            .getter(getter(CartesianCoordinates::y)).setter(setter(Builder::y))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("y").build()).build();

    private static final SdkField<Double> Z_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("z")
            .getter(getter(CartesianCoordinates::z)).setter(setter(Builder::z))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("z").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X_FIELD, Y_FIELD, Z_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double x;

    private final Double y;

    private final Double z;

    private CartesianCoordinates(BuilderImpl builder) {
        this.x = builder.x;
        this.y = builder.y;
        this.z = builder.z;
    }

    /**
     * <p>
     * X coordinate.
     * </p>
     * 
     * @return X coordinate.
     */
    public final Double x() {
        return x;
    }

    /**
     * <p>
     * Y coordinate.
     * </p>
     * 
     * @return Y coordinate.
     */
    public final Double y() {
        return y;
    }

    /**
     * <p>
     * Z coordinate.
     * </p>
     * 
     * @return Z coordinate.
     */
    public final Double z() {
        return z;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(x());
        hashCode = 31 * hashCode + Objects.hashCode(y());
        hashCode = 31 * hashCode + Objects.hashCode(z());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CartesianCoordinates)) {
            return false;
        }
        CartesianCoordinates other = (CartesianCoordinates) obj;
        return Objects.equals(x(), other.x()) && Objects.equals(y(), other.y()) && Objects.equals(z(), other.z());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CartesianCoordinates").add("X", x()).add("Y", y()).add("Z", z()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "x":
            return Optional.ofNullable(clazz.cast(x()));
        case "y":
            return Optional.ofNullable(clazz.cast(y()));
        case "z":
            return Optional.ofNullable(clazz.cast(z()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CartesianCoordinates, T> g) {
        return obj -> g.apply((CartesianCoordinates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CartesianCoordinates> {
        /**
         * <p>
         * X coordinate.
         * </p>
         * 
         * @param x
         *        X coordinate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(Double x);

        /**
         * <p>
         * Y coordinate.
         * </p>
         * 
         * @param y
         *        Y coordinate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(Double y);

        /**
         * <p>
         * Z coordinate.
         * </p>
         * 
         * @param z
         *        Z coordinate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder z(Double z);
    }

    static final class BuilderImpl implements Builder {
        private Double x;

        private Double y;

        private Double z;

        private BuilderImpl() {
        }

        private BuilderImpl(CartesianCoordinates model) {
            x(model.x);
            y(model.y);
            z(model.z);
        }

        public final Double getX() {
            return x;
        }

        public final void setX(Double x) {
            this.x = x;
        }

        @Override
        public final Builder x(Double x) {
            this.x = x;
            return this;
        }

        public final Double getY() {
            return y;
        }

        public final void setY(Double y) {
            this.y = y;
        }

        @Override
        public final Builder y(Double y) {
            this.y = y;
            return this;
        }

        public final Double getZ() {
            return z;
        }

        public final void setZ(Double z) {
            this.z = z;
        }

        @Override
        public final Builder z(Double z) {
            this.z = z;
            return this;
        }

        @Override
        public CartesianCoordinates build() {
            return new CartesianCoordinates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
