/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Orientation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Orientation> {
    private static final SdkField<Double> DEGREES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("degrees").getter(Orientation.getter(Orientation::degrees)).setter(Orientation.setter(Builder::degrees)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("degrees").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEGREES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double degrees;
    private final Type type;

    private Orientation(BuilderImpl builder) {
        this.degrees = builder.degrees;
        this.type = builder.type;
    }

    public final Double degrees() {
        return this.degrees;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.degrees());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Orientation)) {
            return false;
        }
        Orientation other = (Orientation)obj;
        return Objects.equals(this.degrees(), other.degrees());
    }

    public final String toString() {
        return ToString.builder((String)"Orientation").add("Degrees", (Object)this.degrees()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "degrees": {
                return Optional.ofNullable(clazz.cast(this.degrees()));
            }
        }
        return Optional.empty();
    }

    public static Orientation fromDegrees(Double degrees) {
        return (Orientation)Orientation.builder().degrees(degrees).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Orientation, T> g) {
        return obj -> g.apply((Orientation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DEGREES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Double degrees;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Orientation model) {
            this.degrees(model.degrees);
        }

        public final Double getDegrees() {
            return this.degrees;
        }

        public final void setDegrees(Double degrees) {
            Double oldValue = this.degrees;
            this.degrees = degrees;
            this.handleUnionValueChange(Type.DEGREES, oldValue, this.degrees);
        }

        @Override
        public final Builder degrees(Double degrees) {
            Double oldValue = this.degrees;
            this.degrees = degrees;
            this.handleUnionValueChange(Type.DEGREES, oldValue, this.degrees);
            return this;
        }

        public Orientation build() {
            return new Orientation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Orientation> {
        public Builder degrees(Double var1);
    }
}

