/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotroborunner;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.iotroborunner.model.CreateDestinationRequest;
import software.amazon.awssdk.services.iotroborunner.model.CreateDestinationResponse;
import software.amazon.awssdk.services.iotroborunner.model.CreateSiteRequest;
import software.amazon.awssdk.services.iotroborunner.model.CreateSiteResponse;
import software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetRequest;
import software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetResponse;
import software.amazon.awssdk.services.iotroborunner.model.CreateWorkerRequest;
import software.amazon.awssdk.services.iotroborunner.model.CreateWorkerResponse;
import software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.iotroborunner.model.DeleteSiteRequest;
import software.amazon.awssdk.services.iotroborunner.model.DeleteSiteResponse;
import software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetRequest;
import software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetResponse;
import software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerRequest;
import software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerResponse;
import software.amazon.awssdk.services.iotroborunner.model.GetDestinationRequest;
import software.amazon.awssdk.services.iotroborunner.model.GetDestinationResponse;
import software.amazon.awssdk.services.iotroborunner.model.GetSiteRequest;
import software.amazon.awssdk.services.iotroborunner.model.GetSiteResponse;
import software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetRequest;
import software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetResponse;
import software.amazon.awssdk.services.iotroborunner.model.GetWorkerRequest;
import software.amazon.awssdk.services.iotroborunner.model.GetWorkerResponse;
import software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse;
import software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse;
import software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.iotroborunner.model.UpdateSiteRequest;
import software.amazon.awssdk.services.iotroborunner.model.UpdateSiteResponse;
import software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetRequest;
import software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetResponse;
import software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerRequest;
import software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerResponse;
import software.amazon.awssdk.services.iotroborunner.paginators.ListDestinationsPublisher;
import software.amazon.awssdk.services.iotroborunner.paginators.ListSitesPublisher;
import software.amazon.awssdk.services.iotroborunner.paginators.ListWorkerFleetsPublisher;
import software.amazon.awssdk.services.iotroborunner.paginators.ListWorkersPublisher;

/**
 * Service client for accessing AWS IoT RoboRunner asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * An example service, deployed with the Octane Service creator, which will echo the string
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotRoboRunnerAsyncClient extends AwsClient {
    String SERVICE_NAME = "iotroborunner";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iotroborunner";

    /**
     * <p>
     * Grants permission to create a destination
     * </p>
     *
     * @param createDestinationRequest
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(CreateDestinationRequest createDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to create a destination
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDestinationRequest#builder()}
     * </p>
     *
     * @param createDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.CreateDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDestinationResponse> createDestination(
            Consumer<CreateDestinationRequest.Builder> createDestinationRequest) {
        return createDestination(CreateDestinationRequest.builder().applyMutation(createDestinationRequest).build());
    }

    /**
     * <p>
     * Grants permission to create a site
     * </p>
     *
     * @param createSiteRequest
     * @return A Java Future containing the result of the CreateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSiteResponse> createSite(CreateSiteRequest createSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to create a site
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSiteRequest#builder()}
     * </p>
     *
     * @param createSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.CreateSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSiteResponse> createSite(Consumer<CreateSiteRequest.Builder> createSiteRequest) {
        return createSite(CreateSiteRequest.builder().applyMutation(createSiteRequest).build());
    }

    /**
     * <p>
     * Grants permission to create a worker
     * </p>
     *
     * @param createWorkerRequest
     * @return A Java Future containing the result of the CreateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorker" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkerResponse> createWorker(CreateWorkerRequest createWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to create a worker
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkerRequest#builder()}
     * </p>
     *
     * @param createWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.CreateWorkerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorker" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkerResponse> createWorker(Consumer<CreateWorkerRequest.Builder> createWorkerRequest) {
        return createWorker(CreateWorkerRequest.builder().applyMutation(createWorkerRequest).build());
    }

    /**
     * <p>
     * Grants permission to create a worker fleet
     * </p>
     *
     * @param createWorkerFleetRequest
     * @return A Java Future containing the result of the CreateWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorkerFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkerFleetResponse> createWorkerFleet(CreateWorkerFleetRequest createWorkerFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to create a worker fleet
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkerFleetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkerFleetRequest#builder()}
     * </p>
     *
     * @param createWorkerFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.CreateWorkerFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>ServiceQuotaExceededException Exception thrown if the user's AWS account has reached a service limit
     *         and the operation cannot proceed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.CreateWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/CreateWorkerFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkerFleetResponse> createWorkerFleet(
            Consumer<CreateWorkerFleetRequest.Builder> createWorkerFleetRequest) {
        return createWorkerFleet(CreateWorkerFleetRequest.builder().applyMutation(createWorkerFleetRequest).build());
    }

    /**
     * <p>
     * Grants permission to delete a destination
     * </p>
     *
     * @param deleteDestinationRequest
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(DeleteDestinationRequest deleteDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to delete a destination
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDestinationRequest#builder()}
     * </p>
     *
     * @param deleteDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.DeleteDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDestinationResponse> deleteDestination(
            Consumer<DeleteDestinationRequest.Builder> deleteDestinationRequest) {
        return deleteDestination(DeleteDestinationRequest.builder().applyMutation(deleteDestinationRequest).build());
    }

    /**
     * <p>
     * Grants permission to delete a site
     * </p>
     *
     * @param deleteSiteRequest
     * @return A Java Future containing the result of the DeleteSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSiteResponse> deleteSite(DeleteSiteRequest deleteSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to delete a site
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSiteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSiteRequest#builder()}
     * </p>
     *
     * @param deleteSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.DeleteSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSiteResponse> deleteSite(Consumer<DeleteSiteRequest.Builder> deleteSiteRequest) {
        return deleteSite(DeleteSiteRequest.builder().applyMutation(deleteSiteRequest).build());
    }

    /**
     * <p>
     * Grants permission to delete a worker
     * </p>
     *
     * @param deleteWorkerRequest
     * @return A Java Future containing the result of the DeleteWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorker" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkerResponse> deleteWorker(DeleteWorkerRequest deleteWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to delete a worker
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkerRequest#builder()}
     * </p>
     *
     * @param deleteWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorker" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkerResponse> deleteWorker(Consumer<DeleteWorkerRequest.Builder> deleteWorkerRequest) {
        return deleteWorker(DeleteWorkerRequest.builder().applyMutation(deleteWorkerRequest).build());
    }

    /**
     * <p>
     * Grants permission to delete a worker fleet
     * </p>
     *
     * @param deleteWorkerFleetRequest
     * @return A Java Future containing the result of the DeleteWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorkerFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkerFleetResponse> deleteWorkerFleet(DeleteWorkerFleetRequest deleteWorkerFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to delete a worker fleet
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkerFleetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkerFleetRequest#builder()}
     * </p>
     *
     * @param deleteWorkerFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.DeleteWorkerFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Exception thrown if a resource in a create request already exists.</li>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.DeleteWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/DeleteWorkerFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkerFleetResponse> deleteWorkerFleet(
            Consumer<DeleteWorkerFleetRequest.Builder> deleteWorkerFleetRequest) {
        return deleteWorkerFleet(DeleteWorkerFleetRequest.builder().applyMutation(deleteWorkerFleetRequest).build());
    }

    /**
     * <p>
     * Grants permission to get a destination
     * </p>
     *
     * @param getDestinationRequest
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(GetDestinationRequest getDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to get a destination
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDestinationRequest.Builder} avoiding the need to
     * create one manually via {@link GetDestinationRequest#builder()}
     * </p>
     *
     * @param getDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.GetDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetDestination" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDestinationResponse> getDestination(Consumer<GetDestinationRequest.Builder> getDestinationRequest) {
        return getDestination(GetDestinationRequest.builder().applyMutation(getDestinationRequest).build());
    }

    /**
     * <p>
     * Grants permission to get a site
     * </p>
     *
     * @param getSiteRequest
     * @return A Java Future containing the result of the GetSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSiteResponse> getSite(GetSiteRequest getSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to get a site
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSiteRequest.Builder} avoiding the need to create
     * one manually via {@link GetSiteRequest#builder()}
     * </p>
     *
     * @param getSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.GetSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSiteResponse> getSite(Consumer<GetSiteRequest.Builder> getSiteRequest) {
        return getSite(GetSiteRequest.builder().applyMutation(getSiteRequest).build());
    }

    /**
     * <p>
     * Grants permission to get a worker
     * </p>
     *
     * @param getWorkerRequest
     * @return A Java Future containing the result of the GetWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkerResponse> getWorker(GetWorkerRequest getWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to get a worker
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkerRequest#builder()}
     * </p>
     *
     * @param getWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.GetWorkerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorker" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkerResponse> getWorker(Consumer<GetWorkerRequest.Builder> getWorkerRequest) {
        return getWorker(GetWorkerRequest.builder().applyMutation(getWorkerRequest).build());
    }

    /**
     * <p>
     * Grants permission to get a worker fleet
     * </p>
     *
     * @param getWorkerFleetRequest
     * @return A Java Future containing the result of the GetWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorkerFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkerFleetResponse> getWorkerFleet(GetWorkerFleetRequest getWorkerFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to get a worker fleet
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkerFleetRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkerFleetRequest#builder()}
     * </p>
     *
     * @param getWorkerFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.GetWorkerFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.GetWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/GetWorkerFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetWorkerFleetResponse> getWorkerFleet(Consumer<GetWorkerFleetRequest.Builder> getWorkerFleetRequest) {
        return getWorkerFleet(GetWorkerFleetRequest.builder().applyMutation(getWorkerFleetRequest).build());
    }

    /**
     * <p>
     * Grants permission to list destinations
     * </p>
     *
     * @param listDestinationsRequest
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(ListDestinationsRequest listDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to list destinations
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDestinationsResponse> listDestinations(
            Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinations(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDestinationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(ListDestinationsRequest listDestinationsRequest) {
        return new ListDestinationsPublisher(this, listDestinationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDestinations(software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListDestinationsPublisher publisher = client.listDestinationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListDestinationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDestinations(software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDestinationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDestinationsRequest#builder()}
     * </p>
     *
     * @param listDestinationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListDestinationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDestinationsPublisher listDestinationsPaginator(Consumer<ListDestinationsRequest.Builder> listDestinationsRequest) {
        return listDestinationsPaginator(ListDestinationsRequest.builder().applyMutation(listDestinationsRequest).build());
    }

    /**
     * <p>
     * Grants permission to list sites
     * </p>
     *
     * @param listSitesRequest
     * @return A Java Future containing the result of the ListSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSitesResponse> listSites(ListSitesRequest listSitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to list sites
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSitesRequest#builder()}
     * </p>
     *
     * @param listSitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSitesResponse> listSites(Consumer<ListSitesRequest.Builder> listSitesRequest) {
        return listSites(ListSitesRequest.builder().applyMutation(listSitesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSites(software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSites(software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest)} operation.</b>
     * </p>
     *
     * @param listSitesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesPublisher listSitesPaginator(ListSitesRequest listSitesRequest) {
        return new ListSitesPublisher(this, listSitesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSites(software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListSitesPublisher publisher = client.listSitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListSitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSites(software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSitesRequest#builder()}
     * </p>
     *
     * @param listSitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListSitesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesPublisher listSitesPaginator(Consumer<ListSitesRequest.Builder> listSitesRequest) {
        return listSitesPaginator(ListSitesRequest.builder().applyMutation(listSitesRequest).build());
    }

    /**
     * <p>
     * Grants permission to list worker fleets
     * </p>
     *
     * @param listWorkerFleetsRequest
     * @return A Java Future containing the result of the ListWorkerFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkerFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkerFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkerFleetsResponse> listWorkerFleets(ListWorkerFleetsRequest listWorkerFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to list worker fleets
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerFleetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkerFleetsRequest#builder()}
     * </p>
     *
     * @param listWorkerFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkerFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkerFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkerFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkerFleetsResponse> listWorkerFleets(
            Consumer<ListWorkerFleetsRequest.Builder> listWorkerFleetsRequest) {
        return listWorkerFleets(ListWorkerFleetsRequest.builder().applyMutation(listWorkerFleetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkerFleets(software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkerFleetsPublisher publisher = client.listWorkerFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkerFleetsPublisher publisher = client.listWorkerFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerFleets(software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkerFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkerFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkerFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerFleetsPublisher listWorkerFleetsPaginator(ListWorkerFleetsRequest listWorkerFleetsRequest) {
        return new ListWorkerFleetsPublisher(this, listWorkerFleetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkerFleets(software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkerFleetsPublisher publisher = client.listWorkerFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkerFleetsPublisher publisher = client.listWorkerFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkerFleets(software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkerFleetsRequest.Builder} avoiding the need
     * to create one manually via {@link ListWorkerFleetsRequest#builder()}
     * </p>
     *
     * @param listWorkerFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkerFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkerFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkerFleetsPublisher listWorkerFleetsPaginator(Consumer<ListWorkerFleetsRequest.Builder> listWorkerFleetsRequest) {
        return listWorkerFleetsPaginator(ListWorkerFleetsRequest.builder().applyMutation(listWorkerFleetsRequest).build());
    }

    /**
     * <p>
     * Grants permission to list workers
     * </p>
     *
     * @param listWorkersRequest
     * @return A Java Future containing the result of the ListWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkersResponse> listWorkers(ListWorkersRequest listWorkersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to list workers
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkersRequest#builder()}
     * </p>
     *
     * @param listWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkersResponse> listWorkers(Consumer<ListWorkersRequest.Builder> listWorkersRequest) {
        return listWorkers(ListWorkersRequest.builder().applyMutation(listWorkersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkers(software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkers(software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest)} operation.</b>
     * </p>
     *
     * @param listWorkersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkersPublisher listWorkersPaginator(ListWorkersRequest listWorkersRequest) {
        return new ListWorkersPublisher(this, listWorkersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkers(software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotroborunner.paginators.ListWorkersPublisher publisher = client.listWorkersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotroborunner.model.ListWorkersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkers(software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkersRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkersRequest#builder()}
     * </p>
     *
     * @param listWorkersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.ListWorkers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/ListWorkers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkersPublisher listWorkersPaginator(Consumer<ListWorkersRequest.Builder> listWorkersRequest) {
        return listWorkersPaginator(ListWorkersRequest.builder().applyMutation(listWorkersRequest).build());
    }

    /**
     * <p>
     * Grants permission to update a destination
     * </p>
     *
     * @param updateDestinationRequest
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(UpdateDestinationRequest updateDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to update a destination
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDestinationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDestinationRequest#builder()}
     * </p>
     *
     * @param updateDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.UpdateDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDestinationResponse> updateDestination(
            Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest) {
        return updateDestination(UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest).build());
    }

    /**
     * <p>
     * Grants permission to update a site
     * </p>
     *
     * @param updateSiteRequest
     * @return A Java Future containing the result of the UpdateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSiteResponse> updateSite(UpdateSiteRequest updateSiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to update a site
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSiteRequest#builder()}
     * </p>
     *
     * @param updateSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.UpdateSiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSiteResponse> updateSite(Consumer<UpdateSiteRequest.Builder> updateSiteRequest) {
        return updateSite(UpdateSiteRequest.builder().applyMutation(updateSiteRequest).build());
    }

    /**
     * <p>
     * Grants permission to update a worker
     * </p>
     *
     * @param updateWorkerRequest
     * @return A Java Future containing the result of the UpdateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorker" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkerResponse> updateWorker(UpdateWorkerRequest updateWorkerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to update a worker
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkerRequest#builder()}
     * </p>
     *
     * @param updateWorkerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorker operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateWorker
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorker" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkerResponse> updateWorker(Consumer<UpdateWorkerRequest.Builder> updateWorkerRequest) {
        return updateWorker(UpdateWorkerRequest.builder().applyMutation(updateWorkerRequest).build());
    }

    /**
     * <p>
     * Grants permission to update a worker fleet
     * </p>
     *
     * @param updateWorkerFleetRequest
     * @return A Java Future containing the result of the UpdateWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorkerFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkerFleetResponse> updateWorkerFleet(UpdateWorkerFleetRequest updateWorkerFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to update a worker fleet
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkerFleetRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateWorkerFleetRequest#builder()}
     * </p>
     *
     * @param updateWorkerFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iotroborunner.model.UpdateWorkerFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorkerFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException User does not have sufficient access to perform this action.</li>
     *         <li>ValidationException Exception thrown if an invalid parameter is provided to an API.</li>
     *         <li>ResourceNotFoundException Exception thrown if a resource referenced in the request doesn't exist.</li>
     *         <li>ThrottlingException Exception thrown if the api has been called too quickly be the client.</li>
     *         <li>InternalServerException Exception thrown if something goes wrong within the service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotRoboRunnerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample IotRoboRunnerAsyncClient.UpdateWorkerFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot-roborunner-2018-05-10/UpdateWorkerFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateWorkerFleetResponse> updateWorkerFleet(
            Consumer<UpdateWorkerFleetRequest.Builder> updateWorkerFleetRequest) {
        return updateWorkerFleet(UpdateWorkerFleetRequest.builder().applyMutation(updateWorkerFleetRequest).build());
    }

    @Override
    default IotRoboRunnerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link IotRoboRunnerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotRoboRunnerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotRoboRunnerAsyncClient}.
     */
    static IotRoboRunnerAsyncClientBuilder builder() {
        return new DefaultIotRoboRunnerAsyncClientBuilder();
    }
}
