/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTunnelsResponse extends IoTSecureTunnelingResponse implements
        ToCopyableBuilder<ListTunnelsResponse.Builder, ListTunnelsResponse> {
    private static final SdkField<List<TunnelSummary>> TUNNEL_SUMMARIES_FIELD = SdkField
            .<List<TunnelSummary>> builder(MarshallingType.LIST)
            .memberName("tunnelSummaries")
            .getter(getter(ListTunnelsResponse::tunnelSummaries))
            .setter(setter(Builder::tunnelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TunnelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TunnelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTunnelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TunnelSummary> tunnelSummaries;

    private final String nextToken;

    private ListTunnelsResponse(BuilderImpl builder) {
        super(builder);
        this.tunnelSummaries = builder.tunnelSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TunnelSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTunnelSummaries() {
        return tunnelSummaries != null && !(tunnelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A short description of the tunnels in an AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTunnelSummaries} method.
     * </p>
     * 
     * @return A short description of the tunnels in an AWS account.
     */
    public final List<TunnelSummary> tunnelSummaries() {
        return tunnelSummaries;
    }

    /**
     * <p>
     * A token to used to retrieve the next set of results.
     * </p>
     * 
     * @return A token to used to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTunnelSummaries() ? tunnelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTunnelsResponse)) {
            return false;
        }
        ListTunnelsResponse other = (ListTunnelsResponse) obj;
        return hasTunnelSummaries() == other.hasTunnelSummaries() && Objects.equals(tunnelSummaries(), other.tunnelSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTunnelsResponse").add("TunnelSummaries", hasTunnelSummaries() ? tunnelSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnelSummaries":
            return Optional.ofNullable(clazz.cast(tunnelSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTunnelsResponse, T> g) {
        return obj -> g.apply((ListTunnelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSecureTunnelingResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTunnelsResponse> {
        /**
         * <p>
         * A short description of the tunnels in an AWS account.
         * </p>
         * 
         * @param tunnelSummaries
         *        A short description of the tunnels in an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelSummaries(Collection<TunnelSummary> tunnelSummaries);

        /**
         * <p>
         * A short description of the tunnels in an AWS account.
         * </p>
         * 
         * @param tunnelSummaries
         *        A short description of the tunnels in an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelSummaries(TunnelSummary... tunnelSummaries);

        /**
         * <p>
         * A short description of the tunnels in an AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TunnelSummary>.Builder} avoiding the need
         * to create one manually via {@link List<TunnelSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TunnelSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #tunnelSummaries(List<TunnelSummary>)}.
         * 
         * @param tunnelSummaries
         *        a consumer that will call methods on {@link List<TunnelSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunnelSummaries(List<TunnelSummary>)
         */
        Builder tunnelSummaries(Consumer<TunnelSummary.Builder>... tunnelSummaries);

        /**
         * <p>
         * A token to used to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to used to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSecureTunnelingResponse.BuilderImpl implements Builder {
        private List<TunnelSummary> tunnelSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTunnelsResponse model) {
            super(model);
            tunnelSummaries(model.tunnelSummaries);
            nextToken(model.nextToken);
        }

        public final List<TunnelSummary.Builder> getTunnelSummaries() {
            List<TunnelSummary.Builder> result = TunnelSummaryListCopier.copyToBuilder(this.tunnelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTunnelSummaries(Collection<TunnelSummary.BuilderImpl> tunnelSummaries) {
            this.tunnelSummaries = TunnelSummaryListCopier.copyFromBuilder(tunnelSummaries);
        }

        @Override
        @Transient
        public final Builder tunnelSummaries(Collection<TunnelSummary> tunnelSummaries) {
            this.tunnelSummaries = TunnelSummaryListCopier.copy(tunnelSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tunnelSummaries(TunnelSummary... tunnelSummaries) {
            tunnelSummaries(Arrays.asList(tunnelSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tunnelSummaries(Consumer<TunnelSummary.Builder>... tunnelSummaries) {
            tunnelSummaries(Stream.of(tunnelSummaries).map(c -> TunnelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTunnelsResponse build() {
            return new ListTunnelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
