/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.IoTSecureTunnelingException;
import software.amazon.awssdk.services.iotsecuretunneling.model.LimitExceededException;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsIterable;

/**
 * Service client for accessing AWS IoT Secure Tunneling. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS IoT Secure Tunneling</fullname>
 * <p>
 * AWS IoT Secure Tunnling enables you to create remote connections to devices deployed in the field.
 * </p>
 * <p>
 * For more information about how AWS IoT Secure Tunneling works, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/secure-tunneling.html">AWS IoT Secure Tunneling</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTSecureTunnelingClient extends SdkClient {
    String SERVICE_NAME = "IoTSecuredTunneling";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.tunneling.iot";

    /**
     * Create a {@link IoTSecureTunnelingClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTSecureTunnelingClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTSecureTunnelingClient}.
     */
    static IoTSecureTunnelingClientBuilder builder() {
        return new DefaultIoTSecureTunnelingClientBuilder();
    }

    /**
     * <p>
     * Closes a tunnel identified by the unique tunnel id. When a <code>CloseTunnel</code> request is received, we close
     * the WebSocket connections between the client and proxy server so no data can be transmitted.
     * </p>
     *
     * @param closeTunnelRequest
     * @return Result of the CloseTunnel operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.CloseTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/CloseTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default CloseTunnelResponse closeTunnel(CloseTunnelRequest closeTunnelRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Closes a tunnel identified by the unique tunnel id. When a <code>CloseTunnel</code> request is received, we close
     * the WebSocket connections between the client and proxy server so no data can be transmitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloseTunnelRequest.Builder} avoiding the need to
     * create one manually via {@link CloseTunnelRequest#builder()}
     * </p>
     *
     * @param closeTunnelRequest
     *        A {@link Consumer} that will call methods on {@link CloseTunnelRequest.Builder} to create a request.
     * @return Result of the CloseTunnel operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.CloseTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/CloseTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default CloseTunnelResponse closeTunnel(Consumer<CloseTunnelRequest.Builder> closeTunnelRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        return closeTunnel(CloseTunnelRequest.builder().applyMutation(closeTunnelRequest).build());
    }

    /**
     * <p>
     * Gets information about a tunnel identified by the unique tunnel id.
     * </p>
     *
     * @param describeTunnelRequest
     * @return Result of the DescribeTunnel operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.DescribeTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/DescribeTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTunnelResponse describeTunnel(DescribeTunnelRequest describeTunnelRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a tunnel identified by the unique tunnel id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTunnelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTunnelRequest#builder()}
     * </p>
     *
     * @param describeTunnelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTunnelRequest.Builder} to create a request.
     * @return Result of the DescribeTunnel operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.DescribeTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/DescribeTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTunnelResponse describeTunnel(Consumer<DescribeTunnelRequest.Builder> describeTunnelRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        return describeTunnel(DescribeTunnelRequest.builder().applyMutation(describeTunnelRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List all tunnels for an AWS account. Tunnels are listed by creation time in descending order, newer tunnels will
     * be listed before older tunnels.
     * </p>
     *
     * @param listTunnelsRequest
     * @return Result of the ListTunnels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTunnelsResponse listTunnels(ListTunnelsRequest listTunnelsRequest) throws AwsServiceException,
            SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tunnels for an AWS account. Tunnels are listed by creation time in descending order, newer tunnels will
     * be listed before older tunnels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTunnelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTunnelsRequest#builder()}
     * </p>
     *
     * @param listTunnelsRequest
     *        A {@link Consumer} that will call methods on {@link ListTunnelsRequest.Builder} to create a request.
     * @return Result of the ListTunnels operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTunnelsResponse listTunnels(Consumer<ListTunnelsRequest.Builder> listTunnelsRequest) throws AwsServiceException,
            SdkClientException, IoTSecureTunnelingException {
        return listTunnels(ListTunnelsRequest.builder().applyMutation(listTunnelsRequest).build());
    }

    /**
     * <p>
     * List all tunnels for an AWS account. Tunnels are listed by creation time in descending order, newer tunnels will
     * be listed before older tunnels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsIterable responses = client.listTunnelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsIterable responses = client
     *             .listTunnelsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsIterable responses = client.listTunnelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation.</b>
     * </p>
     *
     * @param listTunnelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTunnelsIterable listTunnelsPaginator(ListTunnelsRequest listTunnelsRequest) throws AwsServiceException,
            SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tunnels for an AWS account. Tunnels are listed by creation time in descending order, newer tunnels will
     * be listed before older tunnels.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsIterable responses = client.listTunnelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsIterable responses = client
     *             .listTunnelsPaginator(request);
     *     for (software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsIterable responses = client.listTunnelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTunnelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTunnelsRequest#builder()}
     * </p>
     *
     * @param listTunnelsRequest
     *        A {@link Consumer} that will call methods on {@link ListTunnelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTunnelsIterable listTunnelsPaginator(Consumer<ListTunnelsRequest.Builder> listTunnelsRequest)
            throws AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        return listTunnelsPaginator(ListTunnelsRequest.builder().applyMutation(listTunnelsRequest).build());
    }

    /**
     * <p>
     * Creates a new tunnel, and returns two client access tokens for clients to use to connect to the AWS IoT Secure
     * Tunneling proxy server.
     * </p>
     *
     * @param openTunnelRequest
     * @return Result of the OpenTunnel operation returned by the service.
     * @throws LimitExceededException
     *         Thrown when a tunnel limit is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.OpenTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/OpenTunnel" target="_top">AWS
     *      API Documentation</a>
     */
    default OpenTunnelResponse openTunnel(OpenTunnelRequest openTunnelRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new tunnel, and returns two client access tokens for clients to use to connect to the AWS IoT Secure
     * Tunneling proxy server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OpenTunnelRequest.Builder} avoiding the need to
     * create one manually via {@link OpenTunnelRequest#builder()}
     * </p>
     *
     * @param openTunnelRequest
     *        A {@link Consumer} that will call methods on {@link OpenTunnelRequest.Builder} to create a request.
     * @return Result of the OpenTunnel operation returned by the service.
     * @throws LimitExceededException
     *         Thrown when a tunnel limit is exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.OpenTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/OpenTunnel" target="_top">AWS
     *      API Documentation</a>
     */
    default OpenTunnelResponse openTunnel(Consumer<OpenTunnelRequest.Builder> openTunnelRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        return openTunnel(OpenTunnelRequest.builder().applyMutation(openTunnelRequest).build());
    }

    /**
     * <p>
     * A resource tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A resource tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Thrown when an operation is attempted on a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTSecureTunnelingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTSecureTunnelingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, IoTSecureTunnelingException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
