/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTunnelResponse extends IoTSecureTunnelingResponse implements
        ToCopyableBuilder<DescribeTunnelResponse.Builder, DescribeTunnelResponse> {
    private static final SdkField<Tunnel> TUNNEL_FIELD = SdkField.<Tunnel> builder(MarshallingType.SDK_POJO).memberName("tunnel")
            .getter(getter(DescribeTunnelResponse::tunnel)).setter(setter(Builder::tunnel)).constructor(Tunnel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_FIELD));

    private final Tunnel tunnel;

    private DescribeTunnelResponse(BuilderImpl builder) {
        super(builder);
        this.tunnel = builder.tunnel;
    }

    /**
     * <p>
     * The tunnel being described.
     * </p>
     * 
     * @return The tunnel being described.
     */
    public final Tunnel tunnel() {
        return tunnel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tunnel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTunnelResponse)) {
            return false;
        }
        DescribeTunnelResponse other = (DescribeTunnelResponse) obj;
        return Objects.equals(tunnel(), other.tunnel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTunnelResponse").add("Tunnel", tunnel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnel":
            return Optional.ofNullable(clazz.cast(tunnel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTunnelResponse, T> g) {
        return obj -> g.apply((DescribeTunnelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSecureTunnelingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTunnelResponse> {
        /**
         * <p>
         * The tunnel being described.
         * </p>
         * 
         * @param tunnel
         *        The tunnel being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnel(Tunnel tunnel);

        /**
         * <p>
         * The tunnel being described.
         * </p>
         * This is a convenience method that creates an instance of the {@link Tunnel.Builder} avoiding the need to
         * create one manually via {@link Tunnel#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tunnel.Builder#build()} is called immediately and its result is
         * passed to {@link #tunnel(Tunnel)}.
         * 
         * @param tunnel
         *        a consumer that will call methods on {@link Tunnel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunnel(Tunnel)
         */
        default Builder tunnel(Consumer<Tunnel.Builder> tunnel) {
            return tunnel(Tunnel.builder().applyMutation(tunnel).build());
        }
    }

    static final class BuilderImpl extends IoTSecureTunnelingResponse.BuilderImpl implements Builder {
        private Tunnel tunnel;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTunnelResponse model) {
            super(model);
            tunnel(model.tunnel);
        }

        public final Tunnel.Builder getTunnel() {
            return tunnel != null ? tunnel.toBuilder() : null;
        }

        public final void setTunnel(Tunnel.BuilderImpl tunnel) {
            this.tunnel = tunnel != null ? tunnel.build() : null;
        }

        @Override
        public final Builder tunnel(Tunnel tunnel) {
            this.tunnel = tunnel;
            return this;
        }

        @Override
        public DescribeTunnelResponse build() {
            return new DescribeTunnelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
