/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenTunnelResponse extends IoTSecureTunnelingResponse implements
        ToCopyableBuilder<OpenTunnelResponse.Builder, OpenTunnelResponse> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tunnelId").getter(getter(OpenTunnelResponse::tunnelId)).setter(setter(Builder::tunnelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()).build();

    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tunnelArn").getter(getter(OpenTunnelResponse::tunnelArn)).setter(setter(Builder::tunnelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()).build();

    private static final SdkField<String> SOURCE_ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccessToken").getter(getter(OpenTunnelResponse::sourceAccessToken))
            .setter(setter(Builder::sourceAccessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccessToken").build()).build();

    private static final SdkField<String> DESTINATION_ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationAccessToken").getter(getter(OpenTunnelResponse::destinationAccessToken))
            .setter(setter(Builder::destinationAccessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccessToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD,
            TUNNEL_ARN_FIELD, SOURCE_ACCESS_TOKEN_FIELD, DESTINATION_ACCESS_TOKEN_FIELD));

    private final String tunnelId;

    private final String tunnelArn;

    private final String sourceAccessToken;

    private final String destinationAccessToken;

    private OpenTunnelResponse(BuilderImpl builder) {
        super(builder);
        this.tunnelId = builder.tunnelId;
        this.tunnelArn = builder.tunnelArn;
        this.sourceAccessToken = builder.sourceAccessToken;
        this.destinationAccessToken = builder.destinationAccessToken;
    }

    /**
     * <p>
     * A unique alpha-numeric tunnel ID.
     * </p>
     * 
     * @return A unique alpha-numeric tunnel ID.
     */
    public final String tunnelId() {
        return tunnelId;
    }

    /**
     * <p>
     * The Amazon Resource Name for the tunnel. The tunnel ARN format is
     * <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
     * </p>
     * 
     * @return The Amazon Resource Name for the tunnel. The tunnel ARN format is
     *         <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
     */
    public final String tunnelArn() {
        return tunnelArn;
    }

    /**
     * <p>
     * The access token the source local proxy uses to connect to AWS IoT Secure Tunneling.
     * </p>
     * 
     * @return The access token the source local proxy uses to connect to AWS IoT Secure Tunneling.
     */
    public final String sourceAccessToken() {
        return sourceAccessToken;
    }

    /**
     * <p>
     * The access token the destination local proxy uses to connect to AWS IoT Secure Tunneling.
     * </p>
     * 
     * @return The access token the destination local proxy uses to connect to AWS IoT Secure Tunneling.
     */
    public final String destinationAccessToken() {
        return destinationAccessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccessToken());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAccessToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenTunnelResponse)) {
            return false;
        }
        OpenTunnelResponse other = (OpenTunnelResponse) obj;
        return Objects.equals(tunnelId(), other.tunnelId()) && Objects.equals(tunnelArn(), other.tunnelArn())
                && Objects.equals(sourceAccessToken(), other.sourceAccessToken())
                && Objects.equals(destinationAccessToken(), other.destinationAccessToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenTunnelResponse").add("TunnelId", tunnelId()).add("TunnelArn", tunnelArn())
                .add("SourceAccessToken", sourceAccessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DestinationAccessToken", destinationAccessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnelId":
            return Optional.ofNullable(clazz.cast(tunnelId()));
        case "tunnelArn":
            return Optional.ofNullable(clazz.cast(tunnelArn()));
        case "sourceAccessToken":
            return Optional.ofNullable(clazz.cast(sourceAccessToken()));
        case "destinationAccessToken":
            return Optional.ofNullable(clazz.cast(destinationAccessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenTunnelResponse, T> g) {
        return obj -> g.apply((OpenTunnelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSecureTunnelingResponse.Builder, SdkPojo, CopyableBuilder<Builder, OpenTunnelResponse> {
        /**
         * <p>
         * A unique alpha-numeric tunnel ID.
         * </p>
         * 
         * @param tunnelId
         *        A unique alpha-numeric tunnel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelId(String tunnelId);

        /**
         * <p>
         * The Amazon Resource Name for the tunnel. The tunnel ARN format is
         * <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
         * </p>
         * 
         * @param tunnelArn
         *        The Amazon Resource Name for the tunnel. The tunnel ARN format is
         *        <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelArn(String tunnelArn);

        /**
         * <p>
         * The access token the source local proxy uses to connect to AWS IoT Secure Tunneling.
         * </p>
         * 
         * @param sourceAccessToken
         *        The access token the source local proxy uses to connect to AWS IoT Secure Tunneling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessToken(String sourceAccessToken);

        /**
         * <p>
         * The access token the destination local proxy uses to connect to AWS IoT Secure Tunneling.
         * </p>
         * 
         * @param destinationAccessToken
         *        The access token the destination local proxy uses to connect to AWS IoT Secure Tunneling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAccessToken(String destinationAccessToken);
    }

    static final class BuilderImpl extends IoTSecureTunnelingResponse.BuilderImpl implements Builder {
        private String tunnelId;

        private String tunnelArn;

        private String sourceAccessToken;

        private String destinationAccessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenTunnelResponse model) {
            super(model);
            tunnelId(model.tunnelId);
            tunnelArn(model.tunnelArn);
            sourceAccessToken(model.sourceAccessToken);
            destinationAccessToken(model.destinationAccessToken);
        }

        public final String getTunnelId() {
            return tunnelId;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final String getTunnelArn() {
            return tunnelArn;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        @Override
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final String getSourceAccessToken() {
            return sourceAccessToken;
        }

        public final void setSourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
        }

        @Override
        public final Builder sourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
            return this;
        }

        public final String getDestinationAccessToken() {
            return destinationAccessToken;
        }

        public final void setDestinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
        }

        @Override
        public final Builder destinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
            return this;
        }

        @Override
        public OpenTunnelResponse build() {
            return new OpenTunnelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
