/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenTunnelRequest extends IoTSecureTunnelingRequest implements
        ToCopyableBuilder<OpenTunnelRequest.Builder, OpenTunnelRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(OpenTunnelRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(OpenTunnelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("destinationConfig")
            .getter(getter(OpenTunnelRequest::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfig").build()).build();

    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<TimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(OpenTunnelRequest::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(TimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, TAGS_FIELD,
            DESTINATION_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD));

    private final String description;

    private final List<Tag> tags;

    private final DestinationConfig destinationConfig;

    private final TimeoutConfig timeoutConfig;

    private OpenTunnelRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.tags = builder.tags;
        this.destinationConfig = builder.destinationConfig;
        this.timeoutConfig = builder.timeoutConfig;
    }

    /**
     * <p>
     * A short text description of the tunnel.
     * </p>
     * 
     * @return A short text description of the tunnel.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of tag metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of tag metadata.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The destination configuration for the OpenTunnel request.
     * </p>
     * 
     * @return The destination configuration for the OpenTunnel request.
     */
    public final DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    /**
     * <p>
     * Timeout configuration for a tunnel.
     * </p>
     * 
     * @return Timeout configuration for a tunnel.
     */
    public final TimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenTunnelRequest)) {
            return false;
        }
        OpenTunnelRequest other = (OpenTunnelRequest) obj;
        return Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(destinationConfig(), other.destinationConfig())
                && Objects.equals(timeoutConfig(), other.timeoutConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenTunnelRequest").add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("DestinationConfig", destinationConfig()).add("TimeoutConfig", timeoutConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "destinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenTunnelRequest, T> g) {
        return obj -> g.apply((OpenTunnelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSecureTunnelingRequest.Builder, SdkPojo, CopyableBuilder<Builder, OpenTunnelRequest> {
        /**
         * <p>
         * A short text description of the tunnel.
         * </p>
         * 
         * @param description
         *        A short text description of the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A collection of tag metadata.
         * </p>
         * 
         * @param tags
         *        A collection of tag metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A collection of tag metadata.
         * </p>
         * 
         * @param tags
         *        A collection of tag metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A collection of tag metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsecuretunneling.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotsecuretunneling.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsecuretunneling.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsecuretunneling.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The destination configuration for the OpenTunnel request.
         * </p>
         * 
         * @param destinationConfig
         *        The destination configuration for the OpenTunnel request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * The destination configuration for the OpenTunnel request.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfig.Builder} avoiding the
         * need to create one manually via {@link DestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        /**
         * <p>
         * Timeout configuration for a tunnel.
         * </p>
         * 
         * @param timeoutConfig
         *        Timeout configuration for a tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(TimeoutConfig timeoutConfig);

        /**
         * <p>
         * Timeout configuration for a tunnel.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeoutConfig.Builder} avoiding the need
         * to create one manually via {@link TimeoutConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeoutConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(TimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link TimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(TimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(TimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSecureTunnelingRequest.BuilderImpl implements Builder {
        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private DestinationConfig destinationConfig;

        private TimeoutConfig timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenTunnelRequest model) {
            super(model);
            description(model.description);
            tags(model.tags);
            destinationConfig(model.destinationConfig);
            timeoutConfig(model.timeoutConfig);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OpenTunnelRequest build() {
            return new OpenTunnelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
