/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotateTunnelAccessTokenRequest extends IoTSecureTunnelingRequest implements
        ToCopyableBuilder<RotateTunnelAccessTokenRequest.Builder, RotateTunnelAccessTokenRequest> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tunnelId").getter(getter(RotateTunnelAccessTokenRequest::tunnelId)).setter(setter(Builder::tunnelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()).build();

    private static final SdkField<String> CLIENT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientMode").getter(getter(RotateTunnelAccessTokenRequest::clientModeAsString))
            .setter(setter(Builder::clientMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientMode").build()).build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("destinationConfig")
            .getter(getter(RotateTunnelAccessTokenRequest::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD,
            CLIENT_MODE_FIELD, DESTINATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tunnelId;

    private final String clientMode;

    private final DestinationConfig destinationConfig;

    private RotateTunnelAccessTokenRequest(BuilderImpl builder) {
        super(builder);
        this.tunnelId = builder.tunnelId;
        this.clientMode = builder.clientMode;
        this.destinationConfig = builder.destinationConfig;
    }

    /**
     * <p>
     * The tunnel for which you want to rotate the access tokens.
     * </p>
     * 
     * @return The tunnel for which you want to rotate the access tokens.
     */
    public final String tunnelId() {
        return tunnelId;
    }

    /**
     * <p>
     * The mode of the client that will use the client token, which can be either the source or destination, or both
     * source and destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientMode} will
     * return {@link ClientMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientModeAsString}.
     * </p>
     * 
     * @return The mode of the client that will use the client token, which can be either the source or destination, or
     *         both source and destination.
     * @see ClientMode
     */
    public final ClientMode clientMode() {
        return ClientMode.fromValue(clientMode);
    }

    /**
     * <p>
     * The mode of the client that will use the client token, which can be either the source or destination, or both
     * source and destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientMode} will
     * return {@link ClientMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientModeAsString}.
     * </p>
     * 
     * @return The mode of the client that will use the client token, which can be either the source or destination, or
     *         both source and destination.
     * @see ClientMode
     */
    public final String clientModeAsString() {
        return clientMode;
    }

    /**
     * Returns the value of the DestinationConfig property for this object.
     * 
     * @return The value of the DestinationConfig property for this object.
     */
    public final DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(clientModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateTunnelAccessTokenRequest)) {
            return false;
        }
        RotateTunnelAccessTokenRequest other = (RotateTunnelAccessTokenRequest) obj;
        return Objects.equals(tunnelId(), other.tunnelId()) && Objects.equals(clientModeAsString(), other.clientModeAsString())
                && Objects.equals(destinationConfig(), other.destinationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RotateTunnelAccessTokenRequest").add("TunnelId", tunnelId())
                .add("ClientMode", clientModeAsString()).add("DestinationConfig", destinationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnelId":
            return Optional.ofNullable(clazz.cast(tunnelId()));
        case "clientMode":
            return Optional.ofNullable(clazz.cast(clientModeAsString()));
        case "destinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tunnelId", TUNNEL_ID_FIELD);
        map.put("clientMode", CLIENT_MODE_FIELD);
        map.put("destinationConfig", DESTINATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotateTunnelAccessTokenRequest, T> g) {
        return obj -> g.apply((RotateTunnelAccessTokenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSecureTunnelingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RotateTunnelAccessTokenRequest> {
        /**
         * <p>
         * The tunnel for which you want to rotate the access tokens.
         * </p>
         * 
         * @param tunnelId
         *        The tunnel for which you want to rotate the access tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelId(String tunnelId);

        /**
         * <p>
         * The mode of the client that will use the client token, which can be either the source or destination, or both
         * source and destination.
         * </p>
         * 
         * @param clientMode
         *        The mode of the client that will use the client token, which can be either the source or destination,
         *        or both source and destination.
         * @see ClientMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientMode
         */
        Builder clientMode(String clientMode);

        /**
         * <p>
         * The mode of the client that will use the client token, which can be either the source or destination, or both
         * source and destination.
         * </p>
         * 
         * @param clientMode
         *        The mode of the client that will use the client token, which can be either the source or destination,
         *        or both source and destination.
         * @see ClientMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientMode
         */
        Builder clientMode(ClientMode clientMode);

        /**
         * Sets the value of the DestinationConfig property for this object.
         *
         * @param destinationConfig
         *        The new value for the DestinationConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * Sets the value of the DestinationConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DestinationConfig.Builder} avoiding the
         * need to create one manually via {@link DestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSecureTunnelingRequest.BuilderImpl implements Builder {
        private String tunnelId;

        private String clientMode;

        private DestinationConfig destinationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateTunnelAccessTokenRequest model) {
            super(model);
            tunnelId(model.tunnelId);
            clientMode(model.clientMode);
            destinationConfig(model.destinationConfig);
        }

        public final String getTunnelId() {
            return tunnelId;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final String getClientMode() {
            return clientMode;
        }

        public final void setClientMode(String clientMode) {
            this.clientMode = clientMode;
        }

        @Override
        public final Builder clientMode(String clientMode) {
            this.clientMode = clientMode;
            return this;
        }

        @Override
        public final Builder clientMode(ClientMode clientMode) {
            this.clientMode(clientMode == null ? null : clientMode.toString());
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RotateTunnelAccessTokenRequest build() {
            return new RotateTunnelAccessTokenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
