/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RotateTunnelAccessTokenResponse extends IoTSecureTunnelingResponse implements
        ToCopyableBuilder<RotateTunnelAccessTokenResponse.Builder, RotateTunnelAccessTokenResponse> {
    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tunnelArn").getter(getter(RotateTunnelAccessTokenResponse::tunnelArn))
            .setter(setter(Builder::tunnelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()).build();

    private static final SdkField<String> SOURCE_ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccessToken").getter(getter(RotateTunnelAccessTokenResponse::sourceAccessToken))
            .setter(setter(Builder::sourceAccessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccessToken").build()).build();

    private static final SdkField<String> DESTINATION_ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationAccessToken").getter(getter(RotateTunnelAccessTokenResponse::destinationAccessToken))
            .setter(setter(Builder::destinationAccessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccessToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ARN_FIELD,
            SOURCE_ACCESS_TOKEN_FIELD, DESTINATION_ACCESS_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tunnelArn;

    private final String sourceAccessToken;

    private final String destinationAccessToken;

    private RotateTunnelAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.tunnelArn = builder.tunnelArn;
        this.sourceAccessToken = builder.sourceAccessToken;
        this.destinationAccessToken = builder.destinationAccessToken;
    }

    /**
     * <p>
     * The Amazon Resource Name for the tunnel.
     * </p>
     * 
     * @return The Amazon Resource Name for the tunnel.
     */
    public final String tunnelArn() {
        return tunnelArn;
    }

    /**
     * <p>
     * The client access token that the source local proxy uses to connect to IoT Secure Tunneling.
     * </p>
     * 
     * @return The client access token that the source local proxy uses to connect to IoT Secure Tunneling.
     */
    public final String sourceAccessToken() {
        return sourceAccessToken;
    }

    /**
     * <p>
     * The client access token that the destination local proxy uses to connect to IoT Secure Tunneling.
     * </p>
     * 
     * @return The client access token that the destination local proxy uses to connect to IoT Secure Tunneling.
     */
    public final String destinationAccessToken() {
        return destinationAccessToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccessToken());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAccessToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateTunnelAccessTokenResponse)) {
            return false;
        }
        RotateTunnelAccessTokenResponse other = (RotateTunnelAccessTokenResponse) obj;
        return Objects.equals(tunnelArn(), other.tunnelArn()) && Objects.equals(sourceAccessToken(), other.sourceAccessToken())
                && Objects.equals(destinationAccessToken(), other.destinationAccessToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RotateTunnelAccessTokenResponse").add("TunnelArn", tunnelArn())
                .add("SourceAccessToken", sourceAccessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DestinationAccessToken", destinationAccessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnelArn":
            return Optional.ofNullable(clazz.cast(tunnelArn()));
        case "sourceAccessToken":
            return Optional.ofNullable(clazz.cast(sourceAccessToken()));
        case "destinationAccessToken":
            return Optional.ofNullable(clazz.cast(destinationAccessToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tunnelArn", TUNNEL_ARN_FIELD);
        map.put("sourceAccessToken", SOURCE_ACCESS_TOKEN_FIELD);
        map.put("destinationAccessToken", DESTINATION_ACCESS_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotateTunnelAccessTokenResponse, T> g) {
        return obj -> g.apply((RotateTunnelAccessTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTSecureTunnelingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RotateTunnelAccessTokenResponse> {
        /**
         * <p>
         * The Amazon Resource Name for the tunnel.
         * </p>
         * 
         * @param tunnelArn
         *        The Amazon Resource Name for the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelArn(String tunnelArn);

        /**
         * <p>
         * The client access token that the source local proxy uses to connect to IoT Secure Tunneling.
         * </p>
         * 
         * @param sourceAccessToken
         *        The client access token that the source local proxy uses to connect to IoT Secure Tunneling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessToken(String sourceAccessToken);

        /**
         * <p>
         * The client access token that the destination local proxy uses to connect to IoT Secure Tunneling.
         * </p>
         * 
         * @param destinationAccessToken
         *        The client access token that the destination local proxy uses to connect to IoT Secure Tunneling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAccessToken(String destinationAccessToken);
    }

    static final class BuilderImpl extends IoTSecureTunnelingResponse.BuilderImpl implements Builder {
        private String tunnelArn;

        private String sourceAccessToken;

        private String destinationAccessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateTunnelAccessTokenResponse model) {
            super(model);
            tunnelArn(model.tunnelArn);
            sourceAccessToken(model.sourceAccessToken);
            destinationAccessToken(model.destinationAccessToken);
        }

        public final String getTunnelArn() {
            return tunnelArn;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        @Override
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final String getSourceAccessToken() {
            return sourceAccessToken;
        }

        public final void setSourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
        }

        @Override
        public final Builder sourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
            return this;
        }

        public final String getDestinationAccessToken() {
            return destinationAccessToken;
        }

        public final void setDestinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
        }

        @Override
        public final Builder destinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
            return this;
        }

        @Override
        public RotateTunnelAccessTokenResponse build() {
            return new RotateTunnelAccessTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
