/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAccessPolicyRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, DeleteAccessPolicyRequest> {
    private static final SdkField<String> ACCESS_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteAccessPolicyRequest.getter(DeleteAccessPolicyRequest::accessPolicyId)).setter(DeleteAccessPolicyRequest.setter(Builder::accessPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accessPolicyId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteAccessPolicyRequest.getter(DeleteAccessPolicyRequest::clientToken)).setter(DeleteAccessPolicyRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_ID_FIELD, CLIENT_TOKEN_FIELD));
    private final String accessPolicyId;
    private final String clientToken;

    private DeleteAccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.accessPolicyId = builder.accessPolicyId;
        this.clientToken = builder.clientToken;
    }

    public String accessPolicyId() {
        return this.accessPolicyId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccessPolicyRequest)) {
            return false;
        }
        DeleteAccessPolicyRequest other = (DeleteAccessPolicyRequest)((Object)obj);
        return Objects.equals(this.accessPolicyId(), other.accessPolicyId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAccessPolicyRequest").add("AccessPolicyId", (Object)this.accessPolicyId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessPolicyId": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccessPolicyRequest, T> g) {
        return obj -> g.apply((DeleteAccessPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String accessPolicyId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccessPolicyRequest model) {
            super(model);
            this.accessPolicyId(model.accessPolicyId);
            this.clientToken(model.clientToken);
        }

        public final String getAccessPolicyId() {
            return this.accessPolicyId;
        }

        @Override
        public final Builder accessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        public final void setAccessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccessPolicyRequest build() {
            return new DeleteAccessPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAccessPolicyRequest> {
        public Builder accessPolicyId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

