/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDashboardResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, CreateDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDashboardResponse.getter(CreateDashboardResponse::dashboardId)).setter(CreateDashboardResponse.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardId").build()}).build();
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDashboardResponse.getter(CreateDashboardResponse::dashboardArn)).setter(CreateDashboardResponse.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD, DASHBOARD_ARN_FIELD));
    private final String dashboardId;
    private final String dashboardArn;

    private CreateDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.dashboardArn = builder.dashboardArn;
    }

    public String dashboardId() {
        return this.dashboardId;
    }

    public String dashboardArn() {
        return this.dashboardArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardResponse)) {
            return false;
        }
        CreateDashboardResponse other = (CreateDashboardResponse)((Object)obj);
        return Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.dashboardArn(), other.dashboardArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateDashboardResponse").add("DashboardId", (Object)this.dashboardId()).add("DashboardArn", (Object)this.dashboardArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "dashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardResponse, T> g) {
        return obj -> g.apply((CreateDashboardResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String dashboardId;
        private String dashboardArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardResponse model) {
            super(model);
            this.dashboardId(model.dashboardId);
            this.dashboardArn(model.dashboardArn);
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public CreateDashboardResponse build() {
            return new CreateDashboardResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDashboardResponse> {
        public Builder dashboardId(String var1);

        public Builder dashboardArn(String var1);
    }
}

