/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.GroupIdentity;
import software.amazon.awssdk.services.iotsitewise.model.UserIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Identity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Identity> {
    private static final SdkField<UserIdentity> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Identity.getter(Identity::user)).setter(Identity.setter(Builder::user)).constructor(UserIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<GroupIdentity> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Identity.getter(Identity::group)).setter(Identity.setter(Builder::group)).constructor(GroupIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final UserIdentity user;
    private final GroupIdentity group;

    private Identity(BuilderImpl builder) {
        this.user = builder.user;
        this.group = builder.group;
    }

    public UserIdentity user() {
        return this.user;
    }

    public GroupIdentity group() {
        return this.group;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)obj;
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.group(), other.group());
    }

    public String toString() {
        return ToString.builder((String)"Identity").add("User", (Object)this.user()).add("Group", (Object)this.group()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Identity, T> g) {
        return obj -> g.apply((Identity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UserIdentity user;
        private GroupIdentity group;

        private BuilderImpl() {
        }

        private BuilderImpl(Identity model) {
            this.user(model.user);
            this.group(model.group);
        }

        public final UserIdentity.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        @Override
        public final Builder user(UserIdentity user) {
            this.user = user;
            return this;
        }

        public final void setUser(UserIdentity.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        public final GroupIdentity.Builder getGroup() {
            return this.group != null ? this.group.toBuilder() : null;
        }

        @Override
        public final Builder group(GroupIdentity group) {
            this.group = group;
            return this;
        }

        public final void setGroup(GroupIdentity.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        public Identity build() {
            return new Identity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Identity> {
        public Builder user(UserIdentity var1);

        default public Builder user(Consumer<UserIdentity.Builder> user) {
            return this.user((UserIdentity)((UserIdentity.Builder)UserIdentity.builder().applyMutation(user)).build());
        }

        public Builder group(GroupIdentity var1);

        default public Builder group(Consumer<GroupIdentity.Builder> group) {
            return this.group((GroupIdentity)((GroupIdentity.Builder)GroupIdentity.builder().applyMutation(group)).build());
        }
    }
}

