/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProjectsResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<ListProjectsResponse.Builder, ListProjectsResponse> {
    private static final SdkField<List<ProjectSummary>> PROJECT_SUMMARIES_FIELD = SdkField
            .<List<ProjectSummary>> builder(MarshallingType.LIST)
            .memberName("projectSummaries")
            .getter(getter(ListProjectsResponse::projectSummaries))
            .setter(setter(Builder::projectSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListProjectsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProjectSummary> projectSummaries;

    private final String nextToken;

    private ListProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projectSummaries = builder.projectSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ProjectSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProjectSummaries() {
        return projectSummaries != null && !(projectSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that summarizes each project in the portal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProjectSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that summarizes each project in the portal.
     */
    public final List<ProjectSummary> projectSummaries() {
        return projectSummaries;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectSummaries() ? projectSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse) obj;
        return hasProjectSummaries() == other.hasProjectSummaries()
                && Objects.equals(projectSummaries(), other.projectSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProjectsResponse")
                .add("ProjectSummaries", hasProjectSummaries() ? projectSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectSummaries":
            return Optional.ofNullable(clazz.cast(projectSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectsResponse, T> g) {
        return obj -> g.apply((ListProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProjectsResponse> {
        /**
         * <p>
         * A list that summarizes each project in the portal.
         * </p>
         * 
         * @param projectSummaries
         *        A list that summarizes each project in the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectSummaries(Collection<ProjectSummary> projectSummaries);

        /**
         * <p>
         * A list that summarizes each project in the portal.
         * </p>
         * 
         * @param projectSummaries
         *        A list that summarizes each project in the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectSummaries(ProjectSummary... projectSummaries);

        /**
         * <p>
         * A list that summarizes each project in the portal.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProjectSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ProjectSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProjectSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #projectSummaries(List<ProjectSummary>)}.
         * 
         * @param projectSummaries
         *        a consumer that will call methods on {@link List<ProjectSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectSummaries(List<ProjectSummary>)
         */
        Builder projectSummaries(Consumer<ProjectSummary.Builder>... projectSummaries);

        /**
         * <p>
         * The token for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<ProjectSummary> projectSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            super(model);
            projectSummaries(model.projectSummaries);
            nextToken(model.nextToken);
        }

        public final List<ProjectSummary.Builder> getProjectSummaries() {
            List<ProjectSummary.Builder> result = ProjectSummariesCopier.copyToBuilder(this.projectSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder projectSummaries(Collection<ProjectSummary> projectSummaries) {
            this.projectSummaries = ProjectSummariesCopier.copy(projectSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectSummaries(ProjectSummary... projectSummaries) {
            projectSummaries(Arrays.asList(projectSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectSummaries(Consumer<ProjectSummary.Builder>... projectSummaries) {
            projectSummaries(Stream.of(projectSummaries).map(c -> ProjectSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProjectSummaries(Collection<ProjectSummary.BuilderImpl> projectSummaries) {
            this.projectSummaries = ProjectSummariesCopier.copyFromBuilder(projectSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
