/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a composite model definition in an asset model. This composite model definition is applied to all assets
 * created from the asset model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetModelCompositeModelDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetModelCompositeModelDefinition.Builder, AssetModelCompositeModelDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetModelCompositeModelDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssetModelCompositeModelDefinition::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AssetModelCompositeModelDefinition::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<AssetModelPropertyDefinition>> PROPERTIES_FIELD = SdkField
            .<List<AssetModelPropertyDefinition>> builder(MarshallingType.LIST)
            .memberName("properties")
            .getter(getter(AssetModelCompositeModelDefinition::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelPropertyDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelPropertyDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TYPE_FIELD, PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String type;

    private final List<AssetModelPropertyDefinition> properties;

    private AssetModelCompositeModelDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The name of the composite model.
     * </p>
     * 
     * @return The name of the composite model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the composite model.
     * </p>
     * 
     * @return The description of the composite model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
     * </p>
     * 
     * @return The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * Returns true if the Properties property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The asset property definitions for this composite model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The asset property definitions for this composite model.
     */
    public final List<AssetModelPropertyDefinition> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetModelCompositeModelDefinition)) {
            return false;
        }
        AssetModelCompositeModelDefinition other = (AssetModelCompositeModelDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(type(), other.type()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetModelCompositeModelDefinition").add("Name", name()).add("Description", description())
                .add("Type", type()).add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetModelCompositeModelDefinition, T> g) {
        return obj -> g.apply((AssetModelCompositeModelDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetModelCompositeModelDefinition> {
        /**
         * <p>
         * The name of the composite model.
         * </p>
         * 
         * @param name
         *        The name of the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the composite model.
         * </p>
         * 
         * @param description
         *        The description of the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
         * </p>
         * 
         * @param type
         *        The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The asset property definitions for this composite model.
         * </p>
         * 
         * @param properties
         *        The asset property definitions for this composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<AssetModelPropertyDefinition> properties);

        /**
         * <p>
         * The asset property definitions for this composite model.
         * </p>
         * 
         * @param properties
         *        The asset property definitions for this composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(AssetModelPropertyDefinition... properties);

        /**
         * <p>
         * The asset property definitions for this composite model.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetModelPropertyDefinition>.Builder}
         * avoiding the need to create one manually via {@link List<AssetModelPropertyDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetModelPropertyDefinition>.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(List<AssetModelPropertyDefinition>)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link List<AssetModelPropertyDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(List<AssetModelPropertyDefinition>)
         */
        Builder properties(Consumer<AssetModelPropertyDefinition.Builder>... properties);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String type;

        private List<AssetModelPropertyDefinition> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetModelCompositeModelDefinition model) {
            name(model.name);
            description(model.description);
            type(model.type);
            properties(model.properties);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final List<AssetModelPropertyDefinition.Builder> getProperties() {
            List<AssetModelPropertyDefinition.Builder> result = AssetModelPropertyDefinitionsCopier
                    .copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder properties(Collection<AssetModelPropertyDefinition> properties) {
            this.properties = AssetModelPropertyDefinitionsCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(AssetModelPropertyDefinition... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<AssetModelPropertyDefinition.Builder>... properties) {
            properties(Stream.of(properties).map(c -> AssetModelPropertyDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProperties(Collection<AssetModelPropertyDefinition.BuilderImpl> properties) {
            this.properties = AssetModelPropertyDefinitionsCopier.copyFromBuilder(properties);
        }

        @Override
        public AssetModelCompositeModelDefinition build() {
            return new AssetModelCompositeModelDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
