/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessPolicyRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateAccessPolicyRequest.Builder, UpdateAccessPolicyRequest> {
    private static final SdkField<String> ACCESS_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyId").getter(getter(UpdateAccessPolicyRequest::accessPolicyId))
            .setter(setter(Builder::accessPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accessPolicyId").build()).build();

    private static final SdkField<Identity> ACCESS_POLICY_IDENTITY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("accessPolicyIdentity").getter(getter(UpdateAccessPolicyRequest::accessPolicyIdentity))
            .setter(setter(Builder::accessPolicyIdentity)).constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyIdentity").build())
            .build();

    private static final SdkField<Resource> ACCESS_POLICY_RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("accessPolicyResource").getter(getter(UpdateAccessPolicyRequest::accessPolicyResource))
            .setter(setter(Builder::accessPolicyResource)).constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyResource").build())
            .build();

    private static final SdkField<String> ACCESS_POLICY_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyPermission").getter(getter(UpdateAccessPolicyRequest::accessPolicyPermissionAsString))
            .setter(setter(Builder::accessPolicyPermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyPermission").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAccessPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_ID_FIELD,
            ACCESS_POLICY_IDENTITY_FIELD, ACCESS_POLICY_RESOURCE_FIELD, ACCESS_POLICY_PERMISSION_FIELD, CLIENT_TOKEN_FIELD));

    private final String accessPolicyId;

    private final Identity accessPolicyIdentity;

    private final Resource accessPolicyResource;

    private final String accessPolicyPermission;

    private final String clientToken;

    private UpdateAccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.accessPolicyId = builder.accessPolicyId;
        this.accessPolicyIdentity = builder.accessPolicyIdentity;
        this.accessPolicyResource = builder.accessPolicyResource;
        this.accessPolicyPermission = builder.accessPolicyPermission;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the access policy.
     * </p>
     * 
     * @return The ID of the access policy.
     */
    public final String accessPolicyId() {
        return accessPolicyId;
    }

    /**
     * <p>
     * The identity for this access policy. Choose an AWS SSO user, an AWS SSO group, or an IAM user.
     * </p>
     * 
     * @return The identity for this access policy. Choose an AWS SSO user, an AWS SSO group, or an IAM user.
     */
    public final Identity accessPolicyIdentity() {
        return accessPolicyIdentity;
    }

    /**
     * <p>
     * The AWS IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
     * </p>
     * 
     * @return The AWS IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
     */
    public final Resource accessPolicyResource() {
        return accessPolicyResource;
    }

    /**
     * <p>
     * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
     * project owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessPolicyPermission} will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #accessPolicyPermissionAsString}.
     * </p>
     * 
     * @return The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known
     *         as a project owner.
     * @see Permission
     */
    public final Permission accessPolicyPermission() {
        return Permission.fromValue(accessPolicyPermission);
    }

    /**
     * <p>
     * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
     * project owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessPolicyPermission} will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #accessPolicyPermissionAsString}.
     * </p>
     * 
     * @return The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known
     *         as a project owner.
     * @see Permission
     */
    public final String accessPolicyPermissionAsString() {
        return accessPolicyPermission;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyResource());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyPermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessPolicyRequest)) {
            return false;
        }
        UpdateAccessPolicyRequest other = (UpdateAccessPolicyRequest) obj;
        return Objects.equals(accessPolicyId(), other.accessPolicyId())
                && Objects.equals(accessPolicyIdentity(), other.accessPolicyIdentity())
                && Objects.equals(accessPolicyResource(), other.accessPolicyResource())
                && Objects.equals(accessPolicyPermissionAsString(), other.accessPolicyPermissionAsString())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccessPolicyRequest").add("AccessPolicyId", accessPolicyId())
                .add("AccessPolicyIdentity", accessPolicyIdentity()).add("AccessPolicyResource", accessPolicyResource())
                .add("AccessPolicyPermission", accessPolicyPermissionAsString()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPolicyId":
            return Optional.ofNullable(clazz.cast(accessPolicyId()));
        case "accessPolicyIdentity":
            return Optional.ofNullable(clazz.cast(accessPolicyIdentity()));
        case "accessPolicyResource":
            return Optional.ofNullable(clazz.cast(accessPolicyResource()));
        case "accessPolicyPermission":
            return Optional.ofNullable(clazz.cast(accessPolicyPermissionAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessPolicyRequest, T> g) {
        return obj -> g.apply((UpdateAccessPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAccessPolicyRequest> {
        /**
         * <p>
         * The ID of the access policy.
         * </p>
         * 
         * @param accessPolicyId
         *        The ID of the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyId(String accessPolicyId);

        /**
         * <p>
         * The identity for this access policy. Choose an AWS SSO user, an AWS SSO group, or an IAM user.
         * </p>
         * 
         * @param accessPolicyIdentity
         *        The identity for this access policy. Choose an AWS SSO user, an AWS SSO group, or an IAM user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyIdentity(Identity accessPolicyIdentity);

        /**
         * <p>
         * The identity for this access policy. Choose an AWS SSO user, an AWS SSO group, or an IAM user.
         * </p>
         * This is a convenience that creates an instance of the {@link Identity.Builder} avoiding the need to create
         * one manually via {@link Identity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #accessPolicyIdentity(Identity)}.
         * 
         * @param accessPolicyIdentity
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyIdentity(Identity)
         */
        default Builder accessPolicyIdentity(Consumer<Identity.Builder> accessPolicyIdentity) {
            return accessPolicyIdentity(Identity.builder().applyMutation(accessPolicyIdentity).build());
        }

        /**
         * <p>
         * The AWS IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         * </p>
         * 
         * @param accessPolicyResource
         *        The AWS IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyResource(Resource accessPolicyResource);

        /**
         * <p>
         * The AWS IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         * </p>
         * This is a convenience that creates an instance of the {@link Resource.Builder} avoiding the need to create
         * one manually via {@link Resource#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #accessPolicyResource(Resource)}.
         * 
         * @param accessPolicyResource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyResource(Resource)
         */
        default Builder accessPolicyResource(Consumer<Resource.Builder> accessPolicyResource) {
            return accessPolicyResource(Resource.builder().applyMutation(accessPolicyResource).build());
        }

        /**
         * <p>
         * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as
         * a project owner.
         * </p>
         * 
         * @param accessPolicyPermission
         *        The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also
         *        known as a project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder accessPolicyPermission(String accessPolicyPermission);

        /**
         * <p>
         * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as
         * a project owner.
         * </p>
         * 
         * @param accessPolicyPermission
         *        The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also
         *        known as a project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder accessPolicyPermission(Permission accessPolicyPermission);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String accessPolicyId;

        private Identity accessPolicyIdentity;

        private Resource accessPolicyResource;

        private String accessPolicyPermission;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessPolicyRequest model) {
            super(model);
            accessPolicyId(model.accessPolicyId);
            accessPolicyIdentity(model.accessPolicyIdentity);
            accessPolicyResource(model.accessPolicyResource);
            accessPolicyPermission(model.accessPolicyPermission);
            clientToken(model.clientToken);
        }

        public final String getAccessPolicyId() {
            return accessPolicyId;
        }

        @Override
        public final Builder accessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        public final void setAccessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
        }

        public final Identity.Builder getAccessPolicyIdentity() {
            return accessPolicyIdentity != null ? accessPolicyIdentity.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicyIdentity(Identity accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity;
            return this;
        }

        public final void setAccessPolicyIdentity(Identity.BuilderImpl accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity != null ? accessPolicyIdentity.build() : null;
        }

        public final Resource.Builder getAccessPolicyResource() {
            return accessPolicyResource != null ? accessPolicyResource.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicyResource(Resource accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource;
            return this;
        }

        public final void setAccessPolicyResource(Resource.BuilderImpl accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource != null ? accessPolicyResource.build() : null;
        }

        public final String getAccessPolicyPermission() {
            return accessPolicyPermission;
        }

        @Override
        public final Builder accessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
            return this;
        }

        @Override
        public final Builder accessPolicyPermission(Permission accessPolicyPermission) {
            this.accessPolicyPermission(accessPolicyPermission == null ? null : accessPolicyPermission.toString());
            return this;
        }

        public final void setAccessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessPolicyRequest build() {
            return new UpdateAccessPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
