/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a timestamp with optional nanosecond granularity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeInNanos implements SdkPojo, Serializable, ToCopyableBuilder<TimeInNanos.Builder, TimeInNanos> {
    private static final SdkField<Long> TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeInSeconds").getter(getter(TimeInNanos::timeInSeconds)).setter(setter(Builder::timeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeInSeconds").build()).build();

    private static final SdkField<Integer> OFFSET_IN_NANOS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("offsetInNanos").getter(getter(TimeInNanos::offsetInNanos)).setter(setter(Builder::offsetInNanos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offsetInNanos").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_IN_SECONDS_FIELD,
            OFFSET_IN_NANOS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timeInSeconds;

    private final Integer offsetInNanos;

    private TimeInNanos(BuilderImpl builder) {
        this.timeInSeconds = builder.timeInSeconds;
        this.offsetInNanos = builder.offsetInNanos;
    }

    /**
     * <p>
     * The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by
     * <code>offsetInNanos</code>.
     * </p>
     * 
     * @return The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by
     *         <code>offsetInNanos</code>.
     */
    public final Long timeInSeconds() {
        return timeInSeconds;
    }

    /**
     * <p>
     * The nanosecond offset from <code>timeInSeconds</code>.
     * </p>
     * 
     * @return The nanosecond offset from <code>timeInSeconds</code>.
     */
    public final Integer offsetInNanos() {
        return offsetInNanos;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(offsetInNanos());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeInNanos)) {
            return false;
        }
        TimeInNanos other = (TimeInNanos) obj;
        return Objects.equals(timeInSeconds(), other.timeInSeconds()) && Objects.equals(offsetInNanos(), other.offsetInNanos());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeInNanos").add("TimeInSeconds", timeInSeconds()).add("OffsetInNanos", offsetInNanos())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeInSeconds":
            return Optional.ofNullable(clazz.cast(timeInSeconds()));
        case "offsetInNanos":
            return Optional.ofNullable(clazz.cast(offsetInNanos()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeInNanos, T> g) {
        return obj -> g.apply((TimeInNanos) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeInNanos> {
        /**
         * <p>
         * The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by
         * <code>offsetInNanos</code>.
         * </p>
         * 
         * @param timeInSeconds
         *        The timestamp date, in seconds, in the Unix epoch format. Fractional nanosecond data is provided by
         *        <code>offsetInNanos</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeInSeconds(Long timeInSeconds);

        /**
         * <p>
         * The nanosecond offset from <code>timeInSeconds</code>.
         * </p>
         * 
         * @param offsetInNanos
         *        The nanosecond offset from <code>timeInSeconds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetInNanos(Integer offsetInNanos);
    }

    static final class BuilderImpl implements Builder {
        private Long timeInSeconds;

        private Integer offsetInNanos;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeInNanos model) {
            timeInSeconds(model.timeInSeconds);
            offsetInNanos(model.offsetInNanos);
        }

        public final Long getTimeInSeconds() {
            return timeInSeconds;
        }

        @Override
        public final Builder timeInSeconds(Long timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
            return this;
        }

        public final void setTimeInSeconds(Long timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
        }

        public final Integer getOffsetInNanos() {
            return offsetInNanos;
        }

        @Override
        public final Builder offsetInNanos(Integer offsetInNanos) {
            this.offsetInNanos = offsetInNanos;
            return this;
        }

        public final void setOffsetInNanos(Integer offsetInNanos) {
            this.offsetInNanos = offsetInNanos;
        }

        @Override
        public TimeInNanos build() {
            return new TimeInNanos(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
