/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the alarm
 * to monitor an asset property and get notified when the asset property value is outside a specified range. For more
 * information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring
 * with alarms</a> in the <i>IoT SiteWise Application Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Alarms implements SdkPojo, Serializable, ToCopyableBuilder<Alarms.Builder, Alarms> {
    private static final SdkField<String> ALARM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmRoleArn").getter(getter(Alarms::alarmRoleArn)).setter(setter(Builder::alarmRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRoleArn").build()).build();

    private static final SdkField<String> NOTIFICATION_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationLambdaArn").getter(getter(Alarms::notificationLambdaArn))
            .setter(setter(Builder::notificationLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationLambdaArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_ROLE_ARN_FIELD,
            NOTIFICATION_LAMBDA_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alarmRoleArn;

    private final String notificationLambdaArn;

    private Alarms(BuilderImpl builder) {
        this.alarmRoleArn = builder.alarmRoleArn;
        this.notificationLambdaArn = builder.notificationLambdaArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM role
     * that allows the alarm to perform actions and access Amazon Web Services resources and services, such as IoT
     * Events.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         IAM role that allows the alarm to perform actions and access Amazon Web Services resources and services,
     *         such as IoT Events.
     */
    public final String alarmRoleArn() {
        return alarmRoleArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Lambda
     * function that manages alarm notifications. For more information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm
     * notifications</a> in the <i>IoT Events Developer Guide</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         Lambda function that manages alarm notifications. For more information, see <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm
     *         notifications</a> in the <i>IoT Events Developer Guide</i>.
     */
    public final String notificationLambdaArn() {
        return notificationLambdaArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alarmRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(notificationLambdaArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarms)) {
            return false;
        }
        Alarms other = (Alarms) obj;
        return Objects.equals(alarmRoleArn(), other.alarmRoleArn())
                && Objects.equals(notificationLambdaArn(), other.notificationLambdaArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Alarms").add("AlarmRoleArn", alarmRoleArn())
                .add("NotificationLambdaArn", notificationLambdaArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmRoleArn":
            return Optional.ofNullable(clazz.cast(alarmRoleArn()));
        case "notificationLambdaArn":
            return Optional.ofNullable(clazz.cast(notificationLambdaArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alarms, T> g) {
        return obj -> g.apply((Alarms) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Alarms> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the IAM
         * role that allows the alarm to perform actions and access Amazon Web Services resources and services, such as
         * IoT Events.
         * </p>
         * 
         * @param alarmRoleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the IAM role that allows the alarm to perform actions and access Amazon Web Services resources and
         *        services, such as IoT Events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRoleArn(String alarmRoleArn);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * Lambda function that manages alarm notifications. For more information, see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm
         * notifications</a> in the <i>IoT Events Developer Guide</i>.
         * </p>
         * 
         * @param notificationLambdaArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the Lambda function that manages alarm notifications. For more information, see <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">Managing alarm
         *        notifications</a> in the <i>IoT Events Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationLambdaArn(String notificationLambdaArn);
    }

    static final class BuilderImpl implements Builder {
        private String alarmRoleArn;

        private String notificationLambdaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarms model) {
            alarmRoleArn(model.alarmRoleArn);
            notificationLambdaArn(model.notificationLambdaArn);
        }

        public final String getAlarmRoleArn() {
            return alarmRoleArn;
        }

        @Override
        public final Builder alarmRoleArn(String alarmRoleArn) {
            this.alarmRoleArn = alarmRoleArn;
            return this;
        }

        public final void setAlarmRoleArn(String alarmRoleArn) {
            this.alarmRoleArn = alarmRoleArn;
        }

        public final String getNotificationLambdaArn() {
            return notificationLambdaArn;
        }

        @Override
        public final Builder notificationLambdaArn(String notificationLambdaArn) {
            this.notificationLambdaArn = notificationLambdaArn;
            return this;
        }

        public final void setNotificationLambdaArn(String notificationLambdaArn) {
            this.notificationLambdaArn = notificationLambdaArn;
        }

        @Override
        public Alarms build() {
            return new Alarms(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
