/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a customer managed Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerManagedS3Storage implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerManagedS3Storage.Builder, CustomerManagedS3Storage> {
    private static final SdkField<String> S3_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3ResourceArn").getter(getter(CustomerManagedS3Storage::s3ResourceArn))
            .setter(setter(Builder::s3ResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ResourceArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CustomerManagedS3Storage::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESOURCE_ARN_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3ResourceArn;

    private final String roleArn;

    private CustomerManagedS3Storage(BuilderImpl builder) {
        this.s3ResourceArn = builder.s3ResourceArn;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Amazon S3
     * object. For more information about how to find the ARN for an Amazon S3 object, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a> in the
     * <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a>
     *         in the <i>Amazon Simple Storage Service User Guide</i>.
     */
    public final String s3ResourceArn() {
        return s3ResourceArn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the Identity
     * and Access Management role that allows IoT SiteWise to send data to Amazon S3.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedS3Storage)) {
            return false;
        }
        CustomerManagedS3Storage other = (CustomerManagedS3Storage) obj;
        return Objects.equals(s3ResourceArn(), other.s3ResourceArn()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerManagedS3Storage").add("S3ResourceArn", s3ResourceArn()).add("RoleArn", roleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3ResourceArn":
            return Optional.ofNullable(clazz.cast(s3ResourceArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedS3Storage, T> g) {
        return obj -> g.apply((CustomerManagedS3Storage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerManagedS3Storage> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3 resources</a> in
         * the <i>Amazon Simple Storage Service User Guide</i>.
         * </p>
         * 
         * @param s3ResourceArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the Amazon S3 object. For more information about how to find the ARN for an Amazon S3 object, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-arn-format.html">Amazon S3
         *        resources</a> in the <i>Amazon Simple Storage Service User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ResourceArn(String s3ResourceArn);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
         * </p>
         * 
         * @param roleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the Identity and Access Management role that allows IoT SiteWise to send data to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String s3ResourceArn;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedS3Storage model) {
            s3ResourceArn(model.s3ResourceArn);
            roleArn(model.roleArn);
        }

        public final String getS3ResourceArn() {
            return s3ResourceArn;
        }

        @Override
        public final Builder s3ResourceArn(String s3ResourceArn) {
            this.s3ResourceArn = s3ResourceArn;
            return this;
        }

        public final void setS3ResourceArn(String s3ResourceArn) {
            this.s3ResourceArn = s3ResourceArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public CustomerManagedS3Storage build() {
            return new CustomerManagedS3Storage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
