/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDashboardResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeDashboardResponse.Builder, DescribeDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardId").getter(getter(DescribeDashboardResponse::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardId").build()).build();

    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardArn").getter(getter(DescribeDashboardResponse::dashboardArn))
            .setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardArn").build()).build();

    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardName").getter(getter(DescribeDashboardResponse::dashboardName))
            .setter(setter(Builder::dashboardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardName").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(DescribeDashboardResponse::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> DASHBOARD_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardDescription").getter(getter(DescribeDashboardResponse::dashboardDescription))
            .setter(setter(Builder::dashboardDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDescription").build())
            .build();

    private static final SdkField<String> DASHBOARD_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dashboardDefinition").getter(getter(DescribeDashboardResponse::dashboardDefinition))
            .setter(setter(Builder::dashboardDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardDefinition").build())
            .build();

    private static final SdkField<Instant> DASHBOARD_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dashboardCreationDate").getter(getter(DescribeDashboardResponse::dashboardCreationDate))
            .setter(setter(Builder::dashboardCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardCreationDate").build())
            .build();

    private static final SdkField<Instant> DASHBOARD_LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dashboardLastUpdateDate").getter(getter(DescribeDashboardResponse::dashboardLastUpdateDate))
            .setter(setter(Builder::dashboardLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashboardLastUpdateDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            DASHBOARD_ARN_FIELD, DASHBOARD_NAME_FIELD, PROJECT_ID_FIELD, DASHBOARD_DESCRIPTION_FIELD, DASHBOARD_DEFINITION_FIELD,
            DASHBOARD_CREATION_DATE_FIELD, DASHBOARD_LAST_UPDATE_DATE_FIELD));

    private final String dashboardId;

    private final String dashboardArn;

    private final String dashboardName;

    private final String projectId;

    private final String dashboardDescription;

    private final String dashboardDefinition;

    private final Instant dashboardCreationDate;

    private final Instant dashboardLastUpdateDate;

    private DescribeDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.dashboardArn = builder.dashboardArn;
        this.dashboardName = builder.dashboardName;
        this.projectId = builder.projectId;
        this.dashboardDescription = builder.dashboardDescription;
        this.dashboardDefinition = builder.dashboardDefinition;
        this.dashboardCreationDate = builder.dashboardCreationDate;
        this.dashboardLastUpdateDate = builder.dashboardLastUpdateDate;
    }

    /**
     * <p>
     * The ID of the dashboard.
     * </p>
     * 
     * @return The ID of the dashboard.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     * dashboard, which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         dashboard, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code>
     */
    public final String dashboardArn() {
        return dashboardArn;
    }

    /**
     * <p>
     * The name of the dashboard.
     * </p>
     * 
     * @return The name of the dashboard.
     */
    public final String dashboardName() {
        return dashboardName;
    }

    /**
     * <p>
     * The ID of the project that the dashboard is in.
     * </p>
     * 
     * @return The ID of the project that the dashboard is in.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The dashboard's description.
     * </p>
     * 
     * @return The dashboard's description.
     */
    public final String dashboardDescription() {
        return dashboardDescription;
    }

    /**
     * <p>
     * The dashboard's definition JSON literal. For detailed information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Creating
     * dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The dashboard's definition JSON literal. For detailed information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
     *         >Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String dashboardDefinition() {
        return dashboardDefinition;
    }

    /**
     * <p>
     * The date the dashboard was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the dashboard was created, in Unix epoch time.
     */
    public final Instant dashboardCreationDate() {
        return dashboardCreationDate;
    }

    /**
     * <p>
     * The date the dashboard was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the dashboard was last updated, in Unix epoch time.
     */
    public final Instant dashboardLastUpdateDate() {
        return dashboardLastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardLastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardResponse)) {
            return false;
        }
        DescribeDashboardResponse other = (DescribeDashboardResponse) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && Objects.equals(dashboardArn(), other.dashboardArn())
                && Objects.equals(dashboardName(), other.dashboardName()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(dashboardDescription(), other.dashboardDescription())
                && Objects.equals(dashboardDefinition(), other.dashboardDefinition())
                && Objects.equals(dashboardCreationDate(), other.dashboardCreationDate())
                && Objects.equals(dashboardLastUpdateDate(), other.dashboardLastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDashboardResponse").add("DashboardId", dashboardId())
                .add("DashboardArn", dashboardArn()).add("DashboardName", dashboardName()).add("ProjectId", projectId())
                .add("DashboardDescription", dashboardDescription()).add("DashboardDefinition", dashboardDefinition())
                .add("DashboardCreationDate", dashboardCreationDate()).add("DashboardLastUpdateDate", dashboardLastUpdateDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "dashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "dashboardName":
            return Optional.ofNullable(clazz.cast(dashboardName()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "dashboardDescription":
            return Optional.ofNullable(clazz.cast(dashboardDescription()));
        case "dashboardDefinition":
            return Optional.ofNullable(clazz.cast(dashboardDefinition()));
        case "dashboardCreationDate":
            return Optional.ofNullable(clazz.cast(dashboardCreationDate()));
        case "dashboardLastUpdateDate":
            return Optional.ofNullable(clazz.cast(dashboardLastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardResponse, T> g) {
        return obj -> g.apply((DescribeDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDashboardResponse> {
        /**
         * <p>
         * The ID of the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * dashboard, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code>
         * </p>
         * 
         * @param dashboardArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the dashboard, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:dashboard/${DashboardId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * The name of the dashboard.
         * </p>
         * 
         * @param dashboardName
         *        The name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardName(String dashboardName);

        /**
         * <p>
         * The ID of the project that the dashboard is in.
         * </p>
         * 
         * @param projectId
         *        The ID of the project that the dashboard is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The dashboard's description.
         * </p>
         * 
         * @param dashboardDescription
         *        The dashboard's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardDescription(String dashboardDescription);

        /**
         * <p>
         * The dashboard's definition JSON literal. For detailed information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
         * >Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param dashboardDefinition
         *        The dashboard's definition JSON literal. For detailed information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html"
         *        >Creating dashboards (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardDefinition(String dashboardDefinition);

        /**
         * <p>
         * The date the dashboard was created, in Unix epoch time.
         * </p>
         * 
         * @param dashboardCreationDate
         *        The date the dashboard was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardCreationDate(Instant dashboardCreationDate);

        /**
         * <p>
         * The date the dashboard was last updated, in Unix epoch time.
         * </p>
         * 
         * @param dashboardLastUpdateDate
         *        The date the dashboard was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardLastUpdateDate(Instant dashboardLastUpdateDate);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String dashboardId;

        private String dashboardArn;

        private String dashboardName;

        private String projectId;

        private String dashboardDescription;

        private String dashboardDefinition;

        private Instant dashboardCreationDate;

        private Instant dashboardLastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardResponse model) {
            super(model);
            dashboardId(model.dashboardId);
            dashboardArn(model.dashboardArn);
            dashboardName(model.dashboardName);
            projectId(model.projectId);
            dashboardDescription(model.dashboardDescription);
            dashboardDefinition(model.dashboardDefinition);
            dashboardCreationDate(model.dashboardCreationDate);
            dashboardLastUpdateDate(model.dashboardLastUpdateDate);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final String getDashboardName() {
            return dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getProjectId() {
            return projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final String getDashboardDescription() {
            return dashboardDescription;
        }

        @Override
        public final Builder dashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
            return this;
        }

        public final void setDashboardDescription(String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
        }

        public final String getDashboardDefinition() {
            return dashboardDefinition;
        }

        @Override
        public final Builder dashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
            return this;
        }

        public final void setDashboardDefinition(String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
        }

        public final Instant getDashboardCreationDate() {
            return dashboardCreationDate;
        }

        @Override
        public final Builder dashboardCreationDate(Instant dashboardCreationDate) {
            this.dashboardCreationDate = dashboardCreationDate;
            return this;
        }

        public final void setDashboardCreationDate(Instant dashboardCreationDate) {
            this.dashboardCreationDate = dashboardCreationDate;
        }

        public final Instant getDashboardLastUpdateDate() {
            return dashboardLastUpdateDate;
        }

        @Override
        public final Builder dashboardLastUpdateDate(Instant dashboardLastUpdateDate) {
            this.dashboardLastUpdateDate = dashboardLastUpdateDate;
            return this;
        }

        public final void setDashboardLastUpdateDate(Instant dashboardLastUpdateDate) {
            this.dashboardLastUpdateDate = dashboardLastUpdateDate;
        }

        @Override
        public DescribeDashboardResponse build() {
            return new DescribeDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
