/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInterpolatedAssetPropertyValuesRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<GetInterpolatedAssetPropertyValuesRequest.Builder, GetInterpolatedAssetPropertyValuesRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(GetInterpolatedAssetPropertyValuesRequest::assetId))
            .setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(GetInterpolatedAssetPropertyValuesRequest::propertyId))
            .setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyId").build()).build();

    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyAlias").getter(getter(GetInterpolatedAssetPropertyValuesRequest::propertyAlias))
            .setter(setter(Builder::propertyAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyAlias").build()).build();

    private static final SdkField<Long> START_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("startTimeInSeconds").getter(getter(GetInterpolatedAssetPropertyValuesRequest::startTimeInSeconds))
            .setter(setter(Builder::startTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTimeInSeconds").build())
            .build();

    private static final SdkField<Integer> START_TIME_OFFSET_IN_NANOS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("startTimeOffsetInNanos")
            .getter(getter(GetInterpolatedAssetPropertyValuesRequest::startTimeOffsetInNanos))
            .setter(setter(Builder::startTimeOffsetInNanos))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTimeOffsetInNanos").build())
            .build();

    private static final SdkField<Long> END_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("endTimeInSeconds").getter(getter(GetInterpolatedAssetPropertyValuesRequest::endTimeInSeconds))
            .setter(setter(Builder::endTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTimeInSeconds").build())
            .build();

    private static final SdkField<Integer> END_TIME_OFFSET_IN_NANOS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endTimeOffsetInNanos").getter(getter(GetInterpolatedAssetPropertyValuesRequest::endTimeOffsetInNanos))
            .setter(setter(Builder::endTimeOffsetInNanos))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTimeOffsetInNanos").build())
            .build();

    private static final SdkField<String> QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("quality")
            .getter(getter(GetInterpolatedAssetPropertyValuesRequest::qualityAsString)).setter(setter(Builder::quality))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("quality").build()).build();

    private static final SdkField<Long> INTERVAL_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("intervalInSeconds").getter(getter(GetInterpolatedAssetPropertyValuesRequest::intervalInSeconds))
            .setter(setter(Builder::intervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("intervalInSeconds").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetInterpolatedAssetPropertyValuesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetInterpolatedAssetPropertyValuesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetInterpolatedAssetPropertyValuesRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, START_TIME_IN_SECONDS_FIELD, START_TIME_OFFSET_IN_NANOS_FIELD,
            END_TIME_IN_SECONDS_FIELD, END_TIME_OFFSET_IN_NANOS_FIELD, QUALITY_FIELD, INTERVAL_IN_SECONDS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, TYPE_FIELD));

    private final String assetId;

    private final String propertyId;

    private final String propertyAlias;

    private final Long startTimeInSeconds;

    private final Integer startTimeOffsetInNanos;

    private final Long endTimeInSeconds;

    private final Integer endTimeOffsetInNanos;

    private final String quality;

    private final Long intervalInSeconds;

    private final String nextToken;

    private final Integer maxResults;

    private final String type;

    private GetInterpolatedAssetPropertyValuesRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.startTimeInSeconds = builder.startTimeInSeconds;
        this.startTimeOffsetInNanos = builder.startTimeOffsetInNanos;
        this.endTimeInSeconds = builder.endTimeInSeconds;
        this.endTimeOffsetInNanos = builder.endTimeOffsetInNanos;
        this.quality = builder.quality;
        this.intervalInSeconds = builder.intervalInSeconds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset property.
     * </p>
     * 
     * @return The ID of the asset property.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
     * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String propertyAlias() {
        return propertyAlias;
    }

    /**
     * <p>
     * The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.
     * </p>
     * 
     * @return The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.
     */
    public final Long startTimeInSeconds() {
        return startTimeInSeconds;
    }

    /**
     * <p>
     * The nanosecond offset converted from <code>startTimeInSeconds</code>.
     * </p>
     * 
     * @return The nanosecond offset converted from <code>startTimeInSeconds</code>.
     */
    public final Integer startTimeOffsetInNanos() {
        return startTimeOffsetInNanos;
    }

    /**
     * <p>
     * The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.
     * </p>
     * 
     * @return The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.
     */
    public final Long endTimeInSeconds() {
        return endTimeInSeconds;
    }

    /**
     * <p>
     * The nanosecond offset converted from <code>endTimeInSeconds</code>.
     * </p>
     * 
     * @return The nanosecond offset converted from <code>endTimeInSeconds</code>.
     */
    public final Integer endTimeOffsetInNanos() {
        return endTimeOffsetInNanos;
    }

    /**
     * <p>
     * The quality of the asset property value. You can use this parameter as a filter to choose only the asset property
     * values that have a specific quality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quality} will
     * return {@link Quality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityAsString}.
     * </p>
     * 
     * @return The quality of the asset property value. You can use this parameter as a filter to choose only the asset
     *         property values that have a specific quality.
     * @see Quality
     */
    public final Quality quality() {
        return Quality.fromValue(quality);
    }

    /**
     * <p>
     * The quality of the asset property value. You can use this parameter as a filter to choose only the asset property
     * values that have a specific quality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #quality} will
     * return {@link Quality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #qualityAsString}.
     * </p>
     * 
     * @return The quality of the asset property value. You can use this parameter as a filter to choose only the asset
     *         property values that have a specific quality.
     * @see Quality
     */
    public final String qualityAsString() {
        return quality;
    }

    /**
     * <p>
     * The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.
     * </p>
     * 
     * @return The time interval in seconds over which to interpolate data. Each interval starts when the previous one
     *         ends.
     */
    public final Long intervalInSeconds() {
        return intervalInSeconds;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request. If not specified, the default value is 10.
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request. If not specified, the default value
     *         is 10.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The interpolation type.
     * </p>
     * <p>
     * Valid values: <code>LINEAR_INTERPOLATION</code>
     * </p>
     * 
     * @return The interpolation type.</p>
     *         <p>
     *         Valid values: <code>LINEAR_INTERPOLATION</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeOffsetInNanos());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeOffsetInNanos());
        hashCode = 31 * hashCode + Objects.hashCode(qualityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(intervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInterpolatedAssetPropertyValuesRequest)) {
            return false;
        }
        GetInterpolatedAssetPropertyValuesRequest other = (GetInterpolatedAssetPropertyValuesRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(propertyId(), other.propertyId())
                && Objects.equals(propertyAlias(), other.propertyAlias())
                && Objects.equals(startTimeInSeconds(), other.startTimeInSeconds())
                && Objects.equals(startTimeOffsetInNanos(), other.startTimeOffsetInNanos())
                && Objects.equals(endTimeInSeconds(), other.endTimeInSeconds())
                && Objects.equals(endTimeOffsetInNanos(), other.endTimeOffsetInNanos())
                && Objects.equals(qualityAsString(), other.qualityAsString())
                && Objects.equals(intervalInSeconds(), other.intervalInSeconds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInterpolatedAssetPropertyValuesRequest").add("AssetId", assetId())
                .add("PropertyId", propertyId()).add("PropertyAlias", propertyAlias())
                .add("StartTimeInSeconds", startTimeInSeconds()).add("StartTimeOffsetInNanos", startTimeOffsetInNanos())
                .add("EndTimeInSeconds", endTimeInSeconds()).add("EndTimeOffsetInNanos", endTimeOffsetInNanos())
                .add("Quality", qualityAsString()).add("IntervalInSeconds", intervalInSeconds()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "propertyAlias":
            return Optional.ofNullable(clazz.cast(propertyAlias()));
        case "startTimeInSeconds":
            return Optional.ofNullable(clazz.cast(startTimeInSeconds()));
        case "startTimeOffsetInNanos":
            return Optional.ofNullable(clazz.cast(startTimeOffsetInNanos()));
        case "endTimeInSeconds":
            return Optional.ofNullable(clazz.cast(endTimeInSeconds()));
        case "endTimeOffsetInNanos":
            return Optional.ofNullable(clazz.cast(endTimeOffsetInNanos()));
        case "quality":
            return Optional.ofNullable(clazz.cast(qualityAsString()));
        case "intervalInSeconds":
            return Optional.ofNullable(clazz.cast(intervalInSeconds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInterpolatedAssetPropertyValuesRequest, T> g) {
        return obj -> g.apply((GetInterpolatedAssetPropertyValuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInterpolatedAssetPropertyValuesRequest> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset property.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
         * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param propertyAlias
         *        The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         *        <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyAlias(String propertyAlias);

        /**
         * <p>
         * The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch time.
         * </p>
         * 
         * @param startTimeInSeconds
         *        The exclusive start of the range from which to interpolate data, expressed in seconds in Unix epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeInSeconds(Long startTimeInSeconds);

        /**
         * <p>
         * The nanosecond offset converted from <code>startTimeInSeconds</code>.
         * </p>
         * 
         * @param startTimeOffsetInNanos
         *        The nanosecond offset converted from <code>startTimeInSeconds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeOffsetInNanos(Integer startTimeOffsetInNanos);

        /**
         * <p>
         * The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch time.
         * </p>
         * 
         * @param endTimeInSeconds
         *        The inclusive end of the range from which to interpolate data, expressed in seconds in Unix epoch
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeInSeconds(Long endTimeInSeconds);

        /**
         * <p>
         * The nanosecond offset converted from <code>endTimeInSeconds</code>.
         * </p>
         * 
         * @param endTimeOffsetInNanos
         *        The nanosecond offset converted from <code>endTimeInSeconds</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeOffsetInNanos(Integer endTimeOffsetInNanos);

        /**
         * <p>
         * The quality of the asset property value. You can use this parameter as a filter to choose only the asset
         * property values that have a specific quality.
         * </p>
         * 
         * @param quality
         *        The quality of the asset property value. You can use this parameter as a filter to choose only the
         *        asset property values that have a specific quality.
         * @see Quality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Quality
         */
        Builder quality(String quality);

        /**
         * <p>
         * The quality of the asset property value. You can use this parameter as a filter to choose only the asset
         * property values that have a specific quality.
         * </p>
         * 
         * @param quality
         *        The quality of the asset property value. You can use this parameter as a filter to choose only the
         *        asset property values that have a specific quality.
         * @see Quality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Quality
         */
        Builder quality(Quality quality);

        /**
         * <p>
         * The time interval in seconds over which to interpolate data. Each interval starts when the previous one ends.
         * </p>
         * 
         * @param intervalInSeconds
         *        The time interval in seconds over which to interpolate data. Each interval starts when the previous
         *        one ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalInSeconds(Long intervalInSeconds);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request. If not specified, the default value is
         * 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request. If not specified, the default
         *        value is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The interpolation type.
         * </p>
         * <p>
         * Valid values: <code>LINEAR_INTERPOLATION</code>
         * </p>
         * 
         * @param type
         *        The interpolation type.</p>
         *        <p>
         *        Valid values: <code>LINEAR_INTERPOLATION</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String propertyId;

        private String propertyAlias;

        private Long startTimeInSeconds;

        private Integer startTimeOffsetInNanos;

        private Long endTimeInSeconds;

        private Integer endTimeOffsetInNanos;

        private String quality;

        private Long intervalInSeconds;

        private String nextToken;

        private Integer maxResults;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInterpolatedAssetPropertyValuesRequest model) {
            super(model);
            assetId(model.assetId);
            propertyId(model.propertyId);
            propertyAlias(model.propertyAlias);
            startTimeInSeconds(model.startTimeInSeconds);
            startTimeOffsetInNanos(model.startTimeOffsetInNanos);
            endTimeInSeconds(model.endTimeInSeconds);
            endTimeOffsetInNanos(model.endTimeOffsetInNanos);
            quality(model.quality);
            intervalInSeconds(model.intervalInSeconds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            type(model.type);
        }

        public final String getAssetId() {
            return assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        public final Long getStartTimeInSeconds() {
            return startTimeInSeconds;
        }

        @Override
        public final Builder startTimeInSeconds(Long startTimeInSeconds) {
            this.startTimeInSeconds = startTimeInSeconds;
            return this;
        }

        public final void setStartTimeInSeconds(Long startTimeInSeconds) {
            this.startTimeInSeconds = startTimeInSeconds;
        }

        public final Integer getStartTimeOffsetInNanos() {
            return startTimeOffsetInNanos;
        }

        @Override
        public final Builder startTimeOffsetInNanos(Integer startTimeOffsetInNanos) {
            this.startTimeOffsetInNanos = startTimeOffsetInNanos;
            return this;
        }

        public final void setStartTimeOffsetInNanos(Integer startTimeOffsetInNanos) {
            this.startTimeOffsetInNanos = startTimeOffsetInNanos;
        }

        public final Long getEndTimeInSeconds() {
            return endTimeInSeconds;
        }

        @Override
        public final Builder endTimeInSeconds(Long endTimeInSeconds) {
            this.endTimeInSeconds = endTimeInSeconds;
            return this;
        }

        public final void setEndTimeInSeconds(Long endTimeInSeconds) {
            this.endTimeInSeconds = endTimeInSeconds;
        }

        public final Integer getEndTimeOffsetInNanos() {
            return endTimeOffsetInNanos;
        }

        @Override
        public final Builder endTimeOffsetInNanos(Integer endTimeOffsetInNanos) {
            this.endTimeOffsetInNanos = endTimeOffsetInNanos;
            return this;
        }

        public final void setEndTimeOffsetInNanos(Integer endTimeOffsetInNanos) {
            this.endTimeOffsetInNanos = endTimeOffsetInNanos;
        }

        public final String getQuality() {
            return quality;
        }

        @Override
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        @Override
        public final Builder quality(Quality quality) {
            this.quality(quality == null ? null : quality.toString());
            return this;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        public final Long getIntervalInSeconds() {
            return intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final void setIntervalInSeconds(Long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInterpolatedAssetPropertyValuesRequest build() {
            return new GetInterpolatedAssetPropertyValuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
