/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutStorageConfigurationResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<PutStorageConfigurationResponse.Builder, PutStorageConfigurationResponse> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(PutStorageConfigurationResponse::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<MultiLayerStorage> MULTI_LAYER_STORAGE_FIELD = SdkField
            .<MultiLayerStorage> builder(MarshallingType.SDK_POJO).memberName("multiLayerStorage")
            .getter(getter(PutStorageConfigurationResponse::multiLayerStorage)).setter(setter(Builder::multiLayerStorage))
            .constructor(MultiLayerStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiLayerStorage").build()).build();

    private static final SdkField<ConfigurationStatus> CONFIGURATION_STATUS_FIELD = SdkField
            .<ConfigurationStatus> builder(MarshallingType.SDK_POJO).memberName("configurationStatus")
            .getter(getter(PutStorageConfigurationResponse::configurationStatus)).setter(setter(Builder::configurationStatus))
            .constructor(ConfigurationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            MULTI_LAYER_STORAGE_FIELD, CONFIGURATION_STATUS_FIELD));

    private final String storageType;

    private final MultiLayerStorage multiLayerStorage;

    private final ConfigurationStatus configurationStatus;

    private PutStorageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.storageType = builder.storageType;
        this.multiLayerStorage = builder.multiLayerStorage;
        this.configurationStatus = builder.configurationStatus;
    }

    /**
     * <p>
     * The type of storage that you specified for your data. The storage type can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and saves a
     * copy of your raw data and metadata in an Amazon S3 object that you specified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The type of storage that you specified for your data. The storage type can be one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
     *         database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
     *         saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
     *         </p>
     *         </li>
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The type of storage that you specified for your data. The storage type can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and saves a
     * copy of your raw data and metadata in an Amazon S3 object that you specified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The type of storage that you specified for your data. The storage type can be one of the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
     *         database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
     *         saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
     *         </p>
     *         </li>
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * Contains information about the storage destination.
     * </p>
     * 
     * @return Contains information about the storage destination.
     */
    public final MultiLayerStorage multiLayerStorage() {
        return multiLayerStorage;
    }

    /**
     * Returns the value of the ConfigurationStatus property for this object.
     * 
     * @return The value of the ConfigurationStatus property for this object.
     */
    public final ConfigurationStatus configurationStatus() {
        return configurationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(multiLayerStorage());
        hashCode = 31 * hashCode + Objects.hashCode(configurationStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStorageConfigurationResponse)) {
            return false;
        }
        PutStorageConfigurationResponse other = (PutStorageConfigurationResponse) obj;
        return Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(multiLayerStorage(), other.multiLayerStorage())
                && Objects.equals(configurationStatus(), other.configurationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutStorageConfigurationResponse").add("StorageType", storageTypeAsString())
                .add("MultiLayerStorage", multiLayerStorage()).add("ConfigurationStatus", configurationStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "multiLayerStorage":
            return Optional.ofNullable(clazz.cast(multiLayerStorage()));
        case "configurationStatus":
            return Optional.ofNullable(clazz.cast(configurationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutStorageConfigurationResponse, T> g) {
        return obj -> g.apply((PutStorageConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutStorageConfigurationResponse> {
        /**
         * <p>
         * The type of storage that you specified for your data. The storage type can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
         * saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageType
         *        The type of storage that you specified for your data. The storage type can be one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
         *        database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database
         *        and saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         *        </p>
         *        </li>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The type of storage that you specified for your data. The storage type can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database and
         * saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storageType
         *        The type of storage that you specified for your data. The storage type can be one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SITEWISE_DEFAULT_STORAGE</code> – IoT SiteWise replicates your data into a service managed
         *        database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MULTI_LAYER_STORAGE</code> – IoT SiteWise replicates your data into a service managed database
         *        and saves a copy of your raw data and metadata in an Amazon S3 object that you specified.
         *        </p>
         *        </li>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * Contains information about the storage destination.
         * </p>
         * 
         * @param multiLayerStorage
         *        Contains information about the storage destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiLayerStorage(MultiLayerStorage multiLayerStorage);

        /**
         * <p>
         * Contains information about the storage destination.
         * </p>
         * This is a convenience that creates an instance of the {@link MultiLayerStorage.Builder} avoiding the need to
         * create one manually via {@link MultiLayerStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiLayerStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #multiLayerStorage(MultiLayerStorage)}.
         * 
         * @param multiLayerStorage
         *        a consumer that will call methods on {@link MultiLayerStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiLayerStorage(MultiLayerStorage)
         */
        default Builder multiLayerStorage(Consumer<MultiLayerStorage.Builder> multiLayerStorage) {
            return multiLayerStorage(MultiLayerStorage.builder().applyMutation(multiLayerStorage).build());
        }

        /**
         * Sets the value of the ConfigurationStatus property for this object.
         *
         * @param configurationStatus
         *        The new value for the ConfigurationStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationStatus(ConfigurationStatus configurationStatus);

        /**
         * Sets the value of the ConfigurationStatus property for this object.
         *
         * This is a convenience that creates an instance of the {@link ConfigurationStatus.Builder} avoiding the need
         * to create one manually via {@link ConfigurationStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationStatus(ConfigurationStatus)}.
         * 
         * @param configurationStatus
         *        a consumer that will call methods on {@link ConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationStatus(ConfigurationStatus)
         */
        default Builder configurationStatus(Consumer<ConfigurationStatus.Builder> configurationStatus) {
            return configurationStatus(ConfigurationStatus.builder().applyMutation(configurationStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String storageType;

        private MultiLayerStorage multiLayerStorage;

        private ConfigurationStatus configurationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutStorageConfigurationResponse model) {
            super(model);
            storageType(model.storageType);
            multiLayerStorage(model.multiLayerStorage);
            configurationStatus(model.configurationStatus);
        }

        public final String getStorageType() {
            return storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final MultiLayerStorage.Builder getMultiLayerStorage() {
            return multiLayerStorage != null ? multiLayerStorage.toBuilder() : null;
        }

        @Override
        public final Builder multiLayerStorage(MultiLayerStorage multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage;
            return this;
        }

        public final void setMultiLayerStorage(MultiLayerStorage.BuilderImpl multiLayerStorage) {
            this.multiLayerStorage = multiLayerStorage != null ? multiLayerStorage.build() : null;
        }

        public final ConfigurationStatus.Builder getConfigurationStatus() {
            return configurationStatus != null ? configurationStatus.toBuilder() : null;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        public final void setConfigurationStatus(ConfigurationStatus.BuilderImpl configurationStatus) {
            this.configurationStatus = configurationStatus != null ? configurationStatus.build() : null;
        }

        @Override
        public PutStorageConfigurationResponse build() {
            return new PutStorageConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
