/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssetPropertyRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateAssetPropertyRequest.Builder, UpdateAssetPropertyRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(UpdateAssetPropertyRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(UpdateAssetPropertyRequest::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("propertyId").build()).build();

    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyAlias").getter(getter(UpdateAssetPropertyRequest::propertyAlias))
            .setter(setter(Builder::propertyAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()).build();

    private static final SdkField<String> PROPERTY_NOTIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyNotificationState")
            .getter(getter(UpdateAssetPropertyRequest::propertyNotificationStateAsString))
            .setter(setter(Builder::propertyNotificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyNotificationState").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAssetPropertyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, PROPERTY_NOTIFICATION_STATE_FIELD, CLIENT_TOKEN_FIELD));

    private final String assetId;

    private final String propertyId;

    private final String propertyAlias;

    private final String propertyNotificationState;

    private final String clientToken;

    private UpdateAssetPropertyRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.propertyNotificationState = builder.propertyNotificationState;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the asset to be updated.
     * </p>
     * 
     * @return The ID of the asset to be updated.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset property to be updated.
     * </p>
     * 
     * @return The ID of the asset property to be updated.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
     * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * If you omit this parameter, the alias is removed from the property.
     * </p>
     * 
     * @return The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         If you omit this parameter, the alias is removed from the property.
     */
    public final String propertyAlias() {
        return propertyAlias;
    }

    /**
     * <p>
     * The MQTT notification state (enabled or disabled) for this asset property. When the notification state is
     * enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting
     * with other services</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * If you omit this parameter, the notification state is set to <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #propertyNotificationState} will return {@link PropertyNotificationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #propertyNotificationStateAsString}.
     * </p>
     * 
     * @return The MQTT notification state (enabled or disabled) for this asset property. When the notification state is
     *         enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see
     *         <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">
     *         Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         If you omit this parameter, the notification state is set to <code>DISABLED</code>.
     * @see PropertyNotificationState
     */
    public final PropertyNotificationState propertyNotificationState() {
        return PropertyNotificationState.fromValue(propertyNotificationState);
    }

    /**
     * <p>
     * The MQTT notification state (enabled or disabled) for this asset property. When the notification state is
     * enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting
     * with other services</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * If you omit this parameter, the notification state is set to <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #propertyNotificationState} will return {@link PropertyNotificationState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #propertyNotificationStateAsString}.
     * </p>
     * 
     * @return The MQTT notification state (enabled or disabled) for this asset property. When the notification state is
     *         enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see
     *         <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">
     *         Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         If you omit this parameter, the notification state is set to <code>DISABLED</code>.
     * @see PropertyNotificationState
     */
    public final String propertyNotificationStateAsString() {
        return propertyNotificationState;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(propertyNotificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetPropertyRequest)) {
            return false;
        }
        UpdateAssetPropertyRequest other = (UpdateAssetPropertyRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(propertyId(), other.propertyId())
                && Objects.equals(propertyAlias(), other.propertyAlias())
                && Objects.equals(propertyNotificationStateAsString(), other.propertyNotificationStateAsString())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssetPropertyRequest").add("AssetId", assetId()).add("PropertyId", propertyId())
                .add("PropertyAlias", propertyAlias()).add("PropertyNotificationState", propertyNotificationStateAsString())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "propertyAlias":
            return Optional.ofNullable(clazz.cast(propertyAlias()));
        case "propertyNotificationState":
            return Optional.ofNullable(clazz.cast(propertyNotificationStateAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetPropertyRequest, T> g) {
        return obj -> g.apply((UpdateAssetPropertyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssetPropertyRequest> {
        /**
         * <p>
         * The ID of the asset to be updated.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset property to be updated.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset property to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
         * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * If you omit this parameter, the alias is removed from the property.
         * </p>
         * 
         * @param propertyAlias
         *        The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         *        <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        If you omit this parameter, the alias is removed from the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyAlias(String propertyAlias);

        /**
         * <p>
         * The MQTT notification state (enabled or disabled) for this asset property. When the notification state is
         * enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting
         * with other services</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * If you omit this parameter, the notification state is set to <code>DISABLED</code>.
         * </p>
         * 
         * @param propertyNotificationState
         *        The MQTT notification state (enabled or disabled) for this asset property. When the notification state
         *        is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html"
         *        >Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        If you omit this parameter, the notification state is set to <code>DISABLED</code>.
         * @see PropertyNotificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyNotificationState
         */
        Builder propertyNotificationState(String propertyNotificationState);

        /**
         * <p>
         * The MQTT notification state (enabled or disabled) for this asset property. When the notification state is
         * enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html">Interacting
         * with other services</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * If you omit this parameter, the notification state is set to <code>DISABLED</code>.
         * </p>
         * 
         * @param propertyNotificationState
         *        The MQTT notification state (enabled or disabled) for this asset property. When the notification state
         *        is enabled, IoT SiteWise publishes property value updates to a unique MQTT topic. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html"
         *        >Interacting with other services</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        If you omit this parameter, the notification state is set to <code>DISABLED</code>.
         * @see PropertyNotificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyNotificationState
         */
        Builder propertyNotificationState(PropertyNotificationState propertyNotificationState);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private String propertyId;

        private String propertyAlias;

        private String propertyNotificationState;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetPropertyRequest model) {
            super(model);
            assetId(model.assetId);
            propertyId(model.propertyId);
            propertyAlias(model.propertyAlias);
            propertyNotificationState(model.propertyNotificationState);
            clientToken(model.clientToken);
        }

        public final String getAssetId() {
            return assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        public final String getPropertyNotificationState() {
            return propertyNotificationState;
        }

        @Override
        public final Builder propertyNotificationState(String propertyNotificationState) {
            this.propertyNotificationState = propertyNotificationState;
            return this;
        }

        @Override
        public final Builder propertyNotificationState(PropertyNotificationState propertyNotificationState) {
            this.propertyNotificationState(propertyNotificationState == null ? null : propertyNotificationState.toString());
            return this;
        }

        public final void setPropertyNotificationState(String propertyNotificationState) {
            this.propertyNotificationState = propertyNotificationState;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetPropertyRequest build() {
            return new UpdateAssetPropertyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
