/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPoliciesRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListAccessPoliciesRequest.Builder, ListAccessPoliciesRequest> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityType").getter(getter(ListAccessPoliciesRequest::identityTypeAsString))
            .setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identityType").build()).build();

    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityId").getter(getter(ListAccessPoliciesRequest::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identityId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ListAccessPoliciesRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(ListAccessPoliciesRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceId").build()).build();

    private static final SdkField<String> IAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("iamArn")
            .getter(getter(ListAccessPoliciesRequest::iamArn)).setter(setter(Builder::iamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("iamArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAccessPoliciesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAccessPoliciesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD,
            IDENTITY_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, IAM_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String identityType;

    private final String identityId;

    private final String resourceType;

    private final String resourceId;

    private final String iamArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListAccessPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.identityId = builder.identityId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.iamArn = builder.iamArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter
     * is required if you specify <code>identityId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This
     *         parameter is required if you specify <code>identityId</code>.
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This parameter
     * is required if you specify <code>identityId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This
     *         parameter is required if you specify <code>identityId</code>.
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The ID of the identity. This parameter is required if you specify <code>USER</code> or <code>GROUP</code> for
     * <code>identityType</code>.
     * </p>
     * 
     * @return The ID of the identity. This parameter is required if you specify <code>USER</code> or <code>GROUP</code>
     *         for <code>identityType</code>.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * <p>
     * The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource (portal or project). This parameter is required if you specify
     *         <code>resourceId</code>.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource (portal or project). This parameter is required if you specify
     *         <code>resourceId</code>.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource. This parameter is required if you specify <code>resourceType</code>.
     * </p>
     * 
     * @return The ID of the resource. This parameter is required if you specify <code>resourceType</code>.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The ARN of the IAM user. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM
     * User Guide</i>. This parameter is required if you specify <code>IAM</code> for <code>identityType</code>.
     * </p>
     * 
     * @return The ARN of the IAM user. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
     *         <i>IAM User Guide</i>. This parameter is required if you specify <code>IAM</code> for
     *         <code>identityType</code>.
     */
    public final String iamArn() {
        return iamArn;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * <p>
     * Default: 50
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.</p>
     *         <p>
     *         Default: 50
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(iamArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPoliciesRequest)) {
            return false;
        }
        ListAccessPoliciesRequest other = (ListAccessPoliciesRequest) obj;
        return Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(identityId(), other.identityId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(iamArn(), other.iamArn())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessPoliciesRequest").add("IdentityType", identityTypeAsString())
                .add("IdentityId", identityId()).add("ResourceType", resourceTypeAsString()).add("ResourceId", resourceId())
                .add("IamArn", iamArn()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "identityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "iamArn":
            return Optional.ofNullable(clazz.cast(iamArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPoliciesRequest, T> g) {
        return obj -> g.apply((ListAccessPoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessPoliciesRequest> {
        /**
         * <p>
         * The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This
         * parameter is required if you specify <code>identityId</code>.
         * </p>
         * 
         * @param identityType
         *        The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This
         *        parameter is required if you specify <code>identityId</code>.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This
         * parameter is required if you specify <code>identityId</code>.
         * </p>
         * 
         * @param identityType
         *        The type of identity (Amazon Web Services SSO user, Amazon Web Services SSO group, or IAM user). This
         *        parameter is required if you specify <code>identityId</code>.
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The ID of the identity. This parameter is required if you specify <code>USER</code> or <code>GROUP</code> for
         * <code>identityType</code>.
         * </p>
         * 
         * @param identityId
         *        The ID of the identity. This parameter is required if you specify <code>USER</code> or
         *        <code>GROUP</code> for <code>identityType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource (portal or project). This parameter is required if you specify
         *        <code>resourceId</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource (portal or project). This parameter is required if you specify <code>resourceId</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource (portal or project). This parameter is required if you specify
         *        <code>resourceId</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The ID of the resource. This parameter is required if you specify <code>resourceType</code>.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource. This parameter is required if you specify <code>resourceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The ARN of the IAM user. For more information, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the <i>IAM
         * User Guide</i>. This parameter is required if you specify <code>IAM</code> for <code>identityType</code>.
         * </p>
         * 
         * @param iamArn
         *        The ARN of the IAM user. For more information, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM ARNs</a> in the
         *        <i>IAM User Guide</i>. This parameter is required if you specify <code>IAM</code> for
         *        <code>identityType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamArn(String iamArn);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * <p>
         * Default: 50
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.</p>
         *        <p>
         *        Default: 50
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String identityType;

        private String identityId;

        private String resourceType;

        private String resourceId;

        private String iamArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPoliciesRequest model) {
            super(model);
            identityType(model.identityType);
            identityId(model.identityId);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            iamArn(model.iamArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getIdentityType() {
            return identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        @Transient
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        @Transient
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getIdentityId() {
            return identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        @Transient
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getIamArn() {
            return iamArn;
        }

        public final void setIamArn(String iamArn) {
            this.iamArn = iamArn;
        }

        @Override
        @Transient
        public final Builder iamArn(String iamArn) {
            this.iamArn = iamArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessPoliciesRequest build() {
            return new ListAccessPoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
