/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of a time series (data stream).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesSummary.Builder, TimeSeriesSummary> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(TimeSeriesSummary::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyId").getter(getter(TimeSeriesSummary::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(TimeSeriesSummary::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> TIME_SERIES_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeSeriesId").getter(getter(TimeSeriesSummary::timeSeriesId)).setter(setter(Builder::timeSeriesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeSeriesId").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(TimeSeriesSummary::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataTypeSpec").getter(getter(TimeSeriesSummary::dataTypeSpec)).setter(setter(Builder::dataTypeSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()).build();

    private static final SdkField<Instant> TIME_SERIES_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timeSeriesCreationDate").getter(getter(TimeSeriesSummary::timeSeriesCreationDate))
            .setter(setter(Builder::timeSeriesCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeSeriesCreationDate").build())
            .build();

    private static final SdkField<Instant> TIME_SERIES_LAST_UPDATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("timeSeriesLastUpdateDate")
            .getter(getter(TimeSeriesSummary::timeSeriesLastUpdateDate)).setter(setter(Builder::timeSeriesLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeSeriesLastUpdateDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            PROPERTY_ID_FIELD, ALIAS_FIELD, TIME_SERIES_ID_FIELD, DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD,
            TIME_SERIES_CREATION_DATE_FIELD, TIME_SERIES_LAST_UPDATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String propertyId;

    private final String alias;

    private final String timeSeriesId;

    private final String dataType;

    private final String dataTypeSpec;

    private final Instant timeSeriesCreationDate;

    private final Instant timeSeriesLastUpdateDate;

    private TimeSeriesSummary(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.alias = builder.alias;
        this.timeSeriesId = builder.timeSeriesId;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.timeSeriesCreationDate = builder.timeSeriesCreationDate;
        this.timeSeriesLastUpdateDate = builder.timeSeriesLastUpdateDate;
    }

    /**
     * <p>
     * The ID of the asset in which the asset property was created.
     * </p>
     * 
     * @return The ID of the asset in which the asset property was created.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset property.
     * </p>
     * 
     * @return The ID of the asset property.
     */
    public final String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The alias that identifies the time series.
     * </p>
     * 
     * @return The alias that identifies the time series.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The ID of the time series.
     * </p>
     * 
     * @return The ID of the time series.
     */
    public final String timeSeriesId() {
        return timeSeriesId;
    }

    /**
     * <p>
     * The data type of the time series.
     * </p>
     * <p>
     * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the
     * structure for this time series.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the time series.</p>
     *         <p>
     *         If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type
     *         of the structure for this time series.
     * @see PropertyDataType
     */
    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The data type of the time series.
     * </p>
     * <p>
     * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of the
     * structure for this time series.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The data type of the time series.</p>
     *         <p>
     *         If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type
     *         of the structure for this time series.
     * @see PropertyDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The data type of the structure for this time series. This parameter is required for time series that have the
     * <code>STRUCT</code> data type.
     * </p>
     * <p>
     * The options for this parameter depend on the type of the composite model in which you created the asset property
     * that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm composite
     * models.
     * </p>
     * 
     * @return The data type of the structure for this time series. This parameter is required for time series that have
     *         the <code>STRUCT</code> data type.</p>
     *         <p>
     *         The options for this parameter depend on the type of the composite model in which you created the asset
     *         property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in
     *         alarm composite models.
     */
    public final String dataTypeSpec() {
        return dataTypeSpec;
    }

    /**
     * <p>
     * The date that the time series was created, in Unix epoch time.
     * </p>
     * 
     * @return The date that the time series was created, in Unix epoch time.
     */
    public final Instant timeSeriesCreationDate() {
        return timeSeriesCreationDate;
    }

    /**
     * <p>
     * The date that the time series was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date that the time series was last updated, in Unix epoch time.
     */
    public final Instant timeSeriesLastUpdateDate() {
        return timeSeriesLastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesLastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesSummary)) {
            return false;
        }
        TimeSeriesSummary other = (TimeSeriesSummary) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(propertyId(), other.propertyId())
                && Objects.equals(alias(), other.alias()) && Objects.equals(timeSeriesId(), other.timeSeriesId())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString())
                && Objects.equals(dataTypeSpec(), other.dataTypeSpec())
                && Objects.equals(timeSeriesCreationDate(), other.timeSeriesCreationDate())
                && Objects.equals(timeSeriesLastUpdateDate(), other.timeSeriesLastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesSummary").add("AssetId", assetId()).add("PropertyId", propertyId())
                .add("Alias", alias()).add("TimeSeriesId", timeSeriesId()).add("DataType", dataTypeAsString())
                .add("DataTypeSpec", dataTypeSpec()).add("TimeSeriesCreationDate", timeSeriesCreationDate())
                .add("TimeSeriesLastUpdateDate", timeSeriesLastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "timeSeriesId":
            return Optional.ofNullable(clazz.cast(timeSeriesId()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "dataTypeSpec":
            return Optional.ofNullable(clazz.cast(dataTypeSpec()));
        case "timeSeriesCreationDate":
            return Optional.ofNullable(clazz.cast(timeSeriesCreationDate()));
        case "timeSeriesLastUpdateDate":
            return Optional.ofNullable(clazz.cast(timeSeriesLastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesSummary, T> g) {
        return obj -> g.apply((TimeSeriesSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesSummary> {
        /**
         * <p>
         * The ID of the asset in which the asset property was created.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset in which the asset property was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset property.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The alias that identifies the time series.
         * </p>
         * 
         * @param alias
         *        The alias that identifies the time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The ID of the time series.
         * </p>
         * 
         * @param timeSeriesId
         *        The ID of the time series.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesId(String timeSeriesId);

        /**
         * <p>
         * The data type of the time series.
         * </p>
         * <p>
         * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of
         * the structure for this time series.
         * </p>
         * 
         * @param dataType
         *        The data type of the time series.</p>
         *        <p>
         *        If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the
         *        type of the structure for this time series.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The data type of the time series.
         * </p>
         * <p>
         * If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the type of
         * the structure for this time series.
         * </p>
         * 
         * @param dataType
         *        The data type of the time series.</p>
         *        <p>
         *        If you specify <code>STRUCT</code>, you must also specify <code>dataTypeSpec</code> to identify the
         *        type of the structure for this time series.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(PropertyDataType dataType);

        /**
         * <p>
         * The data type of the structure for this time series. This parameter is required for time series that have the
         * <code>STRUCT</code> data type.
         * </p>
         * <p>
         * The options for this parameter depend on the type of the composite model in which you created the asset
         * property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm state in alarm
         * composite models.
         * </p>
         * 
         * @param dataTypeSpec
         *        The data type of the structure for this time series. This parameter is required for time series that
         *        have the <code>STRUCT</code> data type.</p>
         *        <p>
         *        The options for this parameter depend on the type of the composite model in which you created the
         *        asset property that is associated with your time series. Use <code>AWS/ALARM_STATE</code> for alarm
         *        state in alarm composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeSpec(String dataTypeSpec);

        /**
         * <p>
         * The date that the time series was created, in Unix epoch time.
         * </p>
         * 
         * @param timeSeriesCreationDate
         *        The date that the time series was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesCreationDate(Instant timeSeriesCreationDate);

        /**
         * <p>
         * The date that the time series was last updated, in Unix epoch time.
         * </p>
         * 
         * @param timeSeriesLastUpdateDate
         *        The date that the time series was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesLastUpdateDate(Instant timeSeriesLastUpdateDate);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String propertyId;

        private String alias;

        private String timeSeriesId;

        private String dataType;

        private String dataTypeSpec;

        private Instant timeSeriesCreationDate;

        private Instant timeSeriesLastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesSummary model) {
            assetId(model.assetId);
            propertyId(model.propertyId);
            alias(model.alias);
            timeSeriesId(model.timeSeriesId);
            dataType(model.dataType);
            dataTypeSpec(model.dataTypeSpec);
            timeSeriesCreationDate(model.timeSeriesCreationDate);
            timeSeriesLastUpdateDate(model.timeSeriesLastUpdateDate);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        @Transient
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        @Transient
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        @Transient
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getTimeSeriesId() {
            return timeSeriesId;
        }

        public final void setTimeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
        }

        @Override
        @Transient
        public final Builder timeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        @Transient
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        @Transient
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeSpec() {
            return dataTypeSpec;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        @Override
        @Transient
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final Instant getTimeSeriesCreationDate() {
            return timeSeriesCreationDate;
        }

        public final void setTimeSeriesCreationDate(Instant timeSeriesCreationDate) {
            this.timeSeriesCreationDate = timeSeriesCreationDate;
        }

        @Override
        @Transient
        public final Builder timeSeriesCreationDate(Instant timeSeriesCreationDate) {
            this.timeSeriesCreationDate = timeSeriesCreationDate;
            return this;
        }

        public final Instant getTimeSeriesLastUpdateDate() {
            return timeSeriesLastUpdateDate;
        }

        public final void setTimeSeriesLastUpdateDate(Instant timeSeriesLastUpdateDate) {
            this.timeSeriesLastUpdateDate = timeSeriesLastUpdateDate;
        }

        @Override
        @Transient
        public final Builder timeSeriesLastUpdateDate(Instant timeSeriesLastUpdateDate) {
            this.timeSeriesLastUpdateDate = timeSeriesLastUpdateDate;
            return this;
        }

        @Override
        public TimeSeriesSummary build() {
            return new TimeSeriesSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
