/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGatewayCapabilityConfigurationRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateGatewayCapabilityConfigurationRequest.Builder, UpdateGatewayCapabilityConfigurationRequest> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(UpdateGatewayCapabilityConfigurationRequest::gatewayId))
            .setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()).build();

    private static final SdkField<String> CAPABILITY_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityNamespace").getter(getter(UpdateGatewayCapabilityConfigurationRequest::capabilityNamespace))
            .setter(setter(Builder::capabilityNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityNamespace").build())
            .build();

    private static final SdkField<String> CAPABILITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityConfiguration")
            .getter(getter(UpdateGatewayCapabilityConfigurationRequest::capabilityConfiguration))
            .setter(setter(Builder::capabilityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            CAPABILITY_NAMESPACE_FIELD, CAPABILITY_CONFIGURATION_FIELD));

    private final String gatewayId;

    private final String capabilityNamespace;

    private final String capabilityConfiguration;

    private UpdateGatewayCapabilityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.capabilityNamespace = builder.capabilityNamespace;
        this.capabilityConfiguration = builder.capabilityConfiguration;
    }

    /**
     * <p>
     * The ID of the gateway to be updated.
     * </p>
     * 
     * @return The ID of the gateway to be updated.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA sources
     * from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
     * <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as <code>1</code>.
     * </p>
     * 
     * @return The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA
     *         sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
     *         <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
     *         <code>1</code>.
     */
    public final String capabilityNamespace() {
        return capabilityNamespace;
    }

    /**
     * <p>
     * The JSON document that defines the configuration for the gateway capability. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli"
     * >Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The JSON document that defines the configuration for the gateway capability. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli"
     *         >Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String capabilityConfiguration() {
        return capabilityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayCapabilityConfigurationRequest)) {
            return false;
        }
        UpdateGatewayCapabilityConfigurationRequest other = (UpdateGatewayCapabilityConfigurationRequest) obj;
        return Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(capabilityNamespace(), other.capabilityNamespace())
                && Objects.equals(capabilityConfiguration(), other.capabilityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGatewayCapabilityConfigurationRequest").add("GatewayId", gatewayId())
                .add("CapabilityNamespace", capabilityNamespace()).add("CapabilityConfiguration", capabilityConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "capabilityNamespace":
            return Optional.ofNullable(clazz.cast(capabilityNamespace()));
        case "capabilityConfiguration":
            return Optional.ofNullable(clazz.cast(capabilityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayCapabilityConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateGatewayCapabilityConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGatewayCapabilityConfigurationRequest> {
        /**
         * <p>
         * The ID of the gateway to be updated.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The namespace of the gateway capability configuration to be updated. For example, if you configure OPC-UA
         * sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
         * <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
         * <code>1</code>.
         * </p>
         * 
         * @param capabilityNamespace
         *        The namespace of the gateway capability configuration to be updated. For example, if you configure
         *        OPC-UA sources from the IoT SiteWise console, your OPC-UA capability configuration has the namespace
         *        <code>iotsitewise:opcuacollector:version</code>, where <code>version</code> is a number such as
         *        <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityNamespace(String capabilityNamespace);

        /**
         * <p>
         * The JSON document that defines the configuration for the gateway capability. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">
         * Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param capabilityConfiguration
         *        The JSON document that defines the configuration for the gateway capability. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli"
         *        >Configuring data sources (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityConfiguration(String capabilityConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String gatewayId;

        private String capabilityNamespace;

        private String capabilityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayCapabilityConfigurationRequest model) {
            super(model);
            gatewayId(model.gatewayId);
            capabilityNamespace(model.capabilityNamespace);
            capabilityConfiguration(model.capabilityConfiguration);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        @Transient
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getCapabilityNamespace() {
            return capabilityNamespace;
        }

        public final void setCapabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
        }

        @Override
        @Transient
        public final Builder capabilityNamespace(String capabilityNamespace) {
            this.capabilityNamespace = capabilityNamespace;
            return this;
        }

        public final String getCapabilityConfiguration() {
            return capabilityConfiguration;
        }

        public final void setCapabilityConfiguration(String capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration;
        }

        @Override
        @Transient
        public final Builder capabilityConfiguration(String capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayCapabilityConfigurationRequest build() {
            return new UpdateGatewayCapabilityConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
