/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a composite model in an asset. This object contains the asset's properties that you define
 * in the composite model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetCompositeModel implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetCompositeModel.Builder, AssetCompositeModel> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetCompositeModel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssetCompositeModel::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AssetCompositeModel::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<AssetProperty>> PROPERTIES_FIELD = SdkField
            .<List<AssetProperty>> builder(MarshallingType.LIST)
            .memberName("properties")
            .getter(getter(AssetCompositeModel::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            TYPE_FIELD, PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String type;

    private final List<AssetProperty> properties;

    private AssetCompositeModel(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The name of the composite model.
     * </p>
     * 
     * @return The name of the composite model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the composite model.
     * </p>
     * 
     * @return The description of the composite model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
     * </p>
     * 
     * @return The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The asset properties that this composite model defines.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The asset properties that this composite model defines.
     */
    public final List<AssetProperty> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetCompositeModel)) {
            return false;
        }
        AssetCompositeModel other = (AssetCompositeModel) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(type(), other.type()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetCompositeModel").add("Name", name()).add("Description", description()).add("Type", type())
                .add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetCompositeModel, T> g) {
        return obj -> g.apply((AssetCompositeModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetCompositeModel> {
        /**
         * <p>
         * The name of the composite model.
         * </p>
         * 
         * @param name
         *        The name of the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the composite model.
         * </p>
         * 
         * @param description
         *        The description of the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
         * </p>
         * 
         * @param type
         *        The type of the composite model. For alarm composite models, this type is <code>AWS/ALARM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The asset properties that this composite model defines.
         * </p>
         * 
         * @param properties
         *        The asset properties that this composite model defines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<AssetProperty> properties);

        /**
         * <p>
         * The asset properties that this composite model defines.
         * </p>
         * 
         * @param properties
         *        The asset properties that this composite model defines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(AssetProperty... properties);

        /**
         * <p>
         * The asset properties that this composite model defines.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AssetProperty>.Builder} avoiding the
         * need to create one manually via {@link List<AssetProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetProperty>.Builder#build()} is called immediately and
         * its result is passed to {@link #properties(List<AssetProperty>)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link List<AssetProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(List<AssetProperty>)
         */
        Builder properties(Consumer<AssetProperty.Builder>... properties);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String type;

        private List<AssetProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetCompositeModel model) {
            name(model.name);
            description(model.description);
            type(model.type);
            properties(model.properties);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<AssetProperty.Builder> getProperties() {
            List<AssetProperty.Builder> result = AssetPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<AssetProperty.BuilderImpl> properties) {
            this.properties = AssetPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<AssetProperty> properties) {
            this.properties = AssetPropertiesCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(AssetProperty... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<AssetProperty.Builder>... properties) {
            properties(Stream.of(properties).map(c -> AssetProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetCompositeModel build() {
            return new AssetCompositeModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
