/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortalRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<CreatePortalRequest.Builder, CreatePortalRequest> {
    private static final SdkField<String> PORTAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalName").getter(getter(CreatePortalRequest::portalName)).setter(setter(Builder::portalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalName").build()).build();

    private static final SdkField<String> PORTAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalDescription").getter(getter(CreatePortalRequest::portalDescription))
            .setter(setter(Builder::portalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDescription").build()).build();

    private static final SdkField<String> PORTAL_CONTACT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalContactEmail").getter(getter(CreatePortalRequest::portalContactEmail))
            .setter(setter(Builder::portalContactEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContactEmail").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreatePortalRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ImageFile> PORTAL_LOGO_IMAGE_FILE_FIELD = SdkField
            .<ImageFile> builder(MarshallingType.SDK_POJO).memberName("portalLogoImageFile")
            .getter(getter(CreatePortalRequest::portalLogoImageFile)).setter(setter(Builder::portalLogoImageFile))
            .constructor(ImageFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLogoImageFile").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreatePortalRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreatePortalRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PORTAL_AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalAuthMode").getter(getter(CreatePortalRequest::portalAuthModeAsString))
            .setter(setter(Builder::portalAuthMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalAuthMode").build()).build();

    private static final SdkField<String> NOTIFICATION_SENDER_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationSenderEmail").getter(getter(CreatePortalRequest::notificationSenderEmail))
            .setter(setter(Builder::notificationSenderEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSenderEmail").build())
            .build();

    private static final SdkField<Alarms> ALARMS_FIELD = SdkField.<Alarms> builder(MarshallingType.SDK_POJO).memberName("alarms")
            .getter(getter(CreatePortalRequest::alarms)).setter(setter(Builder::alarms)).constructor(Alarms::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_NAME_FIELD,
            PORTAL_DESCRIPTION_FIELD, PORTAL_CONTACT_EMAIL_FIELD, CLIENT_TOKEN_FIELD, PORTAL_LOGO_IMAGE_FILE_FIELD,
            ROLE_ARN_FIELD, TAGS_FIELD, PORTAL_AUTH_MODE_FIELD, NOTIFICATION_SENDER_EMAIL_FIELD, ALARMS_FIELD));

    private final String portalName;

    private final String portalDescription;

    private final String portalContactEmail;

    private final String clientToken;

    private final ImageFile portalLogoImageFile;

    private final String roleArn;

    private final Map<String, String> tags;

    private final String portalAuthMode;

    private final String notificationSenderEmail;

    private final Alarms alarms;

    private CreatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.portalName = builder.portalName;
        this.portalDescription = builder.portalDescription;
        this.portalContactEmail = builder.portalContactEmail;
        this.clientToken = builder.clientToken;
        this.portalLogoImageFile = builder.portalLogoImageFile;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.portalAuthMode = builder.portalAuthMode;
        this.notificationSenderEmail = builder.notificationSenderEmail;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * A friendly name for the portal.
     * </p>
     * 
     * @return A friendly name for the portal.
     */
    public final String portalName() {
        return portalName;
    }

    /**
     * <p>
     * A description for the portal.
     * </p>
     * 
     * @return A description for the portal.
     */
    public final String portalDescription() {
        return portalDescription;
    }

    /**
     * <p>
     * The Amazon Web Services administrator's contact email address.
     * </p>
     * 
     * @return The Amazon Web Services administrator's contact email address.
     */
    public final String portalContactEmail() {
        return portalContactEmail;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a dark
     * background.
     * </p>
     * 
     * @return A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on
     *         a dark background.
     */
    public final ImageFile portalLogoImageFile() {
        return portalLogoImageFile;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service
     * role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information,
     * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a
     *         service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     *         roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the portal. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the portal. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
     *         SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The service to use to authenticate users to the portal. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user
     * permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web
     * Services SSO. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling
     * Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web
     * Services Regions other than the China Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user
     * permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change this value after you create a portal.
     * </p>
     * <p>
     * Default: <code>SSO</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalAuthMode}
     * will return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalAuthModeAsString}.
     * </p>
     * 
     * @return The service to use to authenticate users to the portal. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
     *         user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable
     *         Amazon Web Services SSO. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso"
     *         >Enabling Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only
     *         available in Amazon Web Services Regions other than the China Regions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user
     *         permissions.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can't change this value after you create a portal.
     *         </p>
     *         <p>
     *         Default: <code>SSO</code>
     * @see AuthMode
     */
    public final AuthMode portalAuthMode() {
        return AuthMode.fromValue(portalAuthMode);
    }

    /**
     * <p>
     * The service to use to authenticate users to the portal. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user
     * permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web
     * Services SSO. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling
     * Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon Web
     * Services Regions other than the China Regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user
     * permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't change this value after you create a portal.
     * </p>
     * <p>
     * Default: <code>SSO</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalAuthMode}
     * will return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalAuthModeAsString}.
     * </p>
     * 
     * @return The service to use to authenticate users to the portal. Choose from the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
     *         user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable
     *         Amazon Web Services SSO. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso"
     *         >Enabling Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only
     *         available in Amazon Web Services Regions other than the China Regions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user
     *         permissions.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can't change this value after you create a portal.
     *         </p>
     *         <p>
     *         Default: <code>SSO</code>
     * @see AuthMode
     */
    public final String portalAuthModeAsString() {
        return portalAuthMode;
    }

    /**
     * <p>
     * The email address that sends alarm notifications.
     * </p>
     * <important>
     * <p>
     * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT
     * Events managed Lambda function</a> to manage your emails, you must <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email
     * address in Amazon SES</a>.
     * </p>
     * </important>
     * 
     * @return The email address that sends alarm notifications.</p> <important>
     *         <p>
     *         If you use the <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events managed
     *         Lambda function</a> to manage your emails, you must <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the
     *         sender email address in Amazon SES</a>.
     *         </p>
     */
    public final String notificationSenderEmail() {
        return notificationSenderEmail;
    }

    /**
     * <p>
     * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the
     * alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in
     * the <i>IoT SiteWise Application Guide</i>.
     * </p>
     * 
     * @return Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use
     *         the alarm to monitor an asset property and get notified when the asset property value is outside a
     *         specified range. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
     *         alarms</a> in the <i>IoT SiteWise Application Guide</i>.
     */
    public final Alarms alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalName());
        hashCode = 31 * hashCode + Objects.hashCode(portalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(portalContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(portalLogoImageFile());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(portalAuthModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notificationSenderEmail());
        hashCode = 31 * hashCode + Objects.hashCode(alarms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalRequest)) {
            return false;
        }
        CreatePortalRequest other = (CreatePortalRequest) obj;
        return Objects.equals(portalName(), other.portalName()) && Objects.equals(portalDescription(), other.portalDescription())
                && Objects.equals(portalContactEmail(), other.portalContactEmail())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(portalLogoImageFile(), other.portalLogoImageFile())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(portalAuthModeAsString(), other.portalAuthModeAsString())
                && Objects.equals(notificationSenderEmail(), other.notificationSenderEmail())
                && Objects.equals(alarms(), other.alarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePortalRequest").add("PortalName", portalName())
                .add("PortalDescription", portalDescription()).add("PortalContactEmail", portalContactEmail())
                .add("ClientToken", clientToken()).add("PortalLogoImageFile", portalLogoImageFile()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("PortalAuthMode", portalAuthModeAsString())
                .add("NotificationSenderEmail", notificationSenderEmail()).add("Alarms", alarms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalName":
            return Optional.ofNullable(clazz.cast(portalName()));
        case "portalDescription":
            return Optional.ofNullable(clazz.cast(portalDescription()));
        case "portalContactEmail":
            return Optional.ofNullable(clazz.cast(portalContactEmail()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "portalLogoImageFile":
            return Optional.ofNullable(clazz.cast(portalLogoImageFile()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "portalAuthMode":
            return Optional.ofNullable(clazz.cast(portalAuthModeAsString()));
        case "notificationSenderEmail":
            return Optional.ofNullable(clazz.cast(notificationSenderEmail()));
        case "alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalRequest, T> g) {
        return obj -> g.apply((CreatePortalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePortalRequest> {
        /**
         * <p>
         * A friendly name for the portal.
         * </p>
         * 
         * @param portalName
         *        A friendly name for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalName(String portalName);

        /**
         * <p>
         * A description for the portal.
         * </p>
         * 
         * @param portalDescription
         *        A description for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalDescription(String portalDescription);

        /**
         * <p>
         * The Amazon Web Services administrator's contact email address.
         * </p>
         * 
         * @param portalContactEmail
         *        The Amazon Web Services administrator's contact email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalContactEmail(String portalContactEmail);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a
         * dark background.
         * </p>
         * 
         * @param portalLogoImageFile
         *        A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed
         *        on a dark background.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalLogoImageFile(ImageFile portalLogoImageFile);

        /**
         * <p>
         * A logo image to display in the portal. Upload a square, high-resolution image. The image is displayed on a
         * dark background.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageFile.Builder} avoiding the need to
         * create one manually via {@link ImageFile#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageFile.Builder#build()} is called immediately and its result
         * is passed to {@link #portalLogoImageFile(ImageFile)}.
         * 
         * @param portalLogoImageFile
         *        a consumer that will call methods on {@link ImageFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalLogoImageFile(ImageFile)
         */
        default Builder portalLogoImageFile(Consumer<ImageFile.Builder> portalLogoImageFile) {
            return portalLogoImageFile(ImageFile.builder().applyMutation(portalLogoImageFile).build());
        }

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service
         * role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
         * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a
         *        service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using
         *        service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the portal. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the portal. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
         *        SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The service to use to authenticate users to the portal. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user
         * permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web
         * Services SSO. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling
         * Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon
         * Web Services Regions other than the China Regions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user
         * permissions.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can't change this value after you create a portal.
         * </p>
         * <p>
         * Default: <code>SSO</code>
         * </p>
         * 
         * @param portalAuthMode
         *        The service to use to authenticate users to the portal. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
         *        user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable
         *        Amazon Web Services SSO. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso"
         *        >Enabling Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only
         *        available in Amazon Web Services Regions other than the China Regions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
         *        user permissions.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can't change this value after you create a portal.
         *        </p>
         *        <p>
         *        Default: <code>SSO</code>
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder portalAuthMode(String portalAuthMode);

        /**
         * <p>
         * The service to use to authenticate users to the portal. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage user
         * permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable Amazon Web
         * Services SSO. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling
         * Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only available in Amazon
         * Web Services Regions other than the China Regions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage user
         * permissions.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can't change this value after you create a portal.
         * </p>
         * <p>
         * Default: <code>SSO</code>
         * </p>
         * 
         * @param portalAuthMode
         *        The service to use to authenticate users to the portal. Choose from the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSO</code> – The portal uses Amazon Web Services Single Sign On to authenticate users and manage
         *        user permissions. Before you can create a portal that uses Amazon Web Services SSO, you must enable
         *        Amazon Web Services SSO. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso"
         *        >Enabling Amazon Web Services SSO</a> in the <i>IoT SiteWise User Guide</i>. This option is only
         *        available in Amazon Web Services Regions other than the China Regions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IAM</code> – The portal uses Identity and Access Management to authenticate users and manage
         *        user permissions.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can't change this value after you create a portal.
         *        </p>
         *        <p>
         *        Default: <code>SSO</code>
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder portalAuthMode(AuthMode portalAuthMode);

        /**
         * <p>
         * The email address that sends alarm notifications.
         * </p>
         * <important>
         * <p>
         * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT
         * Events managed Lambda function</a> to manage your emails, you must <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender
         * email address in Amazon SES</a>.
         * </p>
         * </important>
         * 
         * @param notificationSenderEmail
         *        The email address that sends alarm notifications.</p> <important>
         *        <p>
         *        If you use the <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">IoT Events
         *        managed Lambda function</a> to manage your emails, you must <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the
         *        sender email address in Amazon SES</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSenderEmail(String notificationSenderEmail);

        /**
         * <p>
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the
         * alarm to monitor an asset property and get notified when the asset property value is outside a specified
         * range. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
         * alarms</a> in the <i>IoT SiteWise Application Guide</i>.
         * </p>
         * 
         * @param alarms
         *        Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can
         *        use the alarm to monitor an asset property and get notified when the asset property value is outside a
         *        specified range. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
         *        alarms</a> in the <i>IoT SiteWise Application Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarms alarms);

        /**
         * <p>
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the
         * alarm to monitor an asset property and get notified when the asset property value is outside a specified
         * range. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
         * alarms</a> in the <i>IoT SiteWise Application Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Alarms.Builder} avoiding the need to
         * create one manually via {@link Alarms#builder()}.
         *
         * When the {@link Consumer} completes, {@link Alarms.Builder#build()} is called immediately and its result is
         * passed to {@link #alarms(Alarms)}.
         * 
         * @param alarms
         *        a consumer that will call methods on {@link Alarms.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarms(Alarms)
         */
        default Builder alarms(Consumer<Alarms.Builder> alarms) {
            return alarms(Alarms.builder().applyMutation(alarms).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String portalName;

        private String portalDescription;

        private String portalContactEmail;

        private String clientToken;

        private ImageFile portalLogoImageFile;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String portalAuthMode;

        private String notificationSenderEmail;

        private Alarms alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalRequest model) {
            super(model);
            portalName(model.portalName);
            portalDescription(model.portalDescription);
            portalContactEmail(model.portalContactEmail);
            clientToken(model.clientToken);
            portalLogoImageFile(model.portalLogoImageFile);
            roleArn(model.roleArn);
            tags(model.tags);
            portalAuthMode(model.portalAuthMode);
            notificationSenderEmail(model.notificationSenderEmail);
            alarms(model.alarms);
        }

        public final String getPortalName() {
            return portalName;
        }

        public final void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        @Override
        public final Builder portalName(String portalName) {
            this.portalName = portalName;
            return this;
        }

        public final String getPortalDescription() {
            return portalDescription;
        }

        public final void setPortalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
        }

        @Override
        public final Builder portalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        public final String getPortalContactEmail() {
            return portalContactEmail;
        }

        public final void setPortalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
        }

        @Override
        public final Builder portalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ImageFile.Builder getPortalLogoImageFile() {
            return portalLogoImageFile != null ? portalLogoImageFile.toBuilder() : null;
        }

        public final void setPortalLogoImageFile(ImageFile.BuilderImpl portalLogoImageFile) {
            this.portalLogoImageFile = portalLogoImageFile != null ? portalLogoImageFile.build() : null;
        }

        @Override
        public final Builder portalLogoImageFile(ImageFile portalLogoImageFile) {
            this.portalLogoImageFile = portalLogoImageFile;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPortalAuthMode() {
            return portalAuthMode;
        }

        public final void setPortalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
        }

        @Override
        public final Builder portalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
            return this;
        }

        @Override
        public final Builder portalAuthMode(AuthMode portalAuthMode) {
            this.portalAuthMode(portalAuthMode == null ? null : portalAuthMode.toString());
            return this;
        }

        public final String getNotificationSenderEmail() {
            return notificationSenderEmail;
        }

        public final void setNotificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
        }

        @Override
        public final Builder notificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
            return this;
        }

        public final Alarms.Builder getAlarms() {
            return alarms != null ? alarms.toBuilder() : null;
        }

        public final void setAlarms(Alarms.BuilderImpl alarms) {
            this.alarms = alarms != null ? alarms.build() : null;
        }

        @Override
        public final Builder alarms(Alarms alarms) {
            this.alarms = alarms;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePortalRequest build() {
            return new CreatePortalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
