/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an interpolated asset property value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InterpolatedAssetPropertyValue implements SdkPojo, Serializable,
        ToCopyableBuilder<InterpolatedAssetPropertyValue.Builder, InterpolatedAssetPropertyValue> {
    private static final SdkField<TimeInNanos> TIMESTAMP_FIELD = SdkField.<TimeInNanos> builder(MarshallingType.SDK_POJO)
            .memberName("timestamp").getter(getter(InterpolatedAssetPropertyValue::timestamp)).setter(setter(Builder::timestamp))
            .constructor(TimeInNanos::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<Variant> VALUE_FIELD = SdkField.<Variant> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(InterpolatedAssetPropertyValue::value)).setter(setter(Builder::value)).constructor(Variant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TimeInNanos timestamp;

    private final Variant value;

    private InterpolatedAssetPropertyValue(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.value = builder.value;
    }

    /**
     * Returns the value of the Timestamp property for this object.
     * 
     * @return The value of the Timestamp property for this object.
     */
    public final TimeInNanos timestamp() {
        return timestamp;
    }

    /**
     * Returns the value of the Value property for this object.
     * 
     * @return The value of the Value property for this object.
     */
    public final Variant value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterpolatedAssetPropertyValue)) {
            return false;
        }
        InterpolatedAssetPropertyValue other = (InterpolatedAssetPropertyValue) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InterpolatedAssetPropertyValue").add("Timestamp", timestamp()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InterpolatedAssetPropertyValue, T> g) {
        return obj -> g.apply((InterpolatedAssetPropertyValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InterpolatedAssetPropertyValue> {
        /**
         * Sets the value of the Timestamp property for this object.
         *
         * @param timestamp
         *        The new value for the Timestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(TimeInNanos timestamp);

        /**
         * Sets the value of the Timestamp property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimeInNanos.Builder} avoiding the need to
         * create one manually via {@link TimeInNanos#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeInNanos.Builder#build()} is called immediately and its result
         * is passed to {@link #timestamp(TimeInNanos)}.
         * 
         * @param timestamp
         *        a consumer that will call methods on {@link TimeInNanos.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestamp(TimeInNanos)
         */
        default Builder timestamp(Consumer<TimeInNanos.Builder> timestamp) {
            return timestamp(TimeInNanos.builder().applyMutation(timestamp).build());
        }

        /**
         * Sets the value of the Value property for this object.
         *
         * @param value
         *        The new value for the Value property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Variant value);

        /**
         * Sets the value of the Value property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Variant.Builder} avoiding the need to
         * create one manually via {@link Variant#builder()}.
         *
         * When the {@link Consumer} completes, {@link Variant.Builder#build()} is called immediately and its result is
         * passed to {@link #value(Variant)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link Variant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(Variant)
         */
        default Builder value(Consumer<Variant.Builder> value) {
            return value(Variant.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimeInNanos timestamp;

        private Variant value;

        private BuilderImpl() {
        }

        private BuilderImpl(InterpolatedAssetPropertyValue model) {
            timestamp(model.timestamp);
            value(model.value);
        }

        public final TimeInNanos.Builder getTimestamp() {
            return timestamp != null ? timestamp.toBuilder() : null;
        }

        public final void setTimestamp(TimeInNanos.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        @Override
        public final Builder timestamp(TimeInNanos timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Variant.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(Variant.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(Variant value) {
            this.value = value;
            return this;
        }

        @Override
        public InterpolatedAssetPropertyValue build() {
            return new InterpolatedAssetPropertyValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
