/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains asset property information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Property implements SdkPojo, Serializable, ToCopyableBuilder<Property.Builder, Property> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Property::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Property::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(Property::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<PropertyNotification> NOTIFICATION_FIELD = SdkField
            .<PropertyNotification> builder(MarshallingType.SDK_POJO).memberName("notification")
            .getter(getter(Property::notification)).setter(setter(Builder::notification))
            .constructor(PropertyNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notification").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataType").getter(getter(Property::dataTypeAsString)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(Property::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<PropertyType> TYPE_FIELD = SdkField.<PropertyType> builder(MarshallingType.SDK_POJO)
            .memberName("type").getter(getter(Property::type)).setter(setter(Builder::type)).constructor(PropertyType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ALIAS_FIELD, NOTIFICATION_FIELD, DATA_TYPE_FIELD, UNIT_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String alias;

    private final PropertyNotification notification;

    private final String dataType;

    private final String unit;

    private final PropertyType type;

    private Property(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.alias = builder.alias;
        this.notification = builder.notification;
        this.dataType = builder.dataType;
        this.unit = builder.unit;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID of the asset property.
     * </p>
     * 
     * @return The ID of the asset property.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the property.
     * </p>
     * 
     * @return The name of the property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
     * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The asset property's notification topic and state. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * 
     * @return The asset property's notification topic and state. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     *         >UpdateAssetProperty</a>.
     */
    public final PropertyNotification notification() {
        return notification;
    }

    /**
     * <p>
     * The property data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The property data type.
     * @see PropertyDataType
     */
    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(dataType);
    }

    /**
     * <p>
     * The property data type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataType} will
     * return {@link PropertyDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataTypeAsString}.
     * </p>
     * 
     * @return The property data type.
     * @see PropertyDataType
     */
    public final String dataTypeAsString() {
        return dataType;
    }

    /**
     * <p>
     * The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.
     * </p>
     * 
     * @return The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * The property type (see <code>PropertyType</code>). A property contains one type.
     * </p>
     * 
     * @return The property type (see <code>PropertyType</code>). A property contains one type.
     */
    public final PropertyType type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(alias(), other.alias())
                && Objects.equals(notification(), other.notification())
                && Objects.equals(dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(unit(), other.unit())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Property").add("Id", id()).add("Name", name()).add("Alias", alias())
                .add("Notification", notification()).add("DataType", dataTypeAsString()).add("Unit", unit()).add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataTypeAsString()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Property, T> g) {
        return obj -> g.apply((Property) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Property> {
        /**
         * <p>
         * The ID of the asset property.
         * </p>
         * 
         * @param id
         *        The ID of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the property.
         * </p>
         * 
         * @param name
         *        The name of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
         * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param alias
         *        The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         *        <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The asset property's notification topic and state. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
         * >UpdateAssetProperty</a>.
         * </p>
         * 
         * @param notification
         *        The asset property's notification topic and state. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
         *        >UpdateAssetProperty</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(PropertyNotification notification);

        /**
         * <p>
         * The asset property's notification topic and state. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
         * >UpdateAssetProperty</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyNotification.Builder} avoiding
         * the need to create one manually via {@link PropertyNotification#builder()}.
         *
         * When the {@link Consumer} completes, {@link PropertyNotification.Builder#build()} is called immediately and
         * its result is passed to {@link #notification(PropertyNotification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link PropertyNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(PropertyNotification)
         */
        default Builder notification(Consumer<PropertyNotification.Builder> notification) {
            return notification(PropertyNotification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The property data type.
         * </p>
         * 
         * @param dataType
         *        The property data type.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(String dataType);

        /**
         * <p>
         * The property data type.
         * </p>
         * 
         * @param dataType
         *        The property data type.
         * @see PropertyDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyDataType
         */
        Builder dataType(PropertyDataType dataType);

        /**
         * <p>
         * The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.
         * </p>
         * 
         * @param unit
         *        The unit (such as <code>Newtons</code> or <code>RPM</code>) of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * The property type (see <code>PropertyType</code>). A property contains one type.
         * </p>
         * 
         * @param type
         *        The property type (see <code>PropertyType</code>). A property contains one type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(PropertyType type);

        /**
         * <p>
         * The property type (see <code>PropertyType</code>). A property contains one type.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertyType.Builder} avoiding the need
         * to create one manually via {@link PropertyType#builder()}.
         *
         * When the {@link Consumer} completes, {@link PropertyType.Builder#build()} is called immediately and its
         * result is passed to {@link #type(PropertyType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link PropertyType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(PropertyType)
         */
        default Builder type(Consumer<PropertyType.Builder> type) {
            return type(PropertyType.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String alias;

        private PropertyNotification notification;

        private String dataType;

        private String unit;

        private PropertyType type;

        private BuilderImpl() {
        }

        private BuilderImpl(Property model) {
            id(model.id);
            name(model.name);
            alias(model.alias);
            notification(model.notification);
            dataType(model.dataType);
            unit(model.unit);
            type(model.type);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final PropertyNotification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        public final void setNotification(PropertyNotification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(PropertyNotification notification) {
            this.notification = notification;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PropertyType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(PropertyType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        @Override
        public Property build() {
            return new Property(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
