/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.ImageFile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Image.getter(Image::id)).setter(Image.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ImageFile> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(Image.getter(Image::file)).setter(Image.setter(Builder::file)).constructor(ImageFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final ImageFile file;

    private Image(BuilderImpl builder) {
        this.id = builder.id;
        this.file = builder.file;
    }

    public final String id() {
        return this.id;
    }

    public final ImageFile file() {
        return this.file;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.file(), other.file());
    }

    public final String toString() {
        return ToString.builder((String)"Image").add("Id", (Object)this.id()).add("File", (Object)this.file()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private ImageFile file;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.id(model.id);
            this.file(model.file);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ImageFile.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(ImageFile.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        public final Builder file(ImageFile file) {
            this.file = file;
            return this;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder id(String var1);

        public Builder file(ImageFile var1);

        default public Builder file(Consumer<ImageFile.Builder> file) {
            return this.file((ImageFile)((ImageFile.Builder)ImageFile.builder().applyMutation(file)).build());
        }
    }
}

