/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of an asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetSummary implements SdkPojo, Serializable, ToCopyableBuilder<AssetSummary.Builder, AssetSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AssetSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(AssetSummary::assetModelId)).setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(AssetSummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateDate").getter(getter(AssetSummary::lastUpdateDate)).setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()).build();

    private static final SdkField<AssetStatus> STATUS_FIELD = SdkField.<AssetStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(AssetSummary::status)).setter(setter(Builder::status))
            .constructor(AssetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<AssetHierarchy>> HIERARCHIES_FIELD = SdkField
            .<List<AssetHierarchy>> builder(MarshallingType.LIST)
            .memberName("hierarchies")
            .getter(getter(AssetSummary::hierarchies))
            .setter(setter(Builder::hierarchies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetHierarchy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetHierarchy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssetSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, ASSET_MODEL_ID_FIELD, CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD, STATUS_FIELD, HIERARCHIES_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String assetModelId;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private final AssetStatus status;

    private final List<AssetHierarchy> hierarchies;

    private final String description;

    private AssetSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.assetModelId = builder.assetModelId;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
        this.status = builder.status;
        this.hierarchies = builder.hierarchies;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the asset.
     * </p>
     * 
     * @return The ID of the asset.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the asset,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         asset, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the asset.
     * </p>
     * 
     * @return The name of the asset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the asset model used to create this asset.
     * </p>
     * 
     * @return The ID of the asset model used to create this asset.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The date the asset was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset was created, in Unix epoch time.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the asset was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the asset was last updated, in Unix epoch time.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    /**
     * <p>
     * The current status of the asset.
     * </p>
     * 
     * @return The current status of the asset.
     */
    public final AssetStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hierarchies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHierarchies() {
        return hierarchies != null && !(hierarchies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
     * parent/child asset relationships.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHierarchies} method.
     * </p>
     * 
     * @return A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
     *         parent/child asset relationships.
     */
    public final List<AssetHierarchy> hierarchies() {
        return hierarchies;
    }

    /**
     * <p>
     * A description for the asset.
     * </p>
     * 
     * @return A description for the asset.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasHierarchies() ? hierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetSummary)) {
            return false;
        }
        AssetSummary other = (AssetSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(assetModelId(), other.assetModelId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate()) && Objects.equals(status(), other.status())
                && hasHierarchies() == other.hasHierarchies() && Objects.equals(hierarchies(), other.hierarchies())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("AssetModelId", assetModelId()).add("CreationDate", creationDate()).add("LastUpdateDate", lastUpdateDate())
                .add("Status", status()).add("Hierarchies", hasHierarchies() ? hierarchies() : null)
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "hierarchies":
            return Optional.ofNullable(clazz.cast(hierarchies()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetSummary, T> g) {
        return obj -> g.apply((AssetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetSummary> {
        /**
         * <p>
         * The ID of the asset.
         * </p>
         * 
         * @param id
         *        The ID of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * asset, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the asset, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the asset.
         * </p>
         * 
         * @param name
         *        The name of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the asset model used to create this asset.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model used to create this asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The date the asset was created, in Unix epoch time.
         * </p>
         * 
         * @param creationDate
         *        The date the asset was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the asset was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date the asset was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);

        /**
         * <p>
         * The current status of the asset.
         * </p>
         * 
         * @param status
         *        The current status of the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AssetStatus status);

        /**
         * <p>
         * The current status of the asset.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetStatus.Builder} avoiding the need to
         * create one manually via {@link AssetStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssetStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #status(AssetStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AssetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AssetStatus)
         */
        default Builder status(Consumer<AssetStatus.Builder> status) {
            return status(AssetStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * 
         * @param hierarchies
         *        A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies
         *        allowed parent/child asset relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchies(Collection<AssetHierarchy> hierarchies);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * 
         * @param hierarchies
         *        A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies
         *        allowed parent/child asset relationships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchies(AssetHierarchy... hierarchies);

        /**
         * <p>
         * A list of asset hierarchies that each contain a <code>hierarchyId</code>. A hierarchy specifies allowed
         * parent/child asset relationships.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AssetHierarchy>.Builder} avoiding
         * the need to create one manually via {@link List<AssetHierarchy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetHierarchy>.Builder#build()} is called immediately and
         * its result is passed to {@link #hierarchies(List<AssetHierarchy>)}.
         * 
         * @param hierarchies
         *        a consumer that will call methods on {@link List<AssetHierarchy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchies(List<AssetHierarchy>)
         */
        Builder hierarchies(Consumer<AssetHierarchy.Builder>... hierarchies);

        /**
         * <p>
         * A description for the asset.
         * </p>
         * 
         * @param description
         *        A description for the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String assetModelId;

        private Instant creationDate;

        private Instant lastUpdateDate;

        private AssetStatus status;

        private List<AssetHierarchy> hierarchies = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            assetModelId(model.assetModelId);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
            status(model.status);
            hierarchies(model.hierarchies);
            description(model.description);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        public final AssetStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AssetStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(AssetStatus status) {
            this.status = status;
            return this;
        }

        public final List<AssetHierarchy.Builder> getHierarchies() {
            List<AssetHierarchy.Builder> result = AssetHierarchiesCopier.copyToBuilder(this.hierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchies(Collection<AssetHierarchy.BuilderImpl> hierarchies) {
            this.hierarchies = AssetHierarchiesCopier.copyFromBuilder(hierarchies);
        }

        @Override
        public final Builder hierarchies(Collection<AssetHierarchy> hierarchies) {
            this.hierarchies = AssetHierarchiesCopier.copy(hierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchies(AssetHierarchy... hierarchies) {
            hierarchies(Arrays.asList(hierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchies(Consumer<AssetHierarchy.Builder>... hierarchies) {
            hierarchies(Stream.of(hierarchies).map(c -> AssetHierarchy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AssetSummary build() {
            return new AssetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
