/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information for an entry that has been processed by the previous <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html"
 * >BatchGetAssetPropertyValueHistory</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyValueHistorySkippedEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetAssetPropertyValueHistorySkippedEntry.Builder, BatchGetAssetPropertyValueHistorySkippedEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryId").getter(getter(BatchGetAssetPropertyValueHistorySkippedEntry::entryId))
            .setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<String> COMPLETION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completionStatus")
            .getter(getter(BatchGetAssetPropertyValueHistorySkippedEntry::completionStatusAsString))
            .setter(setter(Builder::completionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionStatus").build()).build();

    private static final SdkField<BatchGetAssetPropertyValueHistoryErrorInfo> ERROR_INFO_FIELD = SdkField
            .<BatchGetAssetPropertyValueHistoryErrorInfo> builder(MarshallingType.SDK_POJO).memberName("errorInfo")
            .getter(getter(BatchGetAssetPropertyValueHistorySkippedEntry::errorInfo)).setter(setter(Builder::errorInfo))
            .constructor(BatchGetAssetPropertyValueHistoryErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            COMPLETION_STATUS_FIELD, ERROR_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final String completionStatus;

    private final BatchGetAssetPropertyValueHistoryErrorInfo errorInfo;

    private BatchGetAssetPropertyValueHistorySkippedEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.completionStatus = builder.completionStatus;
        this.errorInfo = builder.errorInfo;
    }

    /**
     * <p>
     * The ID of the entry.
     * </p>
     * 
     * @return The ID of the entry.
     */
    public final String entryId() {
        return entryId;
    }

    /**
     * <p>
     * The completion status of each entry that is associated with the <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
     * >BatchGetAssetPropertyValueHistory</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completionStatus}
     * will return {@link BatchEntryCompletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #completionStatusAsString}.
     * </p>
     * 
     * @return The completion status of each entry that is associated with the <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
     *         >BatchGetAssetPropertyValueHistory</a> API.
     * @see BatchEntryCompletionStatus
     */
    public final BatchEntryCompletionStatus completionStatus() {
        return BatchEntryCompletionStatus.fromValue(completionStatus);
    }

    /**
     * <p>
     * The completion status of each entry that is associated with the <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
     * >BatchGetAssetPropertyValueHistory</a> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completionStatus}
     * will return {@link BatchEntryCompletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #completionStatusAsString}.
     * </p>
     * 
     * @return The completion status of each entry that is associated with the <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
     *         >BatchGetAssetPropertyValueHistory</a> API.
     * @see BatchEntryCompletionStatus
     */
    public final String completionStatusAsString() {
        return completionStatus;
    }

    /**
     * <p>
     * The error information, such as the error code and the timestamp.
     * </p>
     * 
     * @return The error information, such as the error code and the timestamp.
     */
    public final BatchGetAssetPropertyValueHistoryErrorInfo errorInfo() {
        return errorInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(completionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyValueHistorySkippedEntry)) {
            return false;
        }
        BatchGetAssetPropertyValueHistorySkippedEntry other = (BatchGetAssetPropertyValueHistorySkippedEntry) obj;
        return Objects.equals(entryId(), other.entryId())
                && Objects.equals(completionStatusAsString(), other.completionStatusAsString())
                && Objects.equals(errorInfo(), other.errorInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyValueHistorySkippedEntry").add("EntryId", entryId())
                .add("CompletionStatus", completionStatusAsString()).add("ErrorInfo", errorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "completionStatus":
            return Optional.ofNullable(clazz.cast(completionStatusAsString()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyValueHistorySkippedEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyValueHistorySkippedEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetAssetPropertyValueHistorySkippedEntry> {
        /**
         * <p>
         * The ID of the entry.
         * </p>
         * 
         * @param entryId
         *        The ID of the entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The completion status of each entry that is associated with the <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
         * >BatchGetAssetPropertyValueHistory</a> API.
         * </p>
         * 
         * @param completionStatus
         *        The completion status of each entry that is associated with the <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
         *        >BatchGetAssetPropertyValueHistory</a> API.
         * @see BatchEntryCompletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchEntryCompletionStatus
         */
        Builder completionStatus(String completionStatus);

        /**
         * <p>
         * The completion status of each entry that is associated with the <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
         * >BatchGetAssetPropertyValueHistory</a> API.
         * </p>
         * 
         * @param completionStatus
         *        The completion status of each entry that is associated with the <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValueHistory.html"
         *        >BatchGetAssetPropertyValueHistory</a> API.
         * @see BatchEntryCompletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchEntryCompletionStatus
         */
        Builder completionStatus(BatchEntryCompletionStatus completionStatus);

        /**
         * <p>
         * The error information, such as the error code and the timestamp.
         * </p>
         * 
         * @param errorInfo
         *        The error information, such as the error code and the timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(BatchGetAssetPropertyValueHistoryErrorInfo errorInfo);

        /**
         * <p>
         * The error information, such as the error code and the timestamp.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchGetAssetPropertyValueHistoryErrorInfo.Builder} avoiding the need to create one manually via
         * {@link BatchGetAssetPropertyValueHistoryErrorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchGetAssetPropertyValueHistoryErrorInfo.Builder#build()} is
         * called immediately and its result is passed to {@link #errorInfo(BatchGetAssetPropertyValueHistoryErrorInfo)}
         * .
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link BatchGetAssetPropertyValueHistoryErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(BatchGetAssetPropertyValueHistoryErrorInfo)
         */
        default Builder errorInfo(Consumer<BatchGetAssetPropertyValueHistoryErrorInfo.Builder> errorInfo) {
            return errorInfo(BatchGetAssetPropertyValueHistoryErrorInfo.builder().applyMutation(errorInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private String completionStatus;

        private BatchGetAssetPropertyValueHistoryErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyValueHistorySkippedEntry model) {
            entryId(model.entryId);
            completionStatus(model.completionStatus);
            errorInfo(model.errorInfo);
        }

        public final String getEntryId() {
            return entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getCompletionStatus() {
            return completionStatus;
        }

        public final void setCompletionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
        }

        @Override
        public final Builder completionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
            return this;
        }

        @Override
        public final Builder completionStatus(BatchEntryCompletionStatus completionStatus) {
            this.completionStatus(completionStatus == null ? null : completionStatus.toString());
            return this;
        }

        public final BatchGetAssetPropertyValueHistoryErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(BatchGetAssetPropertyValueHistoryErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(BatchGetAssetPropertyValueHistoryErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        @Override
        public BatchGetAssetPropertyValueHistorySkippedEntry build() {
            return new BatchGetAssetPropertyValueHistorySkippedEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
